/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.upgrade.acid;

import com.google.common.annotations.VisibleForTesting;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.hive.common.ValidTxnList;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.CompactionResponse;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.GetOpenTxnsInfoResponse;
import org.apache.hadoop.hive.metastore.api.InvalidOperationException;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.ShowCompactResponse;
import org.apache.hadoop.hive.metastore.api.ShowCompactResponseElement;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.txn.TxnStore;
import org.apache.hadoop.hive.metastore.txn.TxnUtils;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.shims.HadoopShims;
import org.apache.hive.common.util.HiveVersionInfo;
import org.apache.orc.OrcFile;
import org.apache.orc.Reader;
import org.apache.orc.impl.AcidStats;
import org.apache.orc.impl.OrcAcidUtils;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpgradeTool {
    private static final Logger LOG = LoggerFactory.getLogger(UpgradeTool.class);
    private static final int PARTITION_BATCH_SIZE = 10000;
    private final Options cmdLineOptions = new Options();
    @VisibleForTesting
    static Callback callback;
    @VisibleForTesting
    static int pollIntervalMs;
    @VisibleForTesting
    static boolean isTestMode;
    @VisibleForTesting
    static HiveConf hiveConf;

    public static void main(String[] args) throws Exception {
        CommandLine line;
        UpgradeTool tool = new UpgradeTool();
        tool.init();
        GnuParser parser = new GnuParser();
        String outputDir = ".";
        boolean preUpgrade = false;
        boolean postUpgrade = false;
        boolean execute = false;
        boolean nonBlocking = false;
        try {
            line = parser.parse(tool.cmdLineOptions, args);
        }
        catch (ParseException e) {
            System.err.println("UpgradeTool: Parsing failed.  Reason: " + e.getLocalizedMessage());
            UpgradeTool.printAndExit(tool);
            return;
        }
        if (line.hasOption("help")) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("upgrade-acid", tool.cmdLineOptions);
            return;
        }
        if (line.hasOption("location")) {
            outputDir = line.getOptionValue("location");
        }
        if (line.hasOption("execute")) {
            execute = true;
        }
        if (line.hasOption("preUpgrade")) {
            preUpgrade = true;
        }
        if (line.hasOption("postUpgrade")) {
            postUpgrade = true;
        }
        LOG.info("Starting with preUpgrade=" + preUpgrade + ", postUpgrade=" + postUpgrade + ", execute=" + execute + ", location=" + outputDir);
        if (preUpgrade && postUpgrade) {
            throw new IllegalArgumentException("Cannot specify both preUpgrade and postUpgrade");
        }
        try {
            String hiveVer = HiveVersionInfo.getShortVersion();
            if (preUpgrade && !hiveVer.startsWith("2.")) {
                throw new IllegalStateException("preUpgrade requires Hive 2.x.  Actual: " + hiveVer);
            }
            if (postUpgrade && execute && !isTestMode && !hiveVer.startsWith("3.")) {
                throw new IllegalStateException("postUpgrade w/execute requires Hive 3.x.  Actual: " + hiveVer);
            }
            tool.prepareAcidUpgradeInternal(outputDir, preUpgrade, postUpgrade, execute);
        }
        catch (Exception ex) {
            LOG.error("UpgradeTool failed", ex);
            throw ex;
        }
    }

    private static void printAndExit(UpgradeTool tool) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("upgrade-acid", tool.cmdLineOptions);
        System.exit(1);
    }

    private void init() {
        try {
            this.cmdLineOptions.addOption(new Option("help", "print this message"));
            this.cmdLineOptions.addOption(new Option("preUpgrade", "Generates a script to execute on 2.x cluster.  This requires 2.x binaries on the classpath and hive-site.xml."));
            this.cmdLineOptions.addOption(new Option("postUpgrade", "Generates a script to execute on 3.x cluster.  This requires 3.x binaries on the classpath and hive-site.xml."));
            Option exec = new Option("execute", "Executes commands equivalent to generated scrips");
            exec.setOptionalArg(true);
            this.cmdLineOptions.addOption(exec);
            this.cmdLineOptions.addOption(new Option("location", true, "Location to write scripts to. Default is CWD."));
        }
        catch (Exception ex) {
            LOG.error("init()", ex);
            throw ex;
        }
    }

    private void prepareAcidUpgradeInternal(String scriptLocation, boolean preUpgrade, boolean postUpgrade, boolean execute) throws HiveException, TException, IOException {
        HiveConf conf = hiveConf != null ? hiveConf : new HiveConf();
        boolean isAcidEnabled = UpgradeTool.isAcidEnabled(conf);
        HiveMetaStoreClient hms = new HiveMetaStoreClient(conf);
        LOG.debug("Looking for databases");
        List databases = hms.getAllDatabases();
        LOG.debug("Found " + databases.size() + " databases to process");
        ArrayList<String> compactions = new ArrayList<String>();
        ArrayList<String> convertToAcid = new ArrayList<String>();
        ArrayList<String> convertToMM = new ArrayList<String>();
        CompactionMetaInfo compactionMetaInfo = new CompactionMetaInfo();
        ValidTxnList txns = null;
        Hive db = null;
        if (execute) {
            db = Hive.get((HiveConf)conf);
        }
        for (String dbName : databases) {
            List tables = hms.getAllTables(dbName);
            LOG.debug("found " + tables.size() + " tables in " + dbName);
            for (String tableName : tables) {
                org.apache.hadoop.hive.metastore.api.Table t = hms.getTable(dbName, tableName);
                LOG.debug("processing table " + Warehouse.getQualifiedName((org.apache.hadoop.hive.metastore.api.Table)t));
                if (preUpgrade && isAcidEnabled) {
                    if (execute && txns == null) {
                        TxnStore txnHandler = TxnUtils.getTxnStore((HiveConf)conf);
                        txns = TxnUtils.createValidCompactTxnList((GetOpenTxnsInfoResponse)txnHandler.getOpenTxnsInfo());
                    }
                    List<String> compactionCommands = UpgradeTool.getCompactionCommands(t, conf, hms, compactionMetaInfo, execute, db, txns);
                    compactions.addAll(compactionCommands);
                }
                if (!postUpgrade || !isAcidEnabled) continue;
                UpgradeTool.processConversion(t, convertToAcid, convertToMM, hms, db, execute);
            }
        }
        UpgradeTool.makeCompactionScript(compactions, scriptLocation, compactionMetaInfo);
        UpgradeTool.makeConvertTableScript(convertToAcid, convertToMM, scriptLocation);
        UpgradeTool.makeRenameFileScript(scriptLocation);
        if (preUpgrade && execute) {
            while (compactionMetaInfo.compactionIds.size() > 0) {
                LOG.debug("Will wait for " + compactionMetaInfo.compactionIds.size() + " compactions to complete");
                ShowCompactResponse resp = db.showCompactions();
                block19: for (ShowCompactResponseElement e : resp.getCompacts()) {
                    String state;
                    switch (state = e.getState()) {
                        case "ready for cleaning": 
                        case "succeeded": {
                            boolean removed = compactionMetaInfo.compactionIds.remove(e.getId());
                            if (!removed) continue block19;
                            LOG.debug("Required compaction succeeded: " + e.toString());
                            continue block19;
                        }
                        case "attempted": 
                        case "failed": {
                            boolean removed = compactionMetaInfo.compactionIds.remove(e.getId());
                            if (!removed) continue block19;
                            LOG.warn("Required compaction failed: " + e.toString());
                            continue block19;
                        }
                        case "initiated": {
                            continue block19;
                        }
                        case "working": {
                            LOG.debug("Still working on: " + e.toString());
                            continue block19;
                        }
                    }
                    LOG.error("Unexpected state for : " + e.toString());
                }
                if (compactionMetaInfo.compactionIds.size() <= 0) continue;
                try {
                    if (callback != null) {
                        callback.onWaitForCompaction();
                    }
                    Thread.sleep(pollIntervalMs);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    private static void alterTable(org.apache.hadoop.hive.metastore.api.Table t, Hive db, boolean isMM) throws HiveException, InvalidOperationException {
        Table metaTable = new Table(t.deepCopy());
        metaTable.getParameters().put("transactional", "true");
        if (isMM) {
            metaTable.getParameters().put("transactional_properties", "insert_only");
        }
        db.alterTable(Warehouse.getQualifiedName((org.apache.hadoop.hive.metastore.api.Table)t), metaTable, false, null);
    }

    private static void processConversion(org.apache.hadoop.hive.metastore.api.Table t, List<String> convertToAcid, List<String> convertToMM, HiveMetaStoreClient hms, Hive db, boolean execute) throws TException, HiveException {
        if (UpgradeTool.isFullAcidTable(t)) {
            return;
        }
        if (!TableType.MANAGED_TABLE.name().equalsIgnoreCase(t.getTableType())) {
            return;
        }
        String fullTableName = Warehouse.getQualifiedName((org.apache.hadoop.hive.metastore.api.Table)t);
        if (t.getPartitionKeysSize() <= 0) {
            if (UpgradeTool.canBeMadeAcid(fullTableName, t.getSd())) {
                convertToAcid.add("ALTER TABLE " + Warehouse.getQualifiedName((org.apache.hadoop.hive.metastore.api.Table)t) + " SET TBLPROPERTIES ('transactional'='true')");
                if (execute) {
                    UpgradeTool.alterTable(t, db, false);
                }
            } else {
                convertToMM.add("ALTER TABLE " + Warehouse.getQualifiedName((org.apache.hadoop.hive.metastore.api.Table)t) + " SET TBLPROPERTIES ('transactional'='true', 'transactional_properties'='insert_only')");
                if (execute) {
                    UpgradeTool.alterTable(t, db, true);
                }
            }
        } else {
            List partitionList;
            List partNames = hms.listPartitionNames(t.getDbName(), t.getTableName(), (short)-1);
            int batchSize = 10000;
            int numWholeBatches = partNames.size() / batchSize;
            for (int i = 0; i < numWholeBatches; ++i) {
                List partitionList2 = hms.getPartitionsByNames(t.getDbName(), t.getTableName(), partNames.subList(i * batchSize, (i + 1) * batchSize));
                if (!UpgradeTool.alterTable(fullTableName, partitionList2, convertToMM, t, db, execute)) continue;
                return;
            }
            if (numWholeBatches * batchSize < partNames.size() && UpgradeTool.alterTable(fullTableName, partitionList = hms.getPartitionsByNames(t.getDbName(), t.getTableName(), partNames.subList(numWholeBatches * batchSize, partNames.size())), convertToMM, t, db, execute)) {
                return;
            }
            convertToAcid.add("ALTER TABLE " + Warehouse.getQualifiedName((org.apache.hadoop.hive.metastore.api.Table)t) + " SET TBLPROPERTIES ('transactional'='true')");
            if (execute) {
                UpgradeTool.alterTable(t, db, false);
            }
        }
    }

    private static boolean alterTable(String fullTableName, List<Partition> partitionList, List<String> convertToMM, org.apache.hadoop.hive.metastore.api.Table t, Hive db, boolean execute) throws InvalidOperationException, HiveException {
        for (Partition p : partitionList) {
            if (UpgradeTool.canBeMadeAcid(fullTableName, p.getSd())) continue;
            convertToMM.add("ALTER TABLE " + Warehouse.getQualifiedName((org.apache.hadoop.hive.metastore.api.Table)t) + " SET TBLPROPERTIES ('transactional'='true', 'transactional_properties'='insert_only')");
            if (execute) {
                UpgradeTool.alterTable(t, db, true);
            }
            return true;
        }
        return false;
    }

    private static boolean canBeMadeAcid(String fullTableName, StorageDescriptor sd) {
        return UpgradeTool.isAcidInputOutputFormat(fullTableName, sd) && sd.getSortColsSize() <= 0;
    }

    private static boolean isAcidInputOutputFormat(String fullTableName, StorageDescriptor sd) {
        try {
            Class<?> outputFormatClass;
            Class<?> inputFormatClass = sd.getInputFormat() == null ? null : Class.forName(sd.getInputFormat());
            Class<?> clazz = outputFormatClass = sd.getOutputFormat() == null ? null : Class.forName(sd.getOutputFormat());
            if (inputFormatClass != null && outputFormatClass != null && Class.forName("org.apache.hadoop.hive.ql.io.AcidInputFormat").isAssignableFrom(inputFormatClass) && Class.forName("org.apache.hadoop.hive.ql.io.AcidOutputFormat").isAssignableFrom(outputFormatClass)) {
                return true;
            }
        }
        catch (ClassNotFoundException e) {
            LOG.error("Could not determine if " + fullTableName + " can be made Acid due to: " + e.getMessage(), e);
            return false;
        }
        return false;
    }

    private static void makeCompactionScript(List<String> commands, String scriptLocation, CompactionMetaInfo compactionMetaInfo) throws IOException {
        if (commands.isEmpty()) {
            LOG.info("No compaction is necessary");
            return;
        }
        String fileName = "compacts_" + System.currentTimeMillis() + ".sql";
        LOG.debug("Writing compaction commands to " + fileName);
        try (PrintWriter pw = UpgradeTool.createScript(commands, fileName, scriptLocation);){
            pw.println("-- Generated total of " + commands.size() + " compaction commands");
            if ((double)compactionMetaInfo.numberOfBytes < Math.pow(2.0, 20.0)) {
                pw.println("-- The total volume of data to be compacted is " + String.format("%.6fMB", (double)compactionMetaInfo.numberOfBytes / Math.pow(2.0, 20.0)));
            } else {
                pw.println("-- The total volume of data to be compacted is " + String.format("%.3fGB", (double)compactionMetaInfo.numberOfBytes / Math.pow(2.0, 30.0)));
            }
            pw.println();
            pw.println("-- Please note that compaction may be a heavyweight and time consuming process.\n-- Submitting all of these commands will enqueue them to a scheduling queue from\n-- which they will be picked up by compactor Workers.  The max number of\n-- concurrent Workers is controlled by hive.compactor.worker.threads configured\n-- for the standalone metastore process.  Compaction itself is a Map-Reduce job\n-- which is submitted to the YARN queue identified by hive.compactor.job.queue\n-- property if defined or 'default' if not defined.  It's advisable to set the\n-- capacity of this queue appropriately");
        }
    }

    private static void makeConvertTableScript(List<String> alterTableAcid, List<String> alterTableMm, String scriptLocation) throws IOException {
        PrintWriter pw;
        String fileName;
        if (alterTableAcid.isEmpty()) {
            LOG.info("No acid conversion is necessary");
        } else {
            fileName = "convertToAcid_" + System.currentTimeMillis() + ".sql";
            LOG.debug("Writing CRUD conversion commands to " + fileName);
            pw = UpgradeTool.createScript(alterTableAcid, fileName, scriptLocation);
            try {
                pw.println("-- These commands may be executed by Hive 1.x later");
            }
            finally {
                if (pw != null) {
                    pw.close();
                }
            }
        }
        if (alterTableMm.isEmpty()) {
            LOG.info("No managed table conversion is necessary");
        } else {
            fileName = "convertToMM_" + System.currentTimeMillis() + ".sql";
            LOG.debug("Writing managed table conversion commands to " + fileName);
            pw = UpgradeTool.createScript(alterTableMm, fileName, scriptLocation);
            try {
                pw.println("-- These commands must be executed by Hive 3.0 or later");
            }
            finally {
                if (pw != null) {
                    pw.close();
                }
            }
        }
    }

    private static PrintWriter createScript(List<String> commands, String fileName, String scriptLocation) throws IOException {
        FileWriter fw = new FileWriter(scriptLocation + "/" + fileName);
        PrintWriter pw = new PrintWriter(fw);
        for (String cmd : commands) {
            pw.println(cmd + ";");
        }
        return pw;
    }

    private static void makeRenameFileScript(String scriptLocation) throws IOException {
        List<String> commands = Collections.emptyList();
        if (commands.isEmpty()) {
            LOG.info("No file renaming is necessary");
        } else {
            String fileName = "normalizeFileNames_" + System.currentTimeMillis() + ".sh";
            LOG.debug("Writing file renaming commands to " + fileName);
            PrintWriter pw = UpgradeTool.createScript(commands, fileName, scriptLocation);
            pw.close();
        }
    }

    private static List<String> getCompactionCommands(org.apache.hadoop.hive.metastore.api.Table t, HiveConf conf, HiveMetaStoreClient hms, CompactionMetaInfo compactionMetaInfo, boolean execute, Hive db, ValidTxnList txns) throws IOException, TException, HiveException {
        if (!UpgradeTool.isFullAcidTable(t)) {
            return Collections.emptyList();
        }
        if (t.getPartitionKeysSize() <= 0) {
            if (!UpgradeTool.needsCompaction(new Path(t.getSd().getLocation()), conf, compactionMetaInfo, txns)) {
                return Collections.emptyList();
            }
            ArrayList<String> cmds = new ArrayList<String>();
            cmds.add(UpgradeTool.getCompactionCommand(t, null));
            if (execute) {
                UpgradeTool.scheduleCompaction(t, null, db, compactionMetaInfo);
            }
            return cmds;
        }
        List partNames = hms.listPartitionNames(t.getDbName(), t.getTableName(), (short)-1);
        int batchSize = 10000;
        int numWholeBatches = partNames.size() / batchSize;
        ArrayList<String> compactionCommands = new ArrayList<String>();
        for (int i = 0; i < numWholeBatches; ++i) {
            List partitionList = hms.getPartitionsByNames(t.getDbName(), t.getTableName(), partNames.subList(i * batchSize, (i + 1) * batchSize));
            UpgradeTool.getCompactionCommands(t, partitionList, db, execute, compactionCommands, compactionMetaInfo, conf, txns);
        }
        if (numWholeBatches * batchSize < partNames.size()) {
            List partitionList = hms.getPartitionsByNames(t.getDbName(), t.getTableName(), partNames.subList(numWholeBatches * batchSize, partNames.size()));
            UpgradeTool.getCompactionCommands(t, partitionList, db, execute, compactionCommands, compactionMetaInfo, conf, txns);
        }
        return compactionCommands;
    }

    private static void getCompactionCommands(org.apache.hadoop.hive.metastore.api.Table t, List<Partition> partitionList, Hive db, boolean execute, List<String> compactionCommands, CompactionMetaInfo compactionMetaInfo, HiveConf conf, ValidTxnList txns) throws IOException, TException, HiveException {
        for (Partition p : partitionList) {
            if (!UpgradeTool.needsCompaction(new Path(p.getSd().getLocation()), conf, compactionMetaInfo, txns)) continue;
            compactionCommands.add(UpgradeTool.getCompactionCommand(t, p));
            if (!execute) continue;
            UpgradeTool.scheduleCompaction(t, p, db, compactionMetaInfo);
        }
    }

    private static void scheduleCompaction(org.apache.hadoop.hive.metastore.api.Table t, Partition p, Hive db, CompactionMetaInfo compactionMetaInfo) throws HiveException, MetaException {
        String partName = p == null ? null : Warehouse.makePartName((List)t.getPartitionKeys(), (List)p.getValues());
        CompactionResponse resp = db.compact2(t.getDbName(), t.getTableName(), partName, "major", null);
        if (!resp.isAccepted()) {
            LOG.info(Warehouse.getQualifiedName((org.apache.hadoop.hive.metastore.api.Table)t) + (p == null ? "" : "/" + partName) + " is already being compacted with id=" + resp.getId());
        } else {
            LOG.info("Scheduled compaction for " + Warehouse.getQualifiedName((org.apache.hadoop.hive.metastore.api.Table)t) + (p == null ? "" : "/" + partName) + " with id=" + resp.getId());
        }
        compactionMetaInfo.compactionIds.add(resp.getId());
    }

    private static boolean needsCompaction2(Path location, HiveConf conf, CompactionMetaInfo compactionMetaInfo) throws IOException {
        FileSystem fs = location.getFileSystem((Configuration)conf);
        FileStatus[] deltas = fs.listStatus(location, new PathFilter(){

            public boolean accept(Path path) {
                return path.getName().startsWith("delta_") || path.getName().startsWith("delete_delta_");
            }
        });
        if (deltas == null || deltas.length == 0) {
            return false;
        }
        for (FileStatus delta : deltas) {
            FileStatus[] buckets;
            if (!delta.isDirectory()) continue;
            for (FileStatus bucket : buckets = fs.listStatus(delta.getPath(), new PathFilter(){

                public boolean accept(Path path) {
                    return path.getName().startsWith("bucket_");
                }
            })) {
                if (bucket.getPath().getName().endsWith("_flush_length")) break;
                if (!UpgradeTool.needsCompaction(bucket, fs)) continue;
                compactionMetaInfo.numberOfBytes += UpgradeTool.getDataSize(location, conf);
                return true;
            }
        }
        return false;
    }

    private static boolean needsCompaction(Path location, HiveConf conf, CompactionMetaInfo compactionMetaInfo, ValidTxnList txns) throws IOException {
        FileSystem fs = location.getFileSystem((Configuration)conf);
        FileStatus[] deltas = fs.listStatus(location, new PathFilter(){

            public boolean accept(Path path) {
                return path.getName().startsWith("delta_") || path.getName().startsWith("delete_delta_");
            }
        });
        if (deltas == null || deltas.length == 0) {
            return false;
        }
        AcidUtils.Directory dir = AcidUtils.getAcidState((Path)location, (Configuration)conf, (ValidTxnList)txns);
        for (AcidUtils.ParsedDelta delta : dir.getCurrentDirectories()) {
            FileStatus[] buckets;
            for (FileStatus bucket : buckets = fs.listStatus(delta.getPath(), new PathFilter(){

                public boolean accept(Path path) {
                    return path.getName().startsWith("bucket_");
                }
            })) {
                if (bucket.getPath().getName().endsWith("_flush_length")) break;
                if (!UpgradeTool.needsCompaction(bucket, fs)) continue;
                compactionMetaInfo.numberOfBytes += UpgradeTool.getDataSize(location, conf);
                for (HadoopShims.HdfsFileStatusWithId origFile : dir.getOriginalFiles()) {
                    FileStatus fileStatus = origFile.getFileStatus();
                    if (fileStatus == null) continue;
                    compactionMetaInfo.numberOfBytes += fileStatus.getLen();
                }
                return true;
            }
        }
        return false;
    }

    private static long getDataSize(Path location, HiveConf conf) throws IOException {
        FileSystem fs = location.getFileSystem((Configuration)conf);
        ContentSummary cs = fs.getContentSummary(location);
        return cs.getLength();
    }

    private static boolean needsCompaction(FileStatus bucket, FileSystem fs) throws IOException {
        Reader orcReader = OrcFile.createReader((Path)bucket.getPath(), (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)fs.getConf()).filesystem(fs));
        AcidStats as = OrcAcidUtils.parseAcidStats((Reader)orcReader);
        if (as == null) {
            throw new IllegalStateException("AcidStats missing in " + bucket.getPath());
        }
        return as.deletes > 0L || as.updates > 0L;
    }

    private static String getCompactionCommand(org.apache.hadoop.hive.metastore.api.Table t, Partition p) {
        StringBuilder sb = new StringBuilder("ALTER TABLE ").append(Warehouse.getQualifiedName((org.apache.hadoop.hive.metastore.api.Table)t));
        if (t.getPartitionKeysSize() > 0) {
            assert (p != null) : "must supply partition for partitioned table " + Warehouse.getQualifiedName((org.apache.hadoop.hive.metastore.api.Table)t);
            sb.append(" PARTITION(");
            for (int i = 0; i < t.getPartitionKeysSize(); ++i) {
                sb.append(((FieldSchema)t.getPartitionKeys().get(i)).getName()).append('=').append(UpgradeTool.genPartValueString(((FieldSchema)t.getPartitionKeys().get(i)).getType(), (String)p.getValues().get(i))).append(",");
            }
            sb.setCharAt(sb.length() - 1, ')');
        }
        return sb.append(" COMPACT 'major'").toString();
    }

    private static String genPartValueString(String partColType, String partVal) {
        String returnVal = partVal;
        returnVal = partColType.equals("string") || partColType.contains("varchar") || partColType.contains("char") ? "'" + BaseSemanticAnalyzer.escapeSQLString((String)partVal) + "'" : (partColType.equals("tinyint") ? partVal + "Y" : (partColType.equals("smallint") ? partVal + "S" : (partColType.equals("int") ? partVal : (partColType.equals("bigint") ? partVal + "L" : (partColType.contains("decimal") ? partVal + "BD" : (partColType.equals("date") || partColType.equals("timestamp") ? partColType + " '" + BaseSemanticAnalyzer.escapeSQLString((String)partVal) + "'" : "'" + BaseSemanticAnalyzer.escapeSQLString((String)partVal) + "'"))))));
        return returnVal;
    }

    private static boolean isFullAcidTable(org.apache.hadoop.hive.metastore.api.Table t) {
        if (t.getParametersSize() <= 0) {
            return false;
        }
        String transacationalValue = (String)t.getParameters().get("transactional");
        if (transacationalValue != null && "true".equalsIgnoreCase(transacationalValue)) {
            System.out.println("Found Acid table: " + Warehouse.getQualifiedName((org.apache.hadoop.hive.metastore.api.Table)t));
            return true;
        }
        return false;
    }

    private static boolean isAcidEnabled(HiveConf hiveConf) {
        String txnMgr = hiveConf.getVar(HiveConf.ConfVars.HIVE_TXN_MANAGER);
        boolean concurrency = hiveConf.getBoolVar(HiveConf.ConfVars.HIVE_SUPPORT_CONCURRENCY);
        String dbTxnMgr = "org.apache.hadoop.hive.ql.lockmgr.DbTxnManager";
        return txnMgr.equals(dbTxnMgr) && concurrency;
    }

    static {
        pollIntervalMs = 30000;
        isTestMode = false;
        hiveConf = null;
    }

    @VisibleForTesting
    static abstract class Callback {
        Callback() {
        }

        void onWaitForCompaction() throws MetaException {
        }
    }

    private static class CompactionMetaInfo {
        long numberOfBytes;
        Set<Long> compactionIds = new HashSet<Long>();

        private CompactionMetaInfo() {
        }
    }
}

