/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.avatica;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import org.apache.calcite.avatica.AvaticaParameter;
import org.apache.calcite.avatica.ColumnMetaData;
import org.apache.calcite.avatica.remote.TypedValue;
import org.apache.calcite.avatica.util.Cursor;

public class AvaticaSite {
    final AvaticaParameter parameter;
    final Calendar calendar;
    private final int index;
    final TypedValue[] slots;
    public static final Object DUMMY_VALUE = Dummy.INSTANCE;

    public AvaticaSite(AvaticaParameter parameter, Calendar calendar, int index, TypedValue[] slots) {
        assert (calendar != null);
        assert (parameter != null);
        assert (slots != null);
        this.parameter = parameter;
        this.calendar = calendar;
        this.index = index;
        this.slots = slots;
    }

    private TypedValue wrap(ColumnMetaData.Rep rep, Object o, Calendar calendar) {
        return TypedValue.ofJdbc(rep, o, calendar);
    }

    private TypedValue wrap(ColumnMetaData.Rep rep, Object o) {
        return TypedValue.ofJdbc(rep, o, this.calendar);
    }

    public boolean isSet(int index) {
        return this.slots[index] != null;
    }

    public void setByte(byte o) {
        this.slots[this.index] = this.wrap(ColumnMetaData.Rep.BYTE, o);
    }

    public void setChar(char o) {
        this.slots[this.index] = this.wrap(ColumnMetaData.Rep.CHARACTER, Character.valueOf(o));
    }

    public void setShort(short o) {
        this.slots[this.index] = this.wrap(ColumnMetaData.Rep.SHORT, o);
    }

    public void setInt(int o) {
        this.slots[this.index] = this.wrap(ColumnMetaData.Rep.INTEGER, o);
    }

    public void setLong(long o) {
        this.slots[this.index] = this.wrap(ColumnMetaData.Rep.LONG, o);
    }

    public void setBoolean(boolean o) {
        this.slots[this.index] = this.wrap(ColumnMetaData.Rep.BOOLEAN, o);
    }

    public void setRowId(RowId x) {
        this.slots[this.index] = this.wrap(ColumnMetaData.Rep.OBJECT, x);
    }

    public void setNString(String o) {
        this.slots[this.index] = this.wrap(ColumnMetaData.Rep.STRING, o);
    }

    public void setNCharacterStream(Reader value, long length) {
    }

    public void setNClob(NClob value) {
        this.slots[this.index] = this.wrap(ColumnMetaData.Rep.OBJECT, value);
    }

    public void setClob(Reader reader, long length) {
    }

    public void setBlob(InputStream inputStream, long length) {
    }

    public void setNClob(Reader reader, long length) {
    }

    public void setSQLXML(SQLXML xmlObject) {
        this.slots[this.index] = this.wrap(ColumnMetaData.Rep.OBJECT, xmlObject);
    }

    public void setAsciiStream(InputStream x, long length) {
    }

    public void setBinaryStream(InputStream x, long length) {
    }

    public void setCharacterStream(Reader reader, long length) {
    }

    public void setAsciiStream(InputStream x) {
    }

    public void setBinaryStream(InputStream x) {
    }

    public void setCharacterStream(Reader reader) {
    }

    public void setNCharacterStream(Reader value) {
    }

    public void setClob(Reader reader) {
    }

    public void setBlob(InputStream inputStream) {
    }

    public void setNClob(Reader reader) {
    }

    public void setUnicodeStream(InputStream x, int length) {
    }

    public void setFloat(float x) {
        this.slots[this.index] = this.wrap(ColumnMetaData.Rep.FLOAT, Float.valueOf(x));
    }

    public void setDouble(double x) {
        this.slots[this.index] = this.wrap(ColumnMetaData.Rep.DOUBLE, x);
    }

    public void setBigDecimal(BigDecimal x) {
        this.slots[this.index] = this.wrap(ColumnMetaData.Rep.NUMBER, x);
    }

    public void setString(String x) {
        this.slots[this.index] = this.wrap(ColumnMetaData.Rep.STRING, x);
    }

    public void setBytes(byte[] x) {
        this.slots[this.index] = this.wrap(ColumnMetaData.Rep.BYTE_STRING, x);
    }

    public void setTimestamp(Timestamp x, Calendar calendar) {
        this.slots[this.index] = this.wrap(ColumnMetaData.Rep.JAVA_SQL_TIMESTAMP, x, calendar);
    }

    public void setTime(Time x, Calendar calendar) {
        this.slots[this.index] = this.wrap(ColumnMetaData.Rep.JAVA_SQL_TIME, x, calendar);
    }

    public void setDate(Date x, Calendar cal) {
        this.slots[this.index] = this.wrap(ColumnMetaData.Rep.JAVA_SQL_DATE, x, this.calendar);
    }

    public void setObject(Object x, int targetSqlType) {
        if (x == null || 0 == targetSqlType) {
            this.setNull(targetSqlType);
            return;
        }
        switch (targetSqlType) {
            case 70: 
            case 1111: 
            case 2002: 
            case 2005: 
            case 2006: 
            case 2009: 
            case 2011: {
                throw AvaticaSite.notImplemented();
            }
            case 2003: {
                this.setArray(AvaticaSite.toArray(x));
                break;
            }
            case -5: {
                this.setLong(AvaticaSite.toLong(x));
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                this.setBytes(AvaticaSite.toBytes(x));
                break;
            }
            case -7: 
            case 16: {
                this.setBoolean(AvaticaSite.toBoolean(x));
                break;
            }
            case 2004: {
                if (x instanceof Blob) {
                    this.setBlob((Blob)x);
                    break;
                }
                if (x instanceof InputStream) {
                    this.setBlob((InputStream)x);
                }
                throw AvaticaSite.unsupportedCast(x.getClass(), Blob.class);
            }
            case 91: {
                this.setDate(AvaticaSite.toDate(x), this.calendar);
                break;
            }
            case 2: 
            case 3: {
                this.setBigDecimal(AvaticaSite.toBigDecimal(x));
                break;
            }
            case 2001: {
                throw AvaticaSite.notImplemented();
            }
            case 6: 
            case 8: {
                this.setDouble(AvaticaSite.toDouble(x));
                break;
            }
            case 4: {
                this.setInt(AvaticaSite.toInt(x));
                break;
            }
            case 2000: {
                this.setObject(x);
                break;
            }
            case -16: 
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: {
                this.setString(AvaticaSite.toString(x));
                break;
            }
            case 7: {
                this.setFloat(AvaticaSite.toFloat(x));
                break;
            }
            case -8: {
                if (x instanceof RowId) {
                    this.setRowId((RowId)x);
                    break;
                }
                throw AvaticaSite.unsupportedCast(x.getClass(), RowId.class);
            }
            case 5: {
                this.setShort(AvaticaSite.toShort(x));
                break;
            }
            case 92: {
                this.setTime(AvaticaSite.toTime(x), this.calendar);
                break;
            }
            case 93: {
                this.setTimestamp(AvaticaSite.toTimestamp(x), this.calendar);
                break;
            }
            case -6: {
                this.setByte(AvaticaSite.toByte(x));
                break;
            }
            default: {
                throw AvaticaSite.notImplemented();
            }
        }
    }

    public static Object get(Cursor.Accessor accessor, int targetSqlType, Calendar localCalendar) throws SQLException {
        switch (targetSqlType) {
            case 70: 
            case 2002: 
            case 2005: 
            case 2006: 
            case 2009: 
            case 2011: {
                throw AvaticaSite.notImplemented();
            }
            case 2003: {
                return accessor.getArray();
            }
            case -5: {
                long aLong = accessor.getLong();
                if (aLong == 0L && accessor.wasNull()) {
                    return null;
                }
                return aLong;
            }
            case -4: 
            case -3: 
            case -2: {
                return accessor.getBytes();
            }
            case -7: 
            case 16: {
                boolean aBoolean = accessor.getBoolean();
                if (!aBoolean && accessor.wasNull()) {
                    return null;
                }
                return aBoolean;
            }
            case 2004: {
                return accessor.getBlob();
            }
            case 91: {
                return accessor.getDate(localCalendar);
            }
            case 2: 
            case 3: {
                return accessor.getBigDecimal();
            }
            case 2001: {
                throw AvaticaSite.notImplemented();
            }
            case 6: 
            case 8: {
                double aDouble = accessor.getDouble();
                if (aDouble == 0.0 && accessor.wasNull()) {
                    return null;
                }
                return aDouble;
            }
            case 4: {
                int anInt = accessor.getInt();
                if (anInt == 0 && accessor.wasNull()) {
                    return null;
                }
                return anInt;
            }
            case 1111: 
            case 2000: {
                return accessor.getObject();
            }
            case -16: 
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: {
                return accessor.getString();
            }
            case 7: {
                float aFloat = accessor.getFloat();
                if (aFloat == 0.0f && accessor.wasNull()) {
                    return null;
                }
                return Float.valueOf(aFloat);
            }
            case -8: {
                throw AvaticaSite.notImplemented();
            }
            case 5: {
                short aShort = accessor.getShort();
                if (aShort == 0 && accessor.wasNull()) {
                    return null;
                }
                return aShort;
            }
            case 92: {
                return accessor.getTime(localCalendar);
            }
            case 93: {
                return accessor.getTimestamp(localCalendar);
            }
            case -6: {
                byte aByte = accessor.getByte();
                if (aByte == 0 && accessor.wasNull()) {
                    return null;
                }
                return aByte;
            }
        }
        throw AvaticaSite.notImplemented();
    }

    public void setObject(Object x) {
        this.slots[this.index] = TypedValue.ofJdbc(x, this.calendar);
    }

    public void setNull(int sqlType) {
        this.slots[this.index] = this.wrap(ColumnMetaData.Rep.OBJECT, null);
    }

    public void setRef(Ref x) {
    }

    public void setBlob(Blob x) {
    }

    public void setClob(Clob x) {
    }

    public void setArray(Array x) {
    }

    public void setNull(int sqlType, String typeName) {
    }

    public void setURL(URL x) {
    }

    public void setObject(Object x, int targetSqlType, int scaleOrLength) {
    }

    private static RuntimeException unsupportedCast(Class<?> from, Class<?> to) {
        return new UnsupportedOperationException("Cannot convert from " + from.getCanonicalName() + " to " + to.getCanonicalName());
    }

    private static RuntimeException notImplemented() {
        return new RuntimeException("not implemented");
    }

    private static Array toArray(Object x) {
        if (x instanceof Array) {
            return (Array)x;
        }
        throw AvaticaSite.unsupportedCast(x.getClass(), Array.class);
    }

    public static BigDecimal toBigDecimal(Object x) {
        if (x instanceof BigDecimal) {
            return (BigDecimal)x;
        }
        if (x instanceof BigInteger) {
            return new BigDecimal((BigInteger)x);
        }
        if (x instanceof Number) {
            if (x instanceof Double || x instanceof Float) {
                return new BigDecimal(((Number)x).doubleValue());
            }
            return new BigDecimal(((Number)x).longValue());
        }
        if (x instanceof Boolean) {
            return (Boolean)x != false ? BigDecimal.ONE : BigDecimal.ZERO;
        }
        if (x instanceof String) {
            return new BigDecimal((String)x);
        }
        throw AvaticaSite.unsupportedCast(x.getClass(), BigDecimal.class);
    }

    private static boolean toBoolean(Object x) {
        if (x instanceof Boolean) {
            return (Boolean)x;
        }
        if (x instanceof Number) {
            return ((Number)x).intValue() != 0;
        }
        if (x instanceof String) {
            String s = (String)x;
            if (s.equalsIgnoreCase("true") || s.equalsIgnoreCase("yes")) {
                return true;
            }
            if (s.equalsIgnoreCase("false") || s.equalsIgnoreCase("no")) {
                return false;
            }
        }
        throw AvaticaSite.unsupportedCast(x.getClass(), Boolean.TYPE);
    }

    private static byte toByte(Object x) {
        if (x instanceof Number) {
            return ((Number)x).byteValue();
        }
        if (x instanceof Boolean) {
            return (Boolean)x != false ? (byte)1 : 0;
        }
        if (x instanceof String) {
            return Byte.parseByte((String)x);
        }
        throw AvaticaSite.unsupportedCast(x.getClass(), Byte.TYPE);
    }

    private static byte[] toBytes(Object x) {
        if (x instanceof byte[]) {
            return (byte[])x;
        }
        if (x instanceof String) {
            return ((String)x).getBytes();
        }
        throw AvaticaSite.unsupportedCast(x.getClass(), byte[].class);
    }

    private static Date toDate(Object x) {
        if (x instanceof String) {
            return Date.valueOf((String)x);
        }
        return new Date(AvaticaSite.toLong(x));
    }

    private static Time toTime(Object x) {
        if (x instanceof String) {
            return Time.valueOf((String)x);
        }
        return new Time(AvaticaSite.toLong(x));
    }

    private static Timestamp toTimestamp(Object x) {
        if (x instanceof String) {
            return Timestamp.valueOf((String)x);
        }
        return new Timestamp(AvaticaSite.toLong(x));
    }

    private static double toDouble(Object x) {
        if (x instanceof Number) {
            return ((Number)x).doubleValue();
        }
        if (x instanceof Boolean) {
            return (Boolean)x != false ? 1.0 : 0.0;
        }
        if (x instanceof String) {
            return Double.parseDouble((String)x);
        }
        throw AvaticaSite.unsupportedCast(x.getClass(), Double.TYPE);
    }

    private static float toFloat(Object x) {
        if (x instanceof Number) {
            return ((Number)x).floatValue();
        }
        if (x instanceof Boolean) {
            return (Boolean)x != false ? 1.0f : 0.0f;
        }
        if (x instanceof String) {
            return Float.parseFloat((String)x);
        }
        throw AvaticaSite.unsupportedCast(x.getClass(), Float.TYPE);
    }

    private static int toInt(Object x) {
        if (x instanceof Number) {
            return ((Number)x).intValue();
        }
        if (x instanceof Boolean) {
            return (Boolean)x != false ? 1 : 0;
        }
        if (x instanceof String) {
            return Integer.parseInt((String)x);
        }
        throw AvaticaSite.unsupportedCast(x.getClass(), Integer.TYPE);
    }

    private static long toLong(Object x) {
        if (x instanceof Number) {
            return ((Number)x).longValue();
        }
        if (x instanceof Boolean) {
            return (Boolean)x != false ? 1L : 0L;
        }
        if (x instanceof String) {
            return Long.parseLong((String)x);
        }
        throw AvaticaSite.unsupportedCast(x.getClass(), Long.TYPE);
    }

    private static short toShort(Object x) {
        if (x instanceof Number) {
            return ((Number)x).shortValue();
        }
        if (x instanceof Boolean) {
            return (Boolean)x != false ? (short)1 : 0;
        }
        if (x instanceof String) {
            return Short.parseShort((String)x);
        }
        throw AvaticaSite.unsupportedCast(x.getClass(), Short.TYPE);
    }

    private static String toString(Object x) {
        if (x instanceof String) {
            return (String)x;
        }
        if (x instanceof Character || x instanceof Boolean) {
            return x.toString();
        }
        throw AvaticaSite.unsupportedCast(x.getClass(), String.class);
    }

    private static enum Dummy {
        INSTANCE;

    }
}

