/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.web.security;

import com.google.common.io.Closeables;
import com.mapr.baseutils.Installation;
import com.mapr.security.FipsLoader;
import com.mapr.web.security.KeystoreFileType;
import com.mapr.web.security.SslConfig;
import com.mapr.web.security.XmlSslConfig;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import org.apache.hadoop.conf.Configuration;
import org.apache.hive.common.util.MapRSecurityUtil;

public class ClientXmlSslConfig
implements Closeable {
    private static final String SSL_CLIENT_XML = "ssl-client.xml";
    private static final String SSL_SERVER_XML = "ssl-server.xml";
    private final String clientTruststoreLocation;
    private final String clientKeystoreLocation;
    private final char[] clientKeystorePassword;
    private final char[] clientTruststorePassword;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ClientXmlSslConfig() {
        String maprConfDir = MapRSecurityUtil.findMapRHome() + "/conf/";
        File sslServerXml = new File(maprConfDir, SSL_SERVER_XML);
        File sslClientXml = new File(maprConfDir, SSL_CLIENT_XML);
        FileInputStream inStreamClient = null;
        FileInputStream inStreamServer = null;
        try {
            Configuration conf = new Configuration(true);
            URL coreSiteXmlURL = Installation.getCoreSiteXmlURL();
            conf.addResource(coreSiteXmlURL, false);
            inStreamClient = new FileInputStream(sslClientXml);
            conf.addResource((InputStream)inStreamClient, false);
            if (MapRSecurityUtil.isClusterAdminProcess()) {
                inStreamServer = new FileInputStream(sslServerXml);
                conf.addResource((InputStream)inStreamServer, false);
                if (KeystoreFileType.fromName((String)conf.get("ssl.server.keystore.type")) == KeystoreFileType.BCFKS) {
                    FipsLoader.loadFipsProviders();
                }
            }
            this.clientTruststoreLocation = conf.get("ssl.client.truststore.location");
            this.clientKeystoreLocation = conf.get("ssl.client.keystore.location");
            this.clientKeystorePassword = conf.getPassword("ssl.client.keystore.password");
            this.clientTruststorePassword = conf.getPassword("ssl.client.truststore.password");
            if (KeystoreFileType.fromName((String)conf.get("ssl.client.keystore.type")) == KeystoreFileType.BCFKS) {
                FipsLoader.loadFipsProviders();
            }
        }
        catch (IOException e) {
            try {
                throw new SecurityException("Unable to read SSL configuration from XML files", e);
            }
            catch (Throwable throwable) {
                try {
                    Closeables.close(inStreamClient, (boolean)true);
                    Closeables.close(inStreamServer, (boolean)true);
                    throw throwable;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        try {
            Closeables.close((Closeable)inStreamClient, (boolean)true);
            Closeables.close((Closeable)inStreamServer, (boolean)true);
            return;
        }
        catch (IOException conf) {
            return;
        }
    }

    public String getClientTruststoreLocation() throws SecurityException {
        return this.clientTruststoreLocation;
    }

    public char[] getClientTruststorePassword() throws SecurityException {
        return this.clientTruststorePassword == null ? null : Arrays.copyOf(this.clientTruststorePassword, this.clientTruststorePassword.length);
    }

    public String getClientKeystoreLocation() throws SecurityException {
        return this.clientKeystoreLocation;
    }

    public char[] getClientKeystorePassword() throws SecurityException {
        return this.clientKeystorePassword == null ? null : Arrays.copyOf(this.clientKeystorePassword, this.clientKeystorePassword.length);
    }

    public static String getClientKeystoreType() {
        try (SslConfig sslConfig = ClientXmlSslConfig.getSslConfig();){
            String string = sslConfig.getClientKeystoreType();
            return string;
        }
    }

    public static SslConfig getSslConfig() throws SecurityException {
        return ClientXmlSslConfig.getSslConfig(SslConfig.SslConfigScope.SCOPE_ALL);
    }

    public static SslConfig getSslConfig(SslConfig.SslConfigScope scope) throws SecurityException {
        return new XmlSslConfig(scope);
    }

    @Override
    public void close() {
        char[][] passwords;
        for (char[] password : passwords = new char[][]{this.clientKeystorePassword, this.clientTruststorePassword}) {
            if (password == null) continue;
            Arrays.fill(password, '\u0000');
        }
    }
}

