/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.DefaultPartitionExpressionProxy;
import org.apache.hadoop.hive.metastore.ObjectStore;
import org.apache.hadoop.hive.metastore.RawStore;
import org.apache.hadoop.hive.metastore.annotation.MetastoreCheckinTest;
import org.apache.hadoop.hive.metastore.api.AlreadyExistsException;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.ISchema;
import org.apache.hadoop.hive.metastore.api.ISchemaName;
import org.apache.hadoop.hive.metastore.api.InvalidObjectException;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.SchemaCompatibility;
import org.apache.hadoop.hive.metastore.api.SchemaType;
import org.apache.hadoop.hive.metastore.api.SchemaValidation;
import org.apache.hadoop.hive.metastore.api.SchemaVersion;
import org.apache.hadoop.hive.metastore.api.SchemaVersionDescriptor;
import org.apache.hadoop.hive.metastore.api.SchemaVersionState;
import org.apache.hadoop.hive.metastore.api.SerDeInfo;
import org.apache.hadoop.hive.metastore.client.builder.CatalogBuilder;
import org.apache.hadoop.hive.metastore.client.builder.DatabaseBuilder;
import org.apache.hadoop.hive.metastore.client.builder.ISchemaBuilder;
import org.apache.hadoop.hive.metastore.client.builder.SchemaVersionBuilder;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.thrift.TException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MetastoreCheckinTest.class})
public class TestObjectStoreSchemaMethods {
    private RawStore objectStore;
    private Configuration conf;
    private static int dbNum = 1;
    private static Random rand = new Random();

    @Before
    public void setUp() throws Exception {
        this.conf = MetastoreConf.newMetastoreConf();
        MetastoreConf.setVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.EXPRESSION_PROXY_CLASS, (String)DefaultPartitionExpressionProxy.class.getName());
        this.objectStore = new ObjectStore();
        this.objectStore.setConf(this.conf);
    }

    @Test
    public void iSchema() throws TException {
        Database db = this.createUniqueDatabaseForTest();
        ISchema schema = this.objectStore.getISchema(new ISchemaName(db.getCatalogName(), db.getName(), "no.such.schema"));
        Assert.assertNull((Object)schema);
        String schemaName = "schema1";
        String schemaGroup = "group1";
        String description = "This is a description";
        schema = new ISchemaBuilder().setSchemaType(SchemaType.AVRO).setName(schemaName).inDb(db).setCompatibility(SchemaCompatibility.FORWARD).setValidationLevel(SchemaValidation.LATEST).setCanEvolve(false).setSchemaGroup(schemaGroup).setDescription(description).build();
        this.objectStore.createISchema(schema);
        schema = this.objectStore.getISchema(new ISchemaName(db.getCatalogName(), db.getName(), schemaName));
        Assert.assertNotNull((Object)schema);
        Assert.assertEquals((Object)SchemaType.AVRO, (Object)schema.getSchemaType());
        Assert.assertEquals((Object)schemaName, (Object)schema.getName());
        Assert.assertEquals((Object)SchemaCompatibility.FORWARD, (Object)schema.getCompatibility());
        Assert.assertEquals((Object)SchemaValidation.LATEST, (Object)schema.getValidationLevel());
        Assert.assertFalse((boolean)schema.isCanEvolve());
        Assert.assertEquals((Object)schemaGroup, (Object)schema.getSchemaGroup());
        Assert.assertEquals((Object)description, (Object)schema.getDescription());
        schemaGroup = "new group";
        description = "new description";
        schema.setCompatibility(SchemaCompatibility.BOTH);
        schema.setValidationLevel(SchemaValidation.ALL);
        schema.setCanEvolve(true);
        schema.setSchemaGroup(schemaGroup);
        schema.setDescription(description);
        this.objectStore.alterISchema(new ISchemaName(db.getCatalogName(), db.getName(), schemaName), schema);
        schema = this.objectStore.getISchema(new ISchemaName(db.getCatalogName(), db.getName(), schemaName));
        Assert.assertNotNull((Object)schema);
        Assert.assertEquals((Object)SchemaType.AVRO, (Object)schema.getSchemaType());
        Assert.assertEquals((Object)schemaName, (Object)schema.getName());
        Assert.assertEquals((Object)SchemaCompatibility.BOTH, (Object)schema.getCompatibility());
        Assert.assertEquals((Object)SchemaValidation.ALL, (Object)schema.getValidationLevel());
        Assert.assertTrue((boolean)schema.isCanEvolve());
        Assert.assertEquals((Object)schemaGroup, (Object)schema.getSchemaGroup());
        Assert.assertEquals((Object)description, (Object)schema.getDescription());
        this.objectStore.dropISchema(new ISchemaName(db.getCatalogName(), db.getName(), schemaName));
        schema = this.objectStore.getISchema(new ISchemaName(db.getCatalogName(), db.getName(), schemaName));
        Assert.assertNull((Object)schema);
    }

    @Test(expected=NoSuchObjectException.class)
    public void schemaWithInvalidDatabase() throws MetaException, AlreadyExistsException, NoSuchObjectException {
        ISchema schema = new ISchemaBuilder().setName("thisSchemaDoesntHaveADb").setDbName("no.such.database").setSchemaType(SchemaType.AVRO).build();
        this.objectStore.createISchema(schema);
    }

    @Test(expected=AlreadyExistsException.class)
    public void schemaAlreadyExists() throws TException {
        Database db = this.createUniqueDatabaseForTest();
        String schemaName = "schema2";
        ISchema schema = new ISchemaBuilder().setSchemaType(SchemaType.HIVE).setName(schemaName).inDb(db).build();
        this.objectStore.createISchema(schema);
        schema = this.objectStore.getISchema(new ISchemaName(db.getCatalogName(), db.getName(), schemaName));
        Assert.assertNotNull((Object)schema);
        Assert.assertEquals((Object)SchemaType.HIVE, (Object)schema.getSchemaType());
        Assert.assertEquals((Object)schemaName, (Object)schema.getName());
        Assert.assertEquals((Object)SchemaCompatibility.BACKWARD, (Object)schema.getCompatibility());
        Assert.assertEquals((Object)SchemaValidation.ALL, (Object)schema.getValidationLevel());
        Assert.assertTrue((boolean)schema.isCanEvolve());
        this.objectStore.createISchema(schema);
    }

    @Test(expected=NoSuchObjectException.class)
    public void alterNonExistentSchema() throws MetaException, NoSuchObjectException {
        String schemaName = "noSuchSchema";
        ISchema schema = new ISchemaBuilder().setSchemaType(SchemaType.HIVE).setName(schemaName).setDescription("a new description").build();
        this.objectStore.alterISchema(new ISchemaName("hive", "default", schemaName), schema);
    }

    @Test(expected=NoSuchObjectException.class)
    public void dropNonExistentSchema() throws MetaException, NoSuchObjectException {
        this.objectStore.dropISchema(new ISchemaName("hive", "default", "no_such_schema"));
    }

    @Test(expected=NoSuchObjectException.class)
    public void createVersionOfNonExistentSchema() throws MetaException, AlreadyExistsException, NoSuchObjectException, InvalidObjectException {
        SchemaVersion schemaVersion = ((SchemaVersionBuilder)new SchemaVersionBuilder().setSchemaName("noSchemaOfThisNameExists").setVersion(1).addCol("a", "string")).build();
        this.objectStore.addSchemaVersion(schemaVersion);
    }

    @Test
    public void addSchemaVersion() throws TException {
        Database db = this.createUniqueDatabaseForTest();
        String schemaName = "schema37";
        int version = 1;
        SchemaVersion schemaVersion = this.objectStore.getSchemaVersion(new SchemaVersionDescriptor(new ISchemaName(db.getCatalogName(), db.getName(), schemaName), version));
        Assert.assertNull((Object)schemaVersion);
        ISchema schema = new ISchemaBuilder().setSchemaType(SchemaType.AVRO).setName(schemaName).inDb(db).build();
        this.objectStore.createISchema(schema);
        String description = "very descriptive";
        String schemaText = "this should look like json, but oh well";
        String fingerprint = "this should be an md5 string";
        String versionName = "why would I name a version?";
        long creationTime = 10L;
        String serdeName = "serde_for_schema37";
        String serializer = "org.apache.hadoop.hive.metastore.test.Serializer";
        String deserializer = "org.apache.hadoop.hive.metastore.test.Deserializer";
        String serdeDescription = "how do you describe a serde?";
        schemaVersion = ((SchemaVersionBuilder)((SchemaVersionBuilder)((SchemaVersionBuilder)((SchemaVersionBuilder)((SchemaVersionBuilder)((SchemaVersionBuilder)new SchemaVersionBuilder().versionOf(schema).setVersion(version).addCol("a", "int")).addCol("b", "float")).setCreatedAt(creationTime).setState(SchemaVersionState.INITIATED).setDescription(description).setSchemaText(schemaText).setFingerprint(fingerprint).setName(versionName).setSerdeName(serdeName)).setSerdeSerializerClass(serializer)).setSerdeDeserializerClass(deserializer)).setSerdeDescription(serdeDescription)).build();
        this.objectStore.addSchemaVersion(schemaVersion);
        schemaVersion = this.objectStore.getSchemaVersion(new SchemaVersionDescriptor(new ISchemaName(db.getCatalogName(), db.getName(), schemaName), version));
        Assert.assertNotNull((Object)schemaVersion);
        Assert.assertEquals((Object)schemaName, (Object)schemaVersion.getSchema().getSchemaName());
        Assert.assertEquals((Object)db.getName(), (Object)schemaVersion.getSchema().getDbName());
        Assert.assertEquals((Object)db.getCatalogName(), (Object)schemaVersion.getSchema().getCatName());
        Assert.assertEquals((long)version, (long)schemaVersion.getVersion());
        Assert.assertEquals((long)creationTime, (long)schemaVersion.getCreatedAt());
        Assert.assertEquals((Object)SchemaVersionState.INITIATED, (Object)schemaVersion.getState());
        Assert.assertEquals((Object)description, (Object)schemaVersion.getDescription());
        Assert.assertEquals((Object)schemaText, (Object)schemaVersion.getSchemaText());
        Assert.assertEquals((Object)fingerprint, (Object)schemaVersion.getFingerprint());
        Assert.assertEquals((Object)versionName, (Object)schemaVersion.getName());
        Assert.assertEquals((Object)serdeName, (Object)schemaVersion.getSerDe().getName());
        Assert.assertEquals((Object)serializer, (Object)schemaVersion.getSerDe().getSerializerClass());
        Assert.assertEquals((Object)deserializer, (Object)schemaVersion.getSerDe().getDeserializerClass());
        Assert.assertEquals((Object)serdeDescription, (Object)schemaVersion.getSerDe().getDescription());
        Assert.assertEquals((long)2L, (long)schemaVersion.getColsSize());
        List cols = schemaVersion.getCols();
        Collections.sort(cols);
        Assert.assertEquals((Object)"a", (Object)((FieldSchema)cols.get(0)).getName());
        Assert.assertEquals((Object)"int", (Object)((FieldSchema)cols.get(0)).getType());
        Assert.assertEquals((Object)"b", (Object)((FieldSchema)cols.get(1)).getName());
        Assert.assertEquals((Object)"float", (Object)((FieldSchema)cols.get(1)).getType());
        this.objectStore.dropSchemaVersion(new SchemaVersionDescriptor(new ISchemaName(db.getCatalogName(), db.getName(), schemaName), version));
        schemaVersion = this.objectStore.getSchemaVersion(new SchemaVersionDescriptor(new ISchemaName(db.getCatalogName(), db.getName(), schemaName), version));
        Assert.assertNull((Object)schemaVersion);
    }

    @Test
    public void multipleSchemaVersions() throws TException {
        Database db = this.createUniqueDatabaseForTest();
        String schemaName = "schema195";
        ISchema schema = new ISchemaBuilder().setSchemaType(SchemaType.AVRO).setName(schemaName).inDb(db).build();
        this.objectStore.createISchema(schema);
        SchemaVersion schemaVersion = ((SchemaVersionBuilder)new SchemaVersionBuilder().versionOf(schema).setVersion(1).addCol("a", "bigint")).build();
        this.objectStore.addSchemaVersion(schemaVersion);
        schemaVersion = ((SchemaVersionBuilder)((SchemaVersionBuilder)new SchemaVersionBuilder().versionOf(schema).setVersion(2).addCol("a", "bigint")).addCol("b", "date")).build();
        this.objectStore.addSchemaVersion(schemaVersion);
        schemaVersion = ((SchemaVersionBuilder)((SchemaVersionBuilder)((SchemaVersionBuilder)new SchemaVersionBuilder().versionOf(schema).setVersion(3).addCol("a", "bigint")).addCol("b", "date")).addCol("c", "timestamp")).build();
        this.objectStore.addSchemaVersion(schemaVersion);
        schemaVersion = this.objectStore.getLatestSchemaVersion(new ISchemaName(db.getCatalogName(), db.getName(), schemaName));
        Assert.assertEquals((long)3L, (long)schemaVersion.getVersion());
        Assert.assertEquals((long)3L, (long)schemaVersion.getColsSize());
        List cols = schemaVersion.getCols();
        Collections.sort(cols);
        Assert.assertEquals((Object)"a", (Object)((FieldSchema)cols.get(0)).getName());
        Assert.assertEquals((Object)"b", (Object)((FieldSchema)cols.get(1)).getName());
        Assert.assertEquals((Object)"c", (Object)((FieldSchema)cols.get(2)).getName());
        Assert.assertEquals((Object)"bigint", (Object)((FieldSchema)cols.get(0)).getType());
        Assert.assertEquals((Object)"date", (Object)((FieldSchema)cols.get(1)).getType());
        Assert.assertEquals((Object)"timestamp", (Object)((FieldSchema)cols.get(2)).getType());
        schemaVersion = this.objectStore.getLatestSchemaVersion(new ISchemaName(db.getCatalogName(), db.getName(), "no.such.schema.with.this.name"));
        Assert.assertNull((Object)schemaVersion);
        List versions = this.objectStore.getAllSchemaVersion(new ISchemaName(db.getCatalogName(), db.getName(), "there.really.isnt.a.schema.named.this"));
        Assert.assertNull((Object)versions);
        versions = this.objectStore.getAllSchemaVersion(new ISchemaName(db.getCatalogName(), db.getName(), schemaName));
        Assert.assertEquals((long)3L, (long)versions.size());
        versions.sort(Comparator.comparingInt(SchemaVersion::getVersion));
        Assert.assertEquals((long)1L, (long)((SchemaVersion)versions.get(0)).getVersion());
        Assert.assertEquals((long)1L, (long)((SchemaVersion)versions.get(0)).getColsSize());
        Assert.assertEquals((Object)"bigint", (Object)((FieldSchema)((SchemaVersion)versions.get(0)).getCols().get(0)).getType());
        Assert.assertEquals((long)2L, (long)((SchemaVersion)versions.get(1)).getVersion());
        Assert.assertEquals((long)2L, (long)((SchemaVersion)versions.get(1)).getColsSize());
        cols = ((SchemaVersion)versions.get(1)).getCols();
        Collections.sort(cols);
        Assert.assertEquals((Object)"a", (Object)((FieldSchema)cols.get(0)).getName());
        Assert.assertEquals((Object)"b", (Object)((FieldSchema)cols.get(1)).getName());
        Assert.assertEquals((Object)"bigint", (Object)((FieldSchema)cols.get(0)).getType());
        Assert.assertEquals((Object)"date", (Object)((FieldSchema)cols.get(1)).getType());
        Assert.assertEquals((long)3L, (long)((SchemaVersion)versions.get(2)).getVersion());
        Assert.assertEquals((long)3L, (long)((SchemaVersion)versions.get(2)).getColsSize());
        cols = ((SchemaVersion)versions.get(2)).getCols();
        Collections.sort(cols);
        Assert.assertEquals((Object)"a", (Object)((FieldSchema)cols.get(0)).getName());
        Assert.assertEquals((Object)"b", (Object)((FieldSchema)cols.get(1)).getName());
        Assert.assertEquals((Object)"c", (Object)((FieldSchema)cols.get(2)).getName());
        Assert.assertEquals((Object)"bigint", (Object)((FieldSchema)cols.get(0)).getType());
        Assert.assertEquals((Object)"date", (Object)((FieldSchema)cols.get(1)).getType());
        Assert.assertEquals((Object)"timestamp", (Object)((FieldSchema)cols.get(2)).getType());
    }

    @Test(expected=AlreadyExistsException.class)
    public void addDuplicateSchemaVersion() throws TException {
        Database db = this.createUniqueDatabaseForTest();
        String schemaName = "schema1234";
        int version = 1;
        SchemaVersion schemaVersion = this.objectStore.getSchemaVersion(new SchemaVersionDescriptor(new ISchemaName(db.getCatalogName(), db.getName(), schemaName), version));
        Assert.assertNull((Object)schemaVersion);
        ISchema schema = new ISchemaBuilder().setSchemaType(SchemaType.AVRO).setName(schemaName).inDb(db).build();
        this.objectStore.createISchema(schema);
        schemaVersion = ((SchemaVersionBuilder)((SchemaVersionBuilder)new SchemaVersionBuilder().versionOf(schema).setVersion(version).addCol("a", "int")).addCol("b", "float")).build();
        this.objectStore.addSchemaVersion(schemaVersion);
        this.objectStore.addSchemaVersion(schemaVersion);
    }

    @Test
    public void alterSchemaVersion() throws TException {
        Database db = this.createUniqueDatabaseForTest();
        String schemaName = "schema371234";
        int version = 1;
        SchemaVersion schemaVersion = this.objectStore.getSchemaVersion(new SchemaVersionDescriptor(new ISchemaName(db.getCatalogName(), db.getName(), schemaName), version));
        Assert.assertNull((Object)schemaVersion);
        ISchema schema = new ISchemaBuilder().setSchemaType(SchemaType.AVRO).setName(schemaName).inDb(db).build();
        this.objectStore.createISchema(schema);
        schemaVersion = ((SchemaVersionBuilder)((SchemaVersionBuilder)new SchemaVersionBuilder().versionOf(schema).setVersion(version).addCol("a", "int")).addCol("b", "float")).setState(SchemaVersionState.INITIATED).build();
        this.objectStore.addSchemaVersion(schemaVersion);
        schemaVersion = this.objectStore.getSchemaVersion(new SchemaVersionDescriptor(new ISchemaName(db.getCatalogName(), db.getName(), schemaName), version));
        Assert.assertNotNull((Object)schemaVersion);
        Assert.assertEquals((Object)schemaName, (Object)schemaVersion.getSchema().getSchemaName());
        Assert.assertEquals((Object)db.getName(), (Object)schemaVersion.getSchema().getDbName());
        Assert.assertEquals((Object)db.getCatalogName(), (Object)schemaVersion.getSchema().getCatName());
        Assert.assertEquals((long)version, (long)schemaVersion.getVersion());
        Assert.assertEquals((Object)SchemaVersionState.INITIATED, (Object)schemaVersion.getState());
        schemaVersion.setState(SchemaVersionState.REVIEWED);
        String serdeName = "serde for " + schemaName;
        SerDeInfo serde = new SerDeInfo(serdeName, "", Collections.emptyMap());
        String serializer = "org.apache.hadoop.hive.metastore.test.Serializer";
        String deserializer = "org.apache.hadoop.hive.metastore.test.Deserializer";
        serde.setSerializerClass(serializer);
        serde.setDeserializerClass(deserializer);
        schemaVersion.setSerDe(serde);
        this.objectStore.alterSchemaVersion(new SchemaVersionDescriptor(new ISchemaName(db.getCatalogName(), db.getName(), schemaName), version), schemaVersion);
        schemaVersion = this.objectStore.getSchemaVersion(new SchemaVersionDescriptor(new ISchemaName(db.getCatalogName(), db.getName(), schemaName), version));
        Assert.assertNotNull((Object)schemaVersion);
        Assert.assertEquals((Object)schemaName, (Object)schemaVersion.getSchema().getSchemaName());
        Assert.assertEquals((Object)db.getName(), (Object)schemaVersion.getSchema().getDbName());
        Assert.assertEquals((Object)db.getCatalogName(), (Object)schemaVersion.getSchema().getCatName());
        Assert.assertEquals((long)version, (long)schemaVersion.getVersion());
        Assert.assertEquals((Object)SchemaVersionState.REVIEWED, (Object)schemaVersion.getState());
        Assert.assertEquals((Object)serdeName, (Object)schemaVersion.getSerDe().getName());
        Assert.assertEquals((Object)serializer, (Object)schemaVersion.getSerDe().getSerializerClass());
        Assert.assertEquals((Object)deserializer, (Object)schemaVersion.getSerDe().getDeserializerClass());
    }

    @Test(expected=NoSuchObjectException.class)
    public void alterNonExistentSchemaVersion() throws MetaException, AlreadyExistsException, NoSuchObjectException {
        String schemaName = "schema3723asdflj";
        int version = 37;
        SchemaVersion schemaVersion = ((SchemaVersionBuilder)((SchemaVersionBuilder)new SchemaVersionBuilder().setSchemaName(schemaName).setDbName("default").setVersion(version).addCol("a", "int")).addCol("b", "float")).setState(SchemaVersionState.INITIATED).build();
        this.objectStore.alterSchemaVersion(new SchemaVersionDescriptor(new ISchemaName("hive", "default", schemaName), version), schemaVersion);
    }

    @Test(expected=NoSuchObjectException.class)
    public void dropNonExistentSchemaVersion() throws NoSuchObjectException, MetaException {
        this.objectStore.dropSchemaVersion(new SchemaVersionDescriptor(new ISchemaName("hive", "default", "ther is no schema named this"), 23));
    }

    @Test
    public void schemaQuery() throws TException {
        Database db = this.createUniqueDatabaseForTest();
        String schemaName1 = "a_schema1";
        ISchema schema1 = new ISchemaBuilder().setSchemaType(SchemaType.AVRO).setName(schemaName1).inDb(db).build();
        this.objectStore.createISchema(schema1);
        String schemaName2 = "a_schema2";
        ISchema schema2 = new ISchemaBuilder().setSchemaType(SchemaType.AVRO).setName(schemaName2).inDb(db).build();
        this.objectStore.createISchema(schema2);
        SchemaVersion schemaVersion1_1 = ((SchemaVersionBuilder)((SchemaVersionBuilder)new SchemaVersionBuilder().versionOf(schema1).setVersion(1).addCol("alpha", "bigint")).addCol("beta", "date")).build();
        this.objectStore.addSchemaVersion(schemaVersion1_1);
        SchemaVersion schemaVersion1_2 = ((SchemaVersionBuilder)((SchemaVersionBuilder)((SchemaVersionBuilder)new SchemaVersionBuilder().versionOf(schema1).setVersion(2).addCol("alpha", "bigint")).addCol("beta", "date")).addCol("gamma", "bigint", "namespace=x")).build();
        this.objectStore.addSchemaVersion(schemaVersion1_2);
        SchemaVersion schemaVersion2_1 = ((SchemaVersionBuilder)((SchemaVersionBuilder)new SchemaVersionBuilder().versionOf(schema2).setVersion(1).addCol("ALPHA", "smallint")).addCol("delta", "double")).build();
        this.objectStore.addSchemaVersion(schemaVersion2_1);
        SchemaVersion schemaVersion2_2 = ((SchemaVersionBuilder)((SchemaVersionBuilder)((SchemaVersionBuilder)new SchemaVersionBuilder().versionOf(schema2).setVersion(2).addCol("ALPHA", "smallint")).addCol("delta", "double")).addCol("epsilon", "string", "namespace=x")).build();
        this.objectStore.addSchemaVersion(schemaVersion2_2);
        List results = this.objectStore.getSchemaVersionsByColumns("x", "y", "z");
        Assert.assertEquals((long)0L, (long)results.size());
        results = this.objectStore.getSchemaVersionsByColumns("gamma", null, null);
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertEquals((Object)schemaName1, (Object)((SchemaVersion)results.get(0)).getSchema().getSchemaName());
        Assert.assertEquals((Object)db.getName(), (Object)((SchemaVersion)results.get(0)).getSchema().getDbName());
        Assert.assertEquals((Object)db.getCatalogName(), (Object)((SchemaVersion)results.get(0)).getSchema().getCatName());
        Assert.assertEquals((long)2L, (long)((SchemaVersion)results.get(0)).getVersion());
        results = this.objectStore.getSchemaVersionsByColumns("beta", null, null);
        Assert.assertEquals((long)2L, (long)results.size());
        Collections.sort(results);
        Assert.assertEquals((Object)schemaName1, (Object)((SchemaVersion)results.get(0)).getSchema().getSchemaName());
        Assert.assertEquals((Object)db.getName(), (Object)((SchemaVersion)results.get(0)).getSchema().getDbName());
        Assert.assertEquals((Object)db.getCatalogName(), (Object)((SchemaVersion)results.get(0)).getSchema().getCatName());
        Assert.assertEquals((long)1L, (long)((SchemaVersion)results.get(0)).getVersion());
        Assert.assertEquals((Object)schemaName1, (Object)((SchemaVersion)results.get(1)).getSchema().getSchemaName());
        Assert.assertEquals((Object)db.getName(), (Object)((SchemaVersion)results.get(1)).getSchema().getDbName());
        Assert.assertEquals((Object)db.getCatalogName(), (Object)((SchemaVersion)results.get(1)).getSchema().getCatName());
        Assert.assertEquals((long)2L, (long)((SchemaVersion)results.get(1)).getVersion());
        results = this.objectStore.getSchemaVersionsByColumns("alpha", null, null);
        Assert.assertEquals((long)4L, (long)results.size());
        Collections.sort(results);
        Assert.assertEquals((Object)schemaName1, (Object)((SchemaVersion)results.get(0)).getSchema().getSchemaName());
        Assert.assertEquals((Object)db.getName(), (Object)((SchemaVersion)results.get(0)).getSchema().getDbName());
        Assert.assertEquals((Object)db.getCatalogName(), (Object)((SchemaVersion)results.get(0)).getSchema().getCatName());
        Assert.assertEquals((long)1L, (long)((SchemaVersion)results.get(0)).getVersion());
        Assert.assertEquals((Object)schemaName1, (Object)((SchemaVersion)results.get(1)).getSchema().getSchemaName());
        Assert.assertEquals((Object)db.getName(), (Object)((SchemaVersion)results.get(1)).getSchema().getDbName());
        Assert.assertEquals((Object)db.getCatalogName(), (Object)((SchemaVersion)results.get(1)).getSchema().getCatName());
        Assert.assertEquals((long)2L, (long)((SchemaVersion)results.get(1)).getVersion());
        Assert.assertEquals((Object)schemaName2, (Object)((SchemaVersion)results.get(2)).getSchema().getSchemaName());
        Assert.assertEquals((Object)db.getName(), (Object)((SchemaVersion)results.get(2)).getSchema().getDbName());
        Assert.assertEquals((Object)db.getCatalogName(), (Object)((SchemaVersion)results.get(2)).getSchema().getCatName());
        Assert.assertEquals((long)1L, (long)((SchemaVersion)results.get(2)).getVersion());
        Assert.assertEquals((Object)schemaName2, (Object)((SchemaVersion)results.get(3)).getSchema().getSchemaName());
        Assert.assertEquals((Object)db.getName(), (Object)((SchemaVersion)results.get(3)).getSchema().getDbName());
        Assert.assertEquals((Object)db.getCatalogName(), (Object)((SchemaVersion)results.get(3)).getSchema().getCatName());
        Assert.assertEquals((long)2L, (long)((SchemaVersion)results.get(3)).getVersion());
        results = this.objectStore.getSchemaVersionsByColumns(null, "namespace=x", null);
        Assert.assertEquals((long)2L, (long)results.size());
        Collections.sort(results);
        Assert.assertEquals((Object)schemaName1, (Object)((SchemaVersion)results.get(0)).getSchema().getSchemaName());
        Assert.assertEquals((Object)db.getName(), (Object)((SchemaVersion)results.get(0)).getSchema().getDbName());
        Assert.assertEquals((Object)db.getCatalogName(), (Object)((SchemaVersion)results.get(0)).getSchema().getCatName());
        Assert.assertEquals((long)2L, (long)((SchemaVersion)results.get(0)).getVersion());
        Assert.assertEquals((Object)schemaName2, (Object)((SchemaVersion)results.get(1)).getSchema().getSchemaName());
        Assert.assertEquals((Object)db.getName(), (Object)((SchemaVersion)results.get(1)).getSchema().getDbName());
        Assert.assertEquals((Object)db.getCatalogName(), (Object)((SchemaVersion)results.get(1)).getSchema().getCatName());
        Assert.assertEquals((long)2L, (long)((SchemaVersion)results.get(1)).getVersion());
        results = this.objectStore.getSchemaVersionsByColumns("alpha", null, "smallint");
        Assert.assertEquals((long)2L, (long)results.size());
        Collections.sort(results);
        Assert.assertEquals((Object)schemaName2, (Object)((SchemaVersion)results.get(0)).getSchema().getSchemaName());
        Assert.assertEquals((Object)db.getName(), (Object)((SchemaVersion)results.get(0)).getSchema().getDbName());
        Assert.assertEquals((Object)db.getCatalogName(), (Object)((SchemaVersion)results.get(0)).getSchema().getCatName());
        Assert.assertEquals((long)1L, (long)((SchemaVersion)results.get(0)).getVersion());
        Assert.assertEquals((Object)schemaName2, (Object)((SchemaVersion)results.get(1)).getSchema().getSchemaName());
        Assert.assertEquals((Object)db.getName(), (Object)((SchemaVersion)results.get(1)).getSchema().getDbName());
        Assert.assertEquals((Object)db.getCatalogName(), (Object)((SchemaVersion)results.get(1)).getSchema().getCatName());
        Assert.assertEquals((long)2L, (long)((SchemaVersion)results.get(1)).getVersion());
        results = this.objectStore.getSchemaVersionsByColumns("alpha", null, "string");
        Assert.assertEquals((long)0L, (long)results.size());
    }

    @Test(expected=MetaException.class)
    public void schemaVersionQueryNoNameOrNamespace() throws MetaException {
        this.objectStore.getSchemaVersionsByColumns(null, null, "string");
    }

    private Database createUniqueDatabaseForTest() throws MetaException, InvalidObjectException {
        Object catName;
        if (rand.nextDouble() < 0.5) {
            catName = "unique_cat_for_test_" + dbNum++;
            this.objectStore.createCatalog(new CatalogBuilder().setName((String)catName).setLocation("there").build());
        } else {
            catName = "hive";
        }
        String dbName = "uniquedbfortest" + dbNum++;
        Database db = new DatabaseBuilder().setName(dbName).setCatalogName((String)catName).setLocation("somewhere").setDescription("descriptive").build(this.conf);
        this.objectStore.createDatabase(db);
        return db;
    }
}

