/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.mapping.column;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import oracle.sql.OPAQUE;
import oracle.xdb.XMLType;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.mapping.column.CharColumnMapping;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.table.Column;
import org.datanucleus.util.Localiser;

public class OracleXMLTypeColumnMapping
extends CharColumnMapping {
    public OracleXMLTypeColumnMapping(JavaTypeMapping mapping, RDBMSStoreManager storeMgr, Column col) {
        super(mapping, storeMgr, col);
    }

    @Override
    protected void initialize() {
        this.initTypeInfo();
    }

    @Override
    public int getJDBCType() {
        return 2007;
    }

    @Override
    public String getString(ResultSet rs, int param) {
        String value = null;
        try {
            OPAQUE o = (OPAQUE)rs.getObject(param);
            if (o != null) {
                value = XMLType.createXML((OPAQUE)o).getStringVal();
            }
            if (this.getDatastoreAdapter().supportsOption("NullEqualsEmptyString") && value != null && value.equals(this.getDatastoreAdapter().getSurrogateForEmptyStrings())) {
                value = "";
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(Localiser.msg((String)"055001", (Object[])new Object[]{"String", "" + param, this.column, e.getMessage()}), (Throwable)e);
        }
        return value;
    }

    @Override
    public void setString(PreparedStatement ps, int param, String value) {
        try {
            if (value == null) {
                if (this.useDefaultWhenNull()) {
                    ps.setString(param, this.column.getDefaultValue().toString().trim());
                } else {
                    ps.setNull(param, this.getJDBCType(), "SYS.XMLTYPE");
                }
            } else {
                ps.setString(param, value);
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(Localiser.msg((String)"055001", (Object[])new Object[]{"String", "" + value, this.column, e.getMessage()}), (Throwable)e);
        }
    }
}

