/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import java.io.File;
import java.io.IOException;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.DefaultPartitionExpressionProxy;
import org.apache.hadoop.hive.metastore.HiveMetaStore;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.PartitionExpressionProxy;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.events.EventCleanerTask;
import org.apache.hadoop.hive.metastore.security.HadoopThriftAuthBridge;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaStoreTestUtils {
    private static final Logger LOG = LoggerFactory.getLogger(MetaStoreTestUtils.class);
    public static final int RETRY_COUNT = 10;

    public static void startMetaStore(final int port, final HadoopThriftAuthBridge bridge, Configuration conf) throws Exception {
        if (conf == null) {
            conf = MetastoreConf.newMetastoreConf();
        }
        final Configuration finalConf = conf;
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    HiveMetaStore.startMetaStore((int)port, (HadoopThriftAuthBridge)bridge, (Configuration)finalConf);
                }
                catch (Throwable e) {
                    LOG.error("Metastore Thrift Server threw an exception...", e);
                }
            }
        }, "MetaStoreThread-" + port);
        thread.setDaemon(true);
        thread.start();
        MetaStoreTestUtils.loopUntilHMSReady(port);
    }

    public static int startMetaStoreWithRetry(HadoopThriftAuthBridge bridge) throws Exception {
        return MetaStoreTestUtils.startMetaStoreWithRetry(bridge, MetastoreConf.newMetastoreConf());
    }

    public static int startMetaStoreWithRetry(Configuration conf) throws Exception {
        return MetaStoreTestUtils.startMetaStoreWithRetry(HadoopThriftAuthBridge.getBridge(), conf);
    }

    public static int startMetaStoreWithRetry() throws Exception {
        return MetaStoreTestUtils.startMetaStoreWithRetry(HadoopThriftAuthBridge.getBridge(), MetastoreConf.newMetastoreConf());
    }

    public static int startMetaStoreWithRetry(HadoopThriftAuthBridge bridge, Configuration conf) throws Exception {
        ConnectException metaStoreException = null;
        String warehouseDir = MetastoreConf.getVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.WAREHOUSE);
        for (int tryCount = 0; tryCount < 10; ++tryCount) {
            try {
                int metaStorePort = MetaStoreTestUtils.findFreePort();
                Path postfixedWarehouseDir = new Path(warehouseDir, String.valueOf(metaStorePort));
                MetastoreConf.setVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.WAREHOUSE, (String)postfixedWarehouseDir.toString());
                MetastoreConf.setVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.THRIFT_URIS, (String)("thrift://localhost:" + metaStorePort));
                MetaStoreTestUtils.startMetaStore(metaStorePort, bridge, conf);
                LOG.error("MetaStore Thrift Server started on port: {} with warehouse dir: {}", (Object)metaStorePort, (Object)postfixedWarehouseDir);
                return metaStorePort;
            }
            catch (ConnectException ce) {
                metaStoreException = ce;
                continue;
            }
        }
        throw metaStoreException;
    }

    private static void loopUntilHMSReady(int port) throws Exception {
        int retries = 0;
        Exception exc = null;
        while (true) {
            try {
                Socket socket = new Socket();
                socket.connect(new InetSocketAddress(port), 5000);
                socket.close();
                return;
            }
            catch (Exception e) {
                if (retries++ <= 60) {
                    Thread.sleep(1000L);
                    continue;
                }
                exc = e;
                LOG.error("Unable to connect to metastore server: " + exc.getMessage());
                LOG.info("Printing all thread stack traces for debugging before throwing exception.");
                LOG.info(MetaStoreTestUtils.getAllThreadStacksAsString());
                throw exc;
            }
            break;
        }
    }

    private static String getAllThreadStacksAsString() {
        Map<Thread, StackTraceElement[]> threadStacks = Thread.getAllStackTraces();
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<Thread, StackTraceElement[]> entry : threadStacks.entrySet()) {
            Thread t = entry.getKey();
            sb.append(System.lineSeparator());
            sb.append("Name: ").append(t.getName()).append(" State: ").append((Object)t.getState());
            MetaStoreTestUtils.addStackString(entry.getValue(), sb);
        }
        return sb.toString();
    }

    private static void addStackString(StackTraceElement[] stackElems, StringBuilder sb) {
        sb.append(System.lineSeparator());
        for (StackTraceElement stackElem : stackElems) {
            sb.append(stackElem).append(System.lineSeparator());
        }
    }

    public static int findFreePort() throws IOException {
        ServerSocket socket = new ServerSocket(0);
        int port = socket.getLocalPort();
        socket.close();
        return port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int findFreePortExcepting(int portToExclude) throws IOException {
        ServerSocket socket1 = null;
        ServerSocket socket2 = null;
        try {
            socket1 = new ServerSocket(0);
            socket2 = new ServerSocket(0);
            if (socket1.getLocalPort() != portToExclude) {
                int n = socket1.getLocalPort();
                return n;
            }
            int n = socket2.getLocalPort();
            return n;
        }
        finally {
            if (socket1 != null) {
                socket1.close();
            }
            if (socket2 != null) {
                socket2.close();
            }
        }
    }

    public static void setConfForStandloneMode(Configuration conf) {
        if (MetastoreConf.getVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.TASK_THREADS_ALWAYS).equals(MetastoreConf.ConfVars.TASK_THREADS_ALWAYS.getDefaultVal())) {
            MetastoreConf.setVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.TASK_THREADS_ALWAYS, (String)EventCleanerTask.class.getName());
        }
        if (MetastoreConf.getVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.EXPRESSION_PROXY_CLASS).equals(MetastoreConf.ConfVars.EXPRESSION_PROXY_CLASS.getDefaultVal())) {
            MetastoreConf.setClass((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.EXPRESSION_PROXY_CLASS, DefaultPartitionExpressionProxy.class, PartitionExpressionProxy.class);
        }
    }

    public static String getTestWarehouseDir(String name) {
        File dir = new File(System.getProperty("java.io.tmpdir"), name);
        dir.deleteOnExit();
        return dir.getAbsolutePath();
    }

    public static void dropCatalogCascade(IMetaStoreClient client, String catName) throws TException {
        if (catName != null && !catName.equals("hive")) {
            List databases = client.getAllDatabases(catName);
            for (String db : databases) {
                client.dropDatabase(catName, db, true, false, true);
            }
            client.dropCatalog(catName);
        }
    }
}

