/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.txn;

import junit.framework.Assert;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.annotation.MetastoreUnitTest;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.txn.TxnUtils;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MetastoreUnitTest.class})
public class TestTxnHandlerNegative {
    private static final Logger LOG = LoggerFactory.getLogger(TestTxnHandlerNegative.class);

    @Test
    public void testBadConnection() throws Exception {
        Configuration conf = MetastoreConf.newMetastoreConf();
        MetastoreConf.setVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.CONNECT_URL_KEY, (String)"blah");
        Throwable e = null;
        try {
            TxnUtils.getTxnStore((Configuration)conf);
        }
        catch (RuntimeException ex) {
            LOG.info("Expected error: " + ex.getMessage(), (Throwable)ex);
            e = ex;
        }
        Assert.assertNotNull(e);
        Assert.assertTrue((e.getMessage().contains("No suitable driver found for blah") || e.getMessage().contains("Failed to get driver instance for jdbcUrl=blah") ? 1 : 0) != 0);
    }
}

