/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.client;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.MetaStoreTestUtils;
import org.apache.hadoop.hive.metastore.PartitionDropOptions;
import org.apache.hadoop.hive.metastore.annotation.MetastoreCheckinTest;
import org.apache.hadoop.hive.metastore.api.Catalog;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.client.MetaStoreClientTest;
import org.apache.hadoop.hive.metastore.client.builder.CatalogBuilder;
import org.apache.hadoop.hive.metastore.client.builder.DatabaseBuilder;
import org.apache.hadoop.hive.metastore.client.builder.PartitionBuilder;
import org.apache.hadoop.hive.metastore.client.builder.TableBuilder;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.minihms.AbstractMetaStoreService;
import org.apache.thrift.TException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Category(value={MetastoreCheckinTest.class})
public class TestDropPartitions
extends MetaStoreClientTest {
    private AbstractMetaStoreService metaStore;
    private IMetaStoreClient client;
    private static final String DB_NAME = "test_drop_part_db";
    private static final String TABLE_NAME = "test_drop_part_table";
    private static final String DEFAULT_COL_TYPE = "string";
    private static final String YEAR_COL_NAME = "year";
    private static final String MONTH_COL_NAME = "month";
    private static final short MAX = -1;
    private static final Partition[] PARTITIONS = new Partition[3];

    @BeforeClass
    public static void startMetaStores() {
        HashMap<MetastoreConf.ConfVars, String> msConf = new HashMap<MetastoreConf.ConfVars, String>();
        HashMap<String, String> extraConf = new HashMap<String, String>();
        extraConf.put("fs.trash.checkpoint.interval", "30");
        extraConf.put("fs.trash.interval", "30");
        TestDropPartitions.startMetaStores(msConf, extraConf);
    }

    public TestDropPartitions(String name, AbstractMetaStoreService metaStore) {
        this.metaStore = metaStore;
    }

    @Before
    public void setUp() throws Exception {
        this.client = this.metaStore.getClient();
        this.client.dropDatabase(DB_NAME, true, true, true);
        this.metaStore.cleanWarehouseDirs();
        Database db = new DatabaseBuilder().setName(DB_NAME).create(this.client, this.metaStore.getConf());
        this.createTable(TABLE_NAME, TestDropPartitions.getYearAndMonthPartCols(), null);
        TestDropPartitions.PARTITIONS[0] = this.createPartition(Lists.newArrayList((Object[])new String[]{"2017", "march"}), TestDropPartitions.getYearAndMonthPartCols());
        TestDropPartitions.PARTITIONS[1] = this.createPartition(Lists.newArrayList((Object[])new String[]{"2017", "april"}), TestDropPartitions.getYearAndMonthPartCols());
        TestDropPartitions.PARTITIONS[2] = this.createPartition(Lists.newArrayList((Object[])new String[]{"2018", "march"}), TestDropPartitions.getYearAndMonthPartCols());
    }

    @After
    public void tearDown() throws Exception {
        try {
            if (this.client != null) {
                this.client.close();
            }
        }
        finally {
            this.client = null;
        }
    }

    @Test
    public void testDropPartition() throws Exception {
        boolean dropSuccessful = this.client.dropPartition(DB_NAME, TABLE_NAME, PARTITIONS[0].getValues(), false);
        Assert.assertTrue((boolean)dropSuccessful);
        ArrayList droppedPartitions = Lists.newArrayList((Object[])new Partition[]{PARTITIONS[0]});
        ArrayList remainingPartitions = Lists.newArrayList((Object[])new Partition[]{PARTITIONS[1], PARTITIONS[2]});
        this.checkPartitionsAfterDelete(TABLE_NAME, droppedPartitions, remainingPartitions, false, false);
    }

    @Test
    public void testDropPartitionDeleteData() throws Exception {
        this.client.dropPartition(DB_NAME, TABLE_NAME, PARTITIONS[0].getValues(), true);
        ArrayList droppedPartitions = Lists.newArrayList((Object[])new Partition[]{PARTITIONS[0]});
        ArrayList remainingPartitions = Lists.newArrayList((Object[])new Partition[]{PARTITIONS[1], PARTITIONS[2]});
        this.checkPartitionsAfterDelete(TABLE_NAME, droppedPartitions, remainingPartitions, true, false);
    }

    @Test
    public void testDropPartitionDeleteParentDir() throws Exception {
        this.client.dropPartition(DB_NAME, TABLE_NAME, PARTITIONS[0].getValues(), true);
        this.client.dropPartition(DB_NAME, TABLE_NAME, PARTITIONS[1].getValues(), true);
        ArrayList droppedPartitions = Lists.newArrayList((Object[])new Partition[]{PARTITIONS[0], PARTITIONS[1]});
        ArrayList remainingPartitions = Lists.newArrayList((Object[])new Partition[]{PARTITIONS[2]});
        this.checkPartitionsAfterDelete(TABLE_NAME, droppedPartitions, remainingPartitions, true, false);
        Path parentPath = new Path(PARTITIONS[0].getSd().getLocation()).getParent();
        Assert.assertFalse((String)("The parent path '" + parentPath.toString() + "' should not exist."), (boolean)this.metaStore.isPathExists(parentPath));
    }

    @Test
    public void testDropPartitionDeleteDataPurge() throws Exception {
        String tableName = "purge_test";
        HashMap<String, String> tableParams = new HashMap<String, String>();
        tableParams.put("auto.purge", "true");
        this.createTable(tableName, TestDropPartitions.getYearPartCol(), tableParams);
        Partition partition1 = this.createPartition(tableName, null, Lists.newArrayList((Object[])new String[]{"2017"}), TestDropPartitions.getYearPartCol(), null);
        Partition partition2 = this.createPartition(tableName, null, Lists.newArrayList((Object[])new String[]{"2018"}), TestDropPartitions.getYearPartCol(), null);
        this.client.dropPartition(DB_NAME, tableName, partition1.getValues(), true);
        ArrayList droppedPartitions = Lists.newArrayList((Object[])new Partition[]{partition1});
        ArrayList remainingPartitions = Lists.newArrayList((Object[])new Partition[]{partition2});
        this.checkPartitionsAfterDelete(tableName, droppedPartitions, remainingPartitions, true, true);
    }

    @Test
    public void testDropPartitionArchivedPartition() throws Exception {
        String originalLocation = this.metaStore.getWarehouseRoot() + "/test_drop_part_table/2016_may";
        String location = this.metaStore.getWarehouseRoot() + "/test_drop_part_table/year=2016/month=may";
        this.metaStore.createFile(new Path(originalLocation), "test");
        HashMap<String, String> partParams = new HashMap<String, String>();
        partParams.put("is_archived", "true");
        partParams.put("original_location", originalLocation);
        Partition partition = this.createPartition(TABLE_NAME, location, Lists.newArrayList((Object[])new String[]{"2016", "may"}), TestDropPartitions.getYearAndMonthPartCols(), partParams);
        this.client.dropPartition(DB_NAME, TABLE_NAME, (List)Lists.newArrayList((Object[])new String[]{"2016", "may"}), true);
        List partitionsAfterDelete = this.client.listPartitions(DB_NAME, TABLE_NAME, (short)-1);
        Assert.assertFalse((boolean)partitionsAfterDelete.contains(partition));
        Assert.assertTrue((String)("The location '" + location + "' should exist."), (boolean)this.metaStore.isPathExists(new Path(location)));
        Assert.assertFalse((String)("The original location '" + originalLocation + "' should not exist."), (boolean)this.metaStore.isPathExists(new Path(originalLocation)));
    }

    @Test
    public void testDropPartitionExternalTable() throws Exception {
        String tableName = "external_table";
        HashMap<String, String> tableParams = new HashMap<String, String>();
        tableParams.put("EXTERNAL", "true");
        tableParams.put("auto.purge", "true");
        this.createTable(tableName, TestDropPartitions.getYearPartCol(), tableParams);
        String location = this.metaStore.getWarehouseRoot() + "/externalTable/year=2017";
        Partition partition = this.createPartition(tableName, location, Lists.newArrayList((Object[])new String[]{"2017"}), TestDropPartitions.getYearPartCol(), null);
        this.client.dropPartition(DB_NAME, tableName, partition.getValues(), true);
        List partitionsAfterDelete = this.client.listPartitions(DB_NAME, tableName, (short)-1);
        Assert.assertTrue((boolean)partitionsAfterDelete.isEmpty());
        Assert.assertTrue((String)("The location '" + location + "' should exist."), (boolean)this.metaStore.isPathExists(new Path(location)));
    }

    @Test(expected=NoSuchObjectException.class)
    public void testDropPartitionNonExistingDB() throws Exception {
        this.client.dropPartition("nonexistingdb", TABLE_NAME, (List)Lists.newArrayList((Object[])new String[]{"2017"}), false);
    }

    @Test(expected=NoSuchObjectException.class)
    public void testDropPartitionNonExistingTable() throws Exception {
        this.client.dropPartition(DB_NAME, "nonexistingtable", (List)Lists.newArrayList((Object[])new String[]{"2017"}), false);
    }

    @Test(expected=MetaException.class)
    public void testDropPartitionNullDB() throws Exception {
        this.client.dropPartition(null, TABLE_NAME, (List)Lists.newArrayList((Object[])new String[]{"2017"}), false);
    }

    @Test(expected=MetaException.class)
    public void testDropPartitionNullTable() throws Exception {
        this.client.dropPartition(DB_NAME, null, (List)Lists.newArrayList((Object[])new String[]{"2017"}), false);
    }

    @Test(expected=NoSuchObjectException.class)
    public void testDropPartitionEmptyDB() throws Exception {
        this.client.dropPartition("", TABLE_NAME, (List)Lists.newArrayList((Object[])new String[]{"2017"}), false);
    }

    @Test(expected=NoSuchObjectException.class)
    public void testDropPartitionEmptyTable() throws Exception {
        this.client.dropPartition(DB_NAME, "", (List)Lists.newArrayList((Object[])new String[]{"2017"}), false);
    }

    @Test(expected=MetaException.class)
    public void testDropPartitionNullPartVals() throws Exception {
        List partVals = null;
        this.client.dropPartition(DB_NAME, TABLE_NAME, partVals, false);
    }

    @Test(expected=MetaException.class)
    public void testDropPartitionEmptyPartVals() throws Exception {
        ArrayList partVals = new ArrayList();
        this.client.dropPartition(DB_NAME, TABLE_NAME, partVals, false);
    }

    @Test(expected=NoSuchObjectException.class)
    public void testDropPartitionNonExistingPartVals() throws Exception {
        this.client.dropPartition(DB_NAME, TABLE_NAME, (List)Lists.newArrayList((Object[])new String[]{"2017", "may"}), false);
    }

    @Test(expected=MetaException.class)
    public void testDropPartitionNullVal() throws Exception {
        ArrayList<Object> partVals = new ArrayList<Object>();
        partVals.add(null);
        partVals.add(null);
        this.client.dropPartition(DB_NAME, TABLE_NAME, partVals, false);
    }

    @Test(expected=NoSuchObjectException.class)
    public void testDropPartitionEmptyVal() throws Exception {
        ArrayList<String> partVals = new ArrayList<String>();
        partVals.add("");
        partVals.add("");
        this.client.dropPartition(DB_NAME, TABLE_NAME, partVals, false);
    }

    @Test(expected=MetaException.class)
    public void testDropPartitionMoreValsInList() throws Exception {
        this.client.dropPartition(DB_NAME, TABLE_NAME, (List)Lists.newArrayList((Object[])new String[]{"2017", "march", "12:00"}), false);
    }

    @Test(expected=MetaException.class)
    public void testDropPartitionLessValsInList() throws Exception {
        this.client.dropPartition(DB_NAME, TABLE_NAME, (List)Lists.newArrayList((Object[])new String[]{"2017"}), false);
    }

    @Test
    public void testDropPartitionNotDeleteData() throws Exception {
        PartitionDropOptions partDropOptions = PartitionDropOptions.instance();
        partDropOptions.deleteData(false);
        partDropOptions.purgeData(false);
        this.client.dropPartition(DB_NAME, TABLE_NAME, PARTITIONS[0].getValues(), partDropOptions);
        ArrayList droppedPartitions = Lists.newArrayList((Object[])new Partition[]{PARTITIONS[0]});
        ArrayList remainingPartitions = Lists.newArrayList((Object[])new Partition[]{PARTITIONS[1], PARTITIONS[2]});
        this.checkPartitionsAfterDelete(TABLE_NAME, droppedPartitions, remainingPartitions, false, false);
    }

    @Test
    public void testDropPartitionDeleteDataNoPurge() throws Exception {
        PartitionDropOptions partDropOptions = PartitionDropOptions.instance();
        partDropOptions.deleteData(true);
        partDropOptions.purgeData(false);
        this.client.dropPartition(DB_NAME, TABLE_NAME, PARTITIONS[0].getValues(), partDropOptions);
        ArrayList droppedPartitions = Lists.newArrayList((Object[])new Partition[]{PARTITIONS[0]});
        ArrayList remainingPartitions = Lists.newArrayList((Object[])new Partition[]{PARTITIONS[1], PARTITIONS[2]});
        this.checkPartitionsAfterDelete(TABLE_NAME, droppedPartitions, remainingPartitions, true, false);
    }

    @Test
    public void testDropPartitionDeleteDataAndPurge() throws Exception {
        PartitionDropOptions partDropOptions = PartitionDropOptions.instance();
        partDropOptions.deleteData(true);
        partDropOptions.purgeData(true);
        this.client.dropPartition(DB_NAME, TABLE_NAME, PARTITIONS[0].getValues(), partDropOptions);
        ArrayList droppedPartitions = Lists.newArrayList((Object[])new Partition[]{PARTITIONS[0]});
        ArrayList remainingPartitions = Lists.newArrayList((Object[])new Partition[]{PARTITIONS[1], PARTITIONS[2]});
        this.checkPartitionsAfterDelete(TABLE_NAME, droppedPartitions, remainingPartitions, true, true);
    }

    @Test
    public void testDropPartitionDeleteDataAndPurgeExternalTable() throws Exception {
        String tableName = "external_table";
        HashMap<String, String> tableParams = new HashMap<String, String>();
        tableParams.put("EXTERNAL", "true");
        this.createTable(tableName, TestDropPartitions.getYearPartCol(), tableParams);
        String location = this.metaStore.getWarehouseRoot() + "/externalTable/year=2017";
        Partition partition = this.createPartition(tableName, location, Lists.newArrayList((Object[])new String[]{"2017"}), TestDropPartitions.getYearPartCol(), null);
        PartitionDropOptions partDropOptions = PartitionDropOptions.instance();
        partDropOptions.deleteData(true);
        partDropOptions.purgeData(true);
        this.client.dropPartition(DB_NAME, tableName, partition.getValues(), partDropOptions);
        List partitionsAfterDrop = this.client.listPartitions(DB_NAME, tableName, (short)-1);
        Assert.assertTrue((boolean)partitionsAfterDrop.isEmpty());
        Assert.assertTrue((String)("The location '" + location + "' should exist."), (boolean)this.metaStore.isPathExists(new Path(location)));
    }

    @Test
    public void testDropPartitionNotDeleteDataPurge() throws Exception {
        PartitionDropOptions partDropOptions = PartitionDropOptions.instance();
        partDropOptions.deleteData(false);
        partDropOptions.purgeData(true);
        this.client.dropPartition(DB_NAME, TABLE_NAME, PARTITIONS[0].getValues(), partDropOptions);
        ArrayList droppedPartitions = Lists.newArrayList((Object[])new Partition[]{PARTITIONS[0]});
        ArrayList remainingPartitions = Lists.newArrayList((Object[])new Partition[]{PARTITIONS[1], PARTITIONS[2]});
        this.checkPartitionsAfterDelete(TABLE_NAME, droppedPartitions, remainingPartitions, false, false);
    }

    @Test
    public void testDropPartitionPurgeSetInTable() throws Exception {
        PartitionDropOptions partDropOptions = PartitionDropOptions.instance();
        partDropOptions.deleteData(true);
        partDropOptions.purgeData(false);
        String tableName = "purge_test";
        HashMap<String, String> tableParams = new HashMap<String, String>();
        tableParams.put("auto.purge", "true");
        this.createTable(tableName, TestDropPartitions.getYearPartCol(), tableParams);
        Partition partition1 = this.createPartition(tableName, null, Lists.newArrayList((Object[])new String[]{"2017"}), TestDropPartitions.getYearPartCol(), null);
        Partition partition2 = this.createPartition(tableName, null, Lists.newArrayList((Object[])new String[]{"2018"}), TestDropPartitions.getYearPartCol(), null);
        this.client.dropPartition(DB_NAME, tableName, partition1.getValues(), true);
        ArrayList droppedPartitions = Lists.newArrayList((Object[])new Partition[]{partition1});
        ArrayList remainingPartitions = Lists.newArrayList((Object[])new Partition[]{partition2});
        this.checkPartitionsAfterDelete(tableName, droppedPartitions, remainingPartitions, true, true);
    }

    @Test
    public void testDropPartitionNullPartDropOptions() throws Exception {
        this.client.dropPartition(DB_NAME, TABLE_NAME, PARTITIONS[0].getValues(), null);
        ArrayList droppedPartitions = Lists.newArrayList((Object[])new Partition[]{PARTITIONS[0]});
        ArrayList remainingPartitions = Lists.newArrayList((Object[])new Partition[]{PARTITIONS[1], PARTITIONS[2]});
        this.checkPartitionsAfterDelete(TABLE_NAME, droppedPartitions, remainingPartitions, true, false);
    }

    @Test
    public void testDropPartitionByName() throws Exception {
        this.client.dropPartition(DB_NAME, TABLE_NAME, "year=2017/month=march", false);
        ArrayList droppedPartitions = Lists.newArrayList((Object[])new Partition[]{PARTITIONS[0]});
        ArrayList remainingPartitions = Lists.newArrayList((Object[])new Partition[]{PARTITIONS[1], PARTITIONS[2]});
        this.checkPartitionsAfterDelete(TABLE_NAME, droppedPartitions, remainingPartitions, false, false);
    }

    @Test
    public void testDropPartitionByNameLessValue() throws Exception {
        try {
            this.client.dropPartition(DB_NAME, TABLE_NAME, "year=2017", true);
            Assert.fail((String)"NoSuchObjectException should be thrown.");
        }
        catch (NoSuchObjectException noSuchObjectException) {
            // empty catch block
        }
        ArrayList<Partition> droppedPartitions = new ArrayList<Partition>();
        ArrayList remainingPartitions = Lists.newArrayList((Object[])new Partition[]{PARTITIONS[0], PARTITIONS[1], PARTITIONS[2]});
        this.checkPartitionsAfterDelete(TABLE_NAME, droppedPartitions, remainingPartitions, false, false);
    }

    @Test
    public void testDropPartitionByNameMoreValue() throws Exception {
        this.client.dropPartition(DB_NAME, TABLE_NAME, "year=2017/month=march/day=10", true);
        ArrayList droppedPartitions = Lists.newArrayList((Object[])new Partition[]{PARTITIONS[0]});
        ArrayList remainingPartitions = Lists.newArrayList((Object[])new Partition[]{PARTITIONS[1], PARTITIONS[2]});
        this.checkPartitionsAfterDelete(TABLE_NAME, droppedPartitions, remainingPartitions, true, false);
    }

    @Test(expected=NoSuchObjectException.class)
    public void testDropPartitionByNameNonExistingPart() throws Exception {
        this.client.dropPartition(DB_NAME, TABLE_NAME, "year=2017/month=may", true);
    }

    @Test(expected=NoSuchObjectException.class)
    public void testDropPartitionByNameNonExistingTable() throws Exception {
        this.client.dropPartition(DB_NAME, "nonexistingtable", "year=2017/month=may", true);
    }

    @Test(expected=NoSuchObjectException.class)
    public void testDropPartitionByNameNonExistingDB() throws Exception {
        this.client.dropPartition("nonexistingdb", TABLE_NAME, "year=2017/month=may", true);
    }

    @Test(expected=NoSuchObjectException.class)
    public void testDropPartitionByNameInvalidName() throws Exception {
        this.client.dropPartition(DB_NAME, TABLE_NAME, "ev=2017/honap=march", true);
    }

    @Test(expected=NoSuchObjectException.class)
    public void testDropPartitionByNameInvalidNameFormat() throws Exception {
        this.client.dropPartition(DB_NAME, TABLE_NAME, "invalidnameformat", true);
    }

    @Test(expected=NoSuchObjectException.class)
    public void testDropPartitionByNameInvalidNameNoValues() throws Exception {
        this.client.dropPartition(DB_NAME, TABLE_NAME, "year=/month=", true);
    }

    @Test(expected=MetaException.class)
    public void testDropPartitionByNameNullName() throws Exception {
        String name = null;
        this.client.dropPartition(DB_NAME, TABLE_NAME, name, true);
    }

    @Test(expected=MetaException.class)
    public void testDropPartitionByNameEmptyName() throws Exception {
        this.client.dropPartition(DB_NAME, TABLE_NAME, "", true);
    }

    @Test
    public void otherCatalog() throws TException {
        String catName = "drop_partition_catalog";
        Catalog cat = new CatalogBuilder().setName(catName).setLocation(MetaStoreTestUtils.getTestWarehouseDir(catName)).build();
        this.client.createCatalog(cat);
        String dbName = "drop_partition_database_in_other_catalog";
        Database db = new DatabaseBuilder().setName(dbName).setCatalogName(catName).create(this.client, this.metaStore.getConf());
        String tableName = "table_in_other_catalog";
        Table table = ((TableBuilder)((TableBuilder)new TableBuilder().inDb(db).setTableName(tableName).addCol("id", "int")).addCol("name", DEFAULT_COL_TYPE)).addPartCol("partcol", DEFAULT_COL_TYPE).create(this.client, this.metaStore.getConf());
        Partition[] parts = new Partition[2];
        for (int i = 0; i < parts.length; ++i) {
            parts[i] = new PartitionBuilder().inTable(table).addValue("a" + i).build(this.metaStore.getConf());
        }
        this.client.add_partitions(Arrays.asList(parts));
        List fetched = this.client.listPartitions(catName, dbName, tableName, -1);
        Assert.assertEquals((long)parts.length, (long)fetched.size());
        Assert.assertTrue((boolean)this.client.dropPartition(catName, dbName, tableName, Collections.singletonList("a0"), PartitionDropOptions.instance().ifExists(false)));
        try {
            this.client.getPartition(catName, dbName, tableName, Collections.singletonList("a0"));
            Assert.fail();
        }
        catch (NoSuchObjectException noSuchObjectException) {
            // empty catch block
        }
        Assert.assertTrue((boolean)this.client.dropPartition(catName, dbName, tableName, "partcol=a1", true));
        try {
            this.client.getPartition(catName, dbName, tableName, Collections.singletonList("a1"));
            Assert.fail();
        }
        catch (NoSuchObjectException noSuchObjectException) {
            // empty catch block
        }
    }

    @Test(expected=NoSuchObjectException.class)
    public void testDropPartitionBogusCatalog() throws Exception {
        this.client.dropPartition("nosuch", DB_NAME, TABLE_NAME, (List)Lists.newArrayList((Object[])new String[]{"2017"}), false);
    }

    @Test(expected=NoSuchObjectException.class)
    public void testDropPartitionByNameBogusCatalog() throws Exception {
        this.client.dropPartition("nosuch", DB_NAME, TABLE_NAME, "year=2017", false);
    }

    private Table createTable(String tableName, List<FieldSchema> partCols, Map<String, String> tableParams) throws Exception {
        Table table = ((TableBuilder)((TableBuilder)((TableBuilder)new TableBuilder().setDbName(DB_NAME).setTableName(tableName).addCol("test_id", "int", "test col id")).addCol("test_value", DEFAULT_COL_TYPE, "test col value")).setPartCols(partCols).setLocation(this.metaStore.getWarehouseRoot() + "/" + tableName)).setTableParams(tableParams).create(this.client, this.metaStore.getConf());
        return table;
    }

    private Partition createPartition(List<String> values, List<FieldSchema> partCols) throws Exception {
        ((PartitionBuilder)new PartitionBuilder().setDbName(DB_NAME).setTableName(TABLE_NAME).setValues(values).setCols(partCols)).addToTable(this.client, this.metaStore.getConf());
        Partition partition = this.client.getPartition(DB_NAME, TABLE_NAME, values);
        return partition;
    }

    private Partition createPartition(String tableName, String location, List<String> values, List<FieldSchema> partCols, Map<String, String> partParams) throws Exception {
        ((PartitionBuilder)((PartitionBuilder)new PartitionBuilder().setDbName(DB_NAME).setTableName(tableName).setValues(values).setCols(partCols)).setLocation(location)).setPartParams(partParams).addToTable(this.client, this.metaStore.getConf());
        Partition partition = this.client.getPartition(DB_NAME, tableName, values);
        return partition;
    }

    private static List<FieldSchema> getYearAndMonthPartCols() {
        ArrayList<FieldSchema> cols = new ArrayList<FieldSchema>();
        cols.add(new FieldSchema(YEAR_COL_NAME, DEFAULT_COL_TYPE, "year part col"));
        cols.add(new FieldSchema(MONTH_COL_NAME, DEFAULT_COL_TYPE, "month part col"));
        return cols;
    }

    private static List<FieldSchema> getYearPartCol() {
        ArrayList<FieldSchema> cols = new ArrayList<FieldSchema>();
        cols.add(new FieldSchema(YEAR_COL_NAME, DEFAULT_COL_TYPE, "year part col"));
        return cols;
    }

    private void checkPartitionsAfterDelete(String tableName, List<Partition> droppedPartitions, List<Partition> existingPartitions, boolean deleteData, boolean purge) throws Exception {
        Path partitionPath;
        List partitions = this.client.listPartitions(DB_NAME, tableName, (short)-1);
        Assert.assertEquals((String)("The table " + tableName + " has " + partitions.size() + " partitions, but it should have " + existingPartitions.size()), (long)existingPartitions.size(), (long)partitions.size());
        for (Partition droppedPartition : droppedPartitions) {
            Assert.assertFalse((boolean)partitions.contains(droppedPartition));
            partitionPath = new Path(droppedPartition.getSd().getLocation());
            if (deleteData) {
                Assert.assertFalse((String)("The location '" + partitionPath.toString() + "' should not exist."), (boolean)this.metaStore.isPathExists(partitionPath));
                if (purge) {
                    Assert.assertFalse((String)("The location '" + partitionPath.toString() + "' should not exist in the trash."), (boolean)this.metaStore.isPathExistsInTrash(partitionPath));
                    continue;
                }
                Assert.assertTrue((String)("The location '" + partitionPath.toString() + "' should exist in the trash."), (boolean)this.metaStore.isPathExistsInTrash(partitionPath));
                continue;
            }
            Assert.assertTrue((String)("The location '" + partitionPath.toString() + "' should exist."), (boolean)this.metaStore.isPathExists(partitionPath));
        }
        for (Partition existingPartition : existingPartitions) {
            Assert.assertTrue((boolean)partitions.contains(existingPartition));
            partitionPath = new Path(existingPartition.getSd().getLocation());
            Assert.assertTrue((String)("The location '" + partitionPath.toString() + "' should exist."), (boolean)this.metaStore.isPathExists(partitionPath));
        }
    }
}

