/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.cache;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.ndv.hll.HyperLogLog;
import org.apache.hadoop.hive.metastore.HiveMetaStore;
import org.apache.hadoop.hive.metastore.MetaStoreTestUtils;
import org.apache.hadoop.hive.metastore.ObjectStore;
import org.apache.hadoop.hive.metastore.RawStore;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.annotation.MetastoreCheckinTest;
import org.apache.hadoop.hive.metastore.api.AggrStats;
import org.apache.hadoop.hive.metastore.api.BooleanColumnStatsData;
import org.apache.hadoop.hive.metastore.api.ColumnStatistics;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsData;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsDesc;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.LongColumnStatsData;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.PrincipalType;
import org.apache.hadoop.hive.metastore.api.SerDeInfo;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.StringColumnStatsData;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.cache.CachedStore;
import org.apache.hadoop.hive.metastore.cache.SharedCache;
import org.apache.hadoop.hive.metastore.client.builder.DatabaseBuilder;
import org.apache.hadoop.hive.metastore.columnstats.cache.LongColumnStatsDataInspector;
import org.apache.hadoop.hive.metastore.columnstats.cache.StringColumnStatsDataInspector;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MetastoreCheckinTest.class})
public class TestCachedStore {
    private ObjectStore objectStore;
    private CachedStore cachedStore;
    private SharedCache sharedCache;
    private Configuration conf;

    @Before
    public void setUp() throws Exception {
        this.conf = MetastoreConf.newMetastoreConf();
        MetastoreConf.setBoolVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.HIVE_IN_TEST, (boolean)true);
        MetastoreConf.setVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.CACHED_RAW_STORE_MAX_CACHE_MEMORY, (String)"-1Kb");
        MetaStoreTestUtils.setConfForStandloneMode(this.conf);
        this.objectStore = new ObjectStore();
        this.objectStore.setConf(this.conf);
        this.cachedStore = new CachedStore();
        this.cachedStore.setConfForTest(this.conf);
        CachedStore.stopCacheUpdateService((long)1L);
        this.sharedCache = new SharedCache();
        this.sharedCache.getDatabaseCache().clear();
        this.sharedCache.getTableCache().clear();
        this.sharedCache.getSdCache().clear();
        HiveMetaStore.HMSHandler.createDefaultCatalog((RawStore)this.objectStore, (Warehouse)new Warehouse(this.conf));
    }

    @Test
    public void testDatabaseOps() throws Exception {
        String dbName = "testDatabaseOps";
        String dbOwner = "user1";
        Database db = this.createTestDb(dbName, dbOwner);
        this.objectStore.createDatabase(db);
        db = this.objectStore.getDatabase("hive", dbName);
        CachedStore.setCachePrewarmedState((boolean)false);
        CachedStore.prewarm((RawStore)this.objectStore);
        Database dbRead = this.cachedStore.getDatabase("hive", dbName);
        Assert.assertEquals((Object)db, (Object)dbRead);
        String dbName1 = "testDatabaseOps1";
        Database db1 = this.createTestDb("testDatabaseOps1", dbOwner);
        this.cachedStore.createDatabase(db1);
        db1 = this.cachedStore.getDatabase("hive", "testDatabaseOps1");
        dbRead = this.objectStore.getDatabase("hive", "testDatabaseOps1");
        Assert.assertEquals((Object)db1, (Object)dbRead);
        dbOwner = "user2";
        db = new Database(db);
        db.setOwnerName(dbOwner);
        this.cachedStore.alterDatabase("hive", dbName, db);
        db = this.cachedStore.getDatabase("hive", dbName);
        dbRead = this.objectStore.getDatabase("hive", dbName);
        Assert.assertEquals((Object)db, (Object)dbRead);
        String dbName2 = "testDatabaseOps2";
        Database db2 = this.createTestDb("testDatabaseOps2", dbOwner);
        this.objectStore.createDatabase(db2);
        db2 = this.objectStore.getDatabase("hive", "testDatabaseOps2");
        dbOwner = "user1";
        db = new Database(db);
        db.setOwnerName(dbOwner);
        this.objectStore.alterDatabase("hive", dbName, db);
        db = this.objectStore.getDatabase("hive", dbName);
        this.objectStore.dropDatabase("hive", "testDatabaseOps1");
        this.updateCache(this.cachedStore);
        this.updateCache(this.cachedStore);
        dbRead = this.cachedStore.getDatabase("hive", "testDatabaseOps2");
        Assert.assertEquals((Object)db2, (Object)dbRead);
        dbRead = this.cachedStore.getDatabase("hive", dbName);
        Assert.assertEquals((Object)db, (Object)dbRead);
        try {
            dbRead = this.cachedStore.getDatabase("hive", "testDatabaseOps1");
            Assert.fail((String)"The database: testDatabaseOps1 should have been removed from the cache after running the update service");
        }
        catch (NoSuchObjectException noSuchObjectException) {
            // empty catch block
        }
        this.objectStore.dropDatabase("hive", dbName);
        this.objectStore.dropDatabase("hive", "testDatabaseOps2");
        this.sharedCache.getDatabaseCache().clear();
        this.sharedCache.getTableCache().clear();
        this.sharedCache.getSdCache().clear();
    }

    @Test
    public void testTableOps() throws Exception {
        String dbName = "testTableOps";
        String dbOwner = "user1";
        Database db = this.createTestDb(dbName, dbOwner);
        this.objectStore.createDatabase(db);
        db = this.objectStore.getDatabase("hive", dbName);
        String tblName = "tbl";
        String tblOwner = "user1";
        FieldSchema col1 = new FieldSchema("col1", "int", "integer column");
        FieldSchema col2 = new FieldSchema("col2", "string", "string column");
        ArrayList<FieldSchema> cols = new ArrayList<FieldSchema>();
        cols.add(col1);
        cols.add(col2);
        ArrayList<FieldSchema> ptnCols = new ArrayList<FieldSchema>();
        Table tbl = this.createTestTbl(dbName, tblName, tblOwner, cols, ptnCols);
        this.objectStore.createTable(tbl);
        tbl = this.objectStore.getTable("hive", dbName, tblName);
        CachedStore.setCachePrewarmedState((boolean)false);
        CachedStore.prewarm((RawStore)this.objectStore);
        Database dbRead = this.cachedStore.getDatabase("hive", dbName);
        Assert.assertEquals((Object)db, (Object)dbRead);
        Table tblRead = this.cachedStore.getTable("hive", dbName, tblName);
        Assert.assertEquals((Object)tbl, (Object)tblRead);
        String tblName1 = "tbl1";
        Table tbl1 = new Table(tbl);
        tbl1.setTableName(tblName1);
        this.cachedStore.createTable(tbl1);
        tbl1 = this.cachedStore.getTable("hive", dbName, tblName1);
        tblRead = this.objectStore.getTable("hive", dbName, tblName1);
        Assert.assertEquals((Object)tbl1, (Object)tblRead);
        String tblName2 = "tbl2";
        Table tbl2 = new Table(tbl);
        tbl2.setTableName(tblName2);
        this.objectStore.createTable(tbl2);
        tbl2 = this.objectStore.getTable("hive", dbName, tblName2);
        tblOwner = "role1";
        tbl.setOwner(tblOwner);
        tbl.setOwnerType(PrincipalType.ROLE);
        this.objectStore.alterTable("hive", dbName, tblName, tbl);
        tbl = this.objectStore.getTable("hive", dbName, tblName);
        Assert.assertEquals((String)"Owner of the table did not change.", (Object)tblOwner, (Object)tbl.getOwner());
        Assert.assertEquals((String)"Owner type of the table did not change", (Object)PrincipalType.ROLE, (Object)tbl.getOwnerType());
        this.objectStore.dropTable("hive", dbName, tblName1);
        this.updateCache(this.cachedStore);
        this.updateCache(this.cachedStore);
        tblRead = this.cachedStore.getTable("hive", dbName, tblName2);
        Assert.assertEquals((Object)tbl2, (Object)tblRead);
        tblRead = this.cachedStore.getTable("hive", dbName, tblName);
        Assert.assertEquals((Object)tbl, (Object)tblRead);
        tblRead = this.cachedStore.getTable("hive", dbName, tblName1);
        Assert.assertNull((Object)tblRead);
        List tblNames = this.cachedStore.getTables("hive", dbName, "*");
        Assert.assertTrue((boolean)tblNames.contains(tblName));
        Assert.assertTrue((!tblNames.contains(tblName1) ? 1 : 0) != 0);
        Assert.assertTrue((boolean)tblNames.contains(tblName2));
        this.objectStore.dropTable("hive", dbName, tblName);
        this.objectStore.dropTable("hive", dbName, tblName2);
        this.objectStore.dropDatabase("hive", dbName);
        this.sharedCache.getDatabaseCache().clear();
        this.sharedCache.getTableCache().clear();
        this.sharedCache.getSdCache().clear();
    }

    @Test
    public void testPartitionOps() throws Exception {
        String dbName = "testPartitionOps";
        String dbOwner = "user1";
        Database db = this.createTestDb(dbName, dbOwner);
        this.objectStore.createDatabase(db);
        db = this.objectStore.getDatabase("hive", dbName);
        String tblName = "tbl";
        String tblOwner = "user1";
        FieldSchema col1 = new FieldSchema("col1", "int", "integer column");
        FieldSchema col2 = new FieldSchema("col2", "string", "string column");
        ArrayList<FieldSchema> cols = new ArrayList<FieldSchema>();
        cols.add(col1);
        cols.add(col2);
        FieldSchema ptnCol1 = new FieldSchema("part1", "string", "string partition column");
        ArrayList<FieldSchema> ptnCols = new ArrayList<FieldSchema>();
        ptnCols.add(ptnCol1);
        Table tbl = this.createTestTbl(dbName, tblName, tblOwner, cols, ptnCols);
        this.objectStore.createTable(tbl);
        tbl = this.objectStore.getTable("hive", dbName, tblName);
        String ptnColVal1 = "aaa";
        HashMap partParams = new HashMap();
        Partition ptn1 = new Partition(Arrays.asList("aaa"), dbName, tblName, 0, 0, tbl.getSd(), partParams);
        ptn1.setCatName("hive");
        this.objectStore.addPartition(ptn1);
        ptn1 = this.objectStore.getPartition("hive", dbName, tblName, Arrays.asList("aaa"));
        ptn1.setCatName("hive");
        String ptnColVal2 = "bbb";
        Partition ptn2 = new Partition(Arrays.asList("bbb"), dbName, tblName, 0, 0, tbl.getSd(), partParams);
        ptn2.setCatName("hive");
        this.objectStore.addPartition(ptn2);
        ptn2 = this.objectStore.getPartition("hive", dbName, tblName, Arrays.asList("bbb"));
        CachedStore.setCachePrewarmedState((boolean)false);
        CachedStore.prewarm((RawStore)this.objectStore);
        Database dbRead = this.cachedStore.getDatabase("hive", dbName);
        Assert.assertEquals((Object)db, (Object)dbRead);
        Table tblRead = this.cachedStore.getTable("hive", dbName, tblName);
        Assert.assertEquals((Object)tbl, (Object)tblRead);
        Partition ptn1Read = this.cachedStore.getPartition("hive", dbName, tblName, Arrays.asList("aaa"));
        Assert.assertEquals((Object)ptn1, (Object)ptn1Read);
        Partition ptn2Read = this.cachedStore.getPartition("hive", dbName, tblName, Arrays.asList("bbb"));
        Assert.assertEquals((Object)ptn2, (Object)ptn2Read);
        String ptnColVal3 = "ccc";
        Partition ptn3 = new Partition(Arrays.asList("ccc"), dbName, tblName, 0, 0, tbl.getSd(), partParams);
        ptn3.setCatName("hive");
        this.objectStore.addPartition(ptn3);
        ptn3 = this.objectStore.getPartition("hive", dbName, tblName, Arrays.asList("ccc"));
        String ptnColVal1Alt = "aaaAlt";
        Partition ptn1Atl = new Partition(Arrays.asList("aaaAlt"), dbName, tblName, 0, 0, tbl.getSd(), partParams);
        ptn1Atl.setCatName("hive");
        this.objectStore.alterPartition("hive", dbName, tblName, Arrays.asList("aaa"), ptn1Atl);
        ptn1Atl = this.objectStore.getPartition("hive", dbName, tblName, Arrays.asList("aaaAlt"));
        this.objectStore.dropPartition("hive", dbName, tblName, Arrays.asList("bbb"));
        this.updateCache(this.cachedStore);
        this.updateCache(this.cachedStore);
        Partition ptnRead = this.cachedStore.getPartition("hive", dbName, tblName, Arrays.asList("ccc"));
        Assert.assertEquals((Object)ptn3, (Object)ptnRead);
        ptnRead = this.cachedStore.getPartition("hive", dbName, tblName, Arrays.asList("aaaAlt"));
        Assert.assertEquals((Object)ptn1Atl, (Object)ptnRead);
        try {
            ptnRead = this.cachedStore.getPartition("hive", dbName, tblName, Arrays.asList("bbb"));
            Assert.fail((String)"The partition: bbb should have been removed from the cache after running the update service");
        }
        catch (NoSuchObjectException noSuchObjectException) {
            // empty catch block
        }
        this.objectStore.dropPartition("hive", dbName, tblName, Arrays.asList("aaaAlt"));
        this.objectStore.dropPartition("hive", dbName, tblName, Arrays.asList("ccc"));
        this.objectStore.dropTable("hive", dbName, tblName);
        this.objectStore.dropDatabase("hive", dbName);
        this.sharedCache.getDatabaseCache().clear();
        this.sharedCache.getTableCache().clear();
        this.sharedCache.getSdCache().clear();
    }

    public void testTableColStatsOps() throws Exception {
        String dbName = "testTableColStatsOps";
        String dbOwner = "user1";
        Database db = this.createTestDb(dbName, dbOwner);
        this.objectStore.createDatabase(db);
        db = this.objectStore.getDatabase("hive", dbName);
        String tblName = "tbl";
        String tblOwner = "user1";
        FieldSchema col1 = new FieldSchema("col1", "int", "integer column");
        long col1LowVal = 5L;
        long col1HighVal = 500L;
        long col1Nulls = 10L;
        long col1DV = 20L;
        FieldSchema col2 = new FieldSchema("col2", "string", "string column");
        long col2MaxColLen = 100L;
        double col2AvgColLen = 45.5;
        long col2Nulls = 5L;
        long col2DV = 40L;
        FieldSchema col3 = new FieldSchema("col3", "boolean", "boolean column");
        long col3NumTrues = 100L;
        long col3NumFalses = 30L;
        long col3Nulls = 10L;
        ArrayList<FieldSchema> cols = new ArrayList<FieldSchema>();
        cols.add(col1);
        cols.add(col2);
        cols.add(col3);
        FieldSchema ptnCol1 = new FieldSchema("part1", "string", "string partition column");
        ArrayList<FieldSchema> ptnCols = new ArrayList<FieldSchema>();
        ptnCols.add(ptnCol1);
        Table tbl = this.createTestTbl(dbName, "tbl", "user1", cols, ptnCols);
        this.objectStore.createTable(tbl);
        tbl = this.objectStore.getTable("hive", dbName, "tbl");
        ColumnStatistics stats = new ColumnStatistics();
        ColumnStatisticsDesc statsDesc = new ColumnStatisticsDesc(true, dbName, "tbl");
        ArrayList<ColumnStatisticsObj> colStatObjs = new ArrayList<ColumnStatisticsObj>();
        ColumnStatisticsData data1 = new ColumnStatisticsData();
        ColumnStatisticsObj col1Stats = new ColumnStatisticsObj(col1.getName(), col1.getType(), data1);
        LongColumnStatsDataInspector longStats = new LongColumnStatsDataInspector();
        longStats.setLowValue(col1LowVal);
        longStats.setHighValue(col1HighVal);
        longStats.setNumNulls(col1Nulls);
        longStats.setNumDVs(col1DV);
        data1.setLongStats((LongColumnStatsData)longStats);
        colStatObjs.add(col1Stats);
        ColumnStatisticsData data2 = new ColumnStatisticsData();
        ColumnStatisticsObj col2Stats = new ColumnStatisticsObj(col2.getName(), col2.getType(), data2);
        StringColumnStatsDataInspector stringStats = new StringColumnStatsDataInspector();
        stringStats.setMaxColLen(col2MaxColLen);
        stringStats.setAvgColLen(col2AvgColLen);
        stringStats.setNumNulls(col2Nulls);
        stringStats.setNumDVs(col2DV);
        data2.setStringStats((StringColumnStatsData)stringStats);
        colStatObjs.add(col2Stats);
        ColumnStatisticsData data3 = new ColumnStatisticsData();
        ColumnStatisticsObj col3Stats = new ColumnStatisticsObj(col3.getName(), col3.getType(), data3);
        BooleanColumnStatsData boolStats = new BooleanColumnStatsData();
        boolStats.setNumTrues(col3NumTrues);
        boolStats.setNumFalses(col3NumFalses);
        boolStats.setNumNulls(col3Nulls);
        data3.setBooleanStats(boolStats);
        colStatObjs.add(col3Stats);
        stats.setStatsDesc(statsDesc);
        stats.setStatsObj(colStatObjs);
        this.objectStore.updateTableColumnStatistics(stats);
        CachedStore.setCachePrewarmedState((boolean)false);
        CachedStore.prewarm((RawStore)this.objectStore);
        ColumnStatistics newStats = this.cachedStore.getTableColumnStatistics("hive", dbName, "tbl", Arrays.asList(col1.getName(), col2.getName(), col3.getName()));
        Assert.assertEquals((Object)stats, (Object)newStats);
        this.objectStore.dropTable("hive", dbName, "tbl");
        this.objectStore.dropDatabase("hive", dbName);
        this.sharedCache.getDatabaseCache().clear();
        this.sharedCache.getTableCache().clear();
        this.sharedCache.getSdCache().clear();
    }

    @Test
    public void testSharedStoreDb() {
        Database db1 = this.createTestDb("db1", "user1");
        Database db2 = this.createTestDb("db2", "user1");
        Database db3 = this.createTestDb("db3", "user1");
        Database newDb1 = this.createTestDb("newdb1", "user1");
        this.sharedCache.addDatabaseToCache(db1);
        this.sharedCache.addDatabaseToCache(db2);
        this.sharedCache.addDatabaseToCache(db3);
        Assert.assertEquals((long)this.sharedCache.getCachedDatabaseCount(), (long)3L);
        this.sharedCache.alterDatabaseInCache("hive", "db1", newDb1);
        Assert.assertEquals((long)this.sharedCache.getCachedDatabaseCount(), (long)3L);
        this.sharedCache.removeDatabaseFromCache("hive", "db2");
        Assert.assertEquals((long)this.sharedCache.getCachedDatabaseCount(), (long)2L);
        List dbs = this.sharedCache.listCachedDatabases("hive");
        Assert.assertEquals((long)dbs.size(), (long)2L);
        Assert.assertTrue((boolean)dbs.contains("newdb1"));
        Assert.assertTrue((boolean)dbs.contains("db3"));
    }

    @Test
    public void testSharedStoreTable() {
        Table tbl1 = new Table();
        StorageDescriptor sd1 = new StorageDescriptor();
        ArrayList<FieldSchema> cols1 = new ArrayList<FieldSchema>();
        cols1.add(new FieldSchema("col1", "int", ""));
        HashMap<String, String> params1 = new HashMap<String, String>();
        params1.put("key", "value");
        sd1.setCols(cols1);
        sd1.setParameters(params1);
        sd1.setLocation("loc1");
        tbl1.setSd(sd1);
        tbl1.setPartitionKeys(new ArrayList());
        Table tbl2 = new Table();
        StorageDescriptor sd2 = new StorageDescriptor();
        ArrayList<FieldSchema> cols2 = new ArrayList<FieldSchema>();
        cols2.add(new FieldSchema("col1", "int", ""));
        HashMap<String, String> params2 = new HashMap<String, String>();
        params2.put("key", "value");
        sd2.setCols(cols2);
        sd2.setParameters(params2);
        sd2.setLocation("loc2");
        tbl2.setSd(sd2);
        tbl2.setPartitionKeys(new ArrayList());
        Table tbl3 = new Table();
        StorageDescriptor sd3 = new StorageDescriptor();
        ArrayList<FieldSchema> cols3 = new ArrayList<FieldSchema>();
        cols3.add(new FieldSchema("col3", "int", ""));
        HashMap<String, String> params3 = new HashMap<String, String>();
        params3.put("key2", "value2");
        sd3.setCols(cols3);
        sd3.setParameters(params3);
        sd3.setLocation("loc3");
        tbl3.setSd(sd3);
        tbl3.setPartitionKeys(new ArrayList());
        Table newTbl1 = new Table();
        newTbl1.setDbName("db2");
        newTbl1.setTableName("tbl1");
        StorageDescriptor newSd1 = new StorageDescriptor();
        ArrayList<FieldSchema> newCols1 = new ArrayList<FieldSchema>();
        newCols1.add(new FieldSchema("newcol1", "int", ""));
        HashMap<String, String> newParams1 = new HashMap<String, String>();
        newParams1.put("key", "value");
        newSd1.setCols(newCols1);
        newSd1.setParameters(params1);
        newSd1.setLocation("loc1");
        newTbl1.setSd(newSd1);
        newTbl1.setPartitionKeys(new ArrayList());
        this.sharedCache.addTableToCache("hive", "db1", "tbl1", tbl1);
        this.sharedCache.addTableToCache("hive", "db1", "tbl2", tbl2);
        this.sharedCache.addTableToCache("hive", "db1", "tbl3", tbl3);
        this.sharedCache.addTableToCache("hive", "db2", "tbl1", tbl1);
        Assert.assertEquals((long)this.sharedCache.getCachedTableCount(), (long)4L);
        Assert.assertEquals((long)this.sharedCache.getSdCache().size(), (long)2L);
        Table t = this.sharedCache.getTableFromCache("hive", "db1", "tbl1");
        Assert.assertEquals((Object)t.getSd().getLocation(), (Object)"loc1");
        this.sharedCache.removeTableFromCache("hive", "db1", "tbl1");
        Assert.assertEquals((long)this.sharedCache.getCachedTableCount(), (long)3L);
        Assert.assertEquals((long)this.sharedCache.getSdCache().size(), (long)2L);
        this.sharedCache.alterTableInCache("hive", "db2", "tbl1", newTbl1);
        Assert.assertEquals((long)this.sharedCache.getCachedTableCount(), (long)3L);
        Assert.assertEquals((long)this.sharedCache.getSdCache().size(), (long)3L);
        this.sharedCache.removeTableFromCache("hive", "db1", "tbl2");
        Assert.assertEquals((long)this.sharedCache.getCachedTableCount(), (long)2L);
        Assert.assertEquals((long)this.sharedCache.getSdCache().size(), (long)2L);
    }

    @Test
    public void testSharedStorePartition() {
        String dbName = "db1";
        String tbl1Name = "tbl1";
        String tbl2Name = "tbl2";
        String owner = "user1";
        Database db = this.createTestDb(dbName, owner);
        this.sharedCache.addDatabaseToCache(db);
        FieldSchema col1 = new FieldSchema("col1", "int", "integer column");
        FieldSchema col2 = new FieldSchema("col2", "string", "string column");
        ArrayList<FieldSchema> cols = new ArrayList<FieldSchema>();
        cols.add(col1);
        cols.add(col2);
        ArrayList<FieldSchema> ptnCols = new ArrayList<FieldSchema>();
        Table tbl1 = this.createTestTbl(dbName, tbl1Name, owner, cols, ptnCols);
        this.sharedCache.addTableToCache("hive", dbName, tbl1Name, tbl1);
        Table tbl2 = this.createTestTbl(dbName, tbl2Name, owner, cols, ptnCols);
        this.sharedCache.addTableToCache("hive", dbName, tbl2Name, tbl2);
        Partition part1 = new Partition();
        StorageDescriptor sd1 = new StorageDescriptor();
        ArrayList<FieldSchema> cols1 = new ArrayList<FieldSchema>();
        cols1.add(new FieldSchema("col1", "int", ""));
        HashMap<String, String> params1 = new HashMap<String, String>();
        params1.put("key", "value");
        sd1.setCols(cols1);
        sd1.setParameters(params1);
        sd1.setLocation("loc1");
        part1.setSd(sd1);
        part1.setValues(Arrays.asList("201701"));
        Partition part2 = new Partition();
        StorageDescriptor sd2 = new StorageDescriptor();
        ArrayList<FieldSchema> cols2 = new ArrayList<FieldSchema>();
        cols2.add(new FieldSchema("col1", "int", ""));
        HashMap<String, String> params2 = new HashMap<String, String>();
        params2.put("key", "value");
        sd2.setCols(cols2);
        sd2.setParameters(params2);
        sd2.setLocation("loc2");
        part2.setSd(sd2);
        part2.setValues(Arrays.asList("201702"));
        Partition part3 = new Partition();
        StorageDescriptor sd3 = new StorageDescriptor();
        ArrayList<FieldSchema> cols3 = new ArrayList<FieldSchema>();
        cols3.add(new FieldSchema("col3", "int", ""));
        HashMap<String, String> params3 = new HashMap<String, String>();
        params3.put("key2", "value2");
        sd3.setCols(cols3);
        sd3.setParameters(params3);
        sd3.setLocation("loc3");
        part3.setSd(sd3);
        part3.setValues(Arrays.asList("201703"));
        Partition newPart1 = new Partition();
        newPart1.setDbName(dbName);
        newPart1.setTableName(tbl1Name);
        StorageDescriptor newSd1 = new StorageDescriptor();
        ArrayList<FieldSchema> newCols1 = new ArrayList<FieldSchema>();
        newCols1.add(new FieldSchema("newcol1", "int", ""));
        HashMap<String, String> newParams1 = new HashMap<String, String>();
        newParams1.put("key", "value");
        newSd1.setCols(newCols1);
        newSd1.setParameters(params1);
        newSd1.setLocation("loc1new");
        newPart1.setSd(newSd1);
        newPart1.setValues(Arrays.asList("201701"));
        this.sharedCache.addPartitionToCache("hive", dbName, tbl1Name, part1);
        this.sharedCache.addPartitionToCache("hive", dbName, tbl1Name, part2);
        this.sharedCache.addPartitionToCache("hive", dbName, tbl1Name, part3);
        this.sharedCache.addPartitionToCache("hive", dbName, tbl2Name, part1);
        Partition t = this.sharedCache.getPartitionFromCache("hive", dbName, tbl1Name, Arrays.asList("201701"));
        Assert.assertEquals((Object)t.getSd().getLocation(), (Object)"loc1");
        this.sharedCache.removePartitionFromCache("hive", dbName, tbl2Name, Arrays.asList("201701"));
        t = this.sharedCache.getPartitionFromCache("hive", dbName, tbl2Name, Arrays.asList("201701"));
        Assert.assertNull((Object)t);
        this.sharedCache.alterPartitionInCache("hive", dbName, tbl1Name, Arrays.asList("201701"), newPart1);
        t = this.sharedCache.getPartitionFromCache("hive", dbName, tbl1Name, Arrays.asList("201701"));
        Assert.assertEquals((Object)t.getSd().getLocation(), (Object)"loc1new");
    }

    @Test
    public void testAggrStatsRepeatedRead() throws Exception {
        String dbName = "testTableColStatsOps";
        String tblName = "tbl";
        String colName = "f1";
        Database db = new DatabaseBuilder().setName(dbName).setLocation("some_location").build(this.conf);
        this.cachedStore.createDatabase(db);
        ArrayList<FieldSchema> cols = new ArrayList<FieldSchema>();
        cols.add(new FieldSchema(colName, "int", null));
        ArrayList<FieldSchema> partCols = new ArrayList<FieldSchema>();
        partCols.add(new FieldSchema("col", "int", null));
        StorageDescriptor sd = new StorageDescriptor(cols, null, "input", "output", false, 0, new SerDeInfo("serde", "seriallib", new HashMap()), null, null, null);
        Table tbl = new Table(tblName, dbName, null, 0, 0, 0, sd, partCols, new HashMap(), null, null, TableType.MANAGED_TABLE.toString());
        tbl.setCatName("hive");
        this.cachedStore.createTable(tbl);
        ArrayList<String> partVals1 = new ArrayList<String>();
        partVals1.add("1");
        ArrayList<String> partVals2 = new ArrayList<String>();
        partVals2.add("2");
        Partition ptn1 = new Partition(partVals1, dbName, tblName, 0, 0, sd, new HashMap());
        ptn1.setCatName("hive");
        this.cachedStore.addPartition(ptn1);
        Partition ptn2 = new Partition(partVals2, dbName, tblName, 0, 0, sd, new HashMap());
        ptn2.setCatName("hive");
        this.cachedStore.addPartition(ptn2);
        ColumnStatistics stats = new ColumnStatistics();
        ColumnStatisticsDesc statsDesc = new ColumnStatisticsDesc(true, dbName, tblName);
        statsDesc.setPartName("col");
        ArrayList<ColumnStatisticsObj> colStatObjs = new ArrayList<ColumnStatisticsObj>();
        ColumnStatisticsData data = new ColumnStatisticsData();
        ColumnStatisticsObj colStats = new ColumnStatisticsObj(colName, "int", data);
        LongColumnStatsDataInspector longStats = new LongColumnStatsDataInspector();
        longStats.setLowValue(0L);
        longStats.setHighValue(100L);
        longStats.setNumNulls(50L);
        longStats.setNumDVs(30L);
        data.setLongStats((LongColumnStatsData)longStats);
        colStatObjs.add(colStats);
        stats.setStatsDesc(statsDesc);
        stats.setStatsObj(colStatObjs);
        this.cachedStore.updatePartitionColumnStatistics(stats.deepCopy(), partVals1);
        this.cachedStore.updatePartitionColumnStatistics(stats.deepCopy(), partVals2);
        ArrayList<String> colNames = new ArrayList<String>();
        colNames.add(colName);
        ArrayList<String> aggrPartVals = new ArrayList<String>();
        aggrPartVals.add("1");
        aggrPartVals.add("2");
        AggrStats aggrStats = this.cachedStore.get_aggr_stats_for("hive", dbName, tblName, aggrPartVals, colNames);
        Assert.assertEquals((long)((ColumnStatisticsObj)aggrStats.getColStats().get(0)).getStatsData().getLongStats().getNumNulls(), (long)100L);
        aggrStats = this.cachedStore.get_aggr_stats_for("hive", dbName, tblName, aggrPartVals, colNames);
        Assert.assertEquals((long)((ColumnStatisticsObj)aggrStats.getColStats().get(0)).getStatsData().getLongStats().getNumNulls(), (long)100L);
    }

    @Test
    public void testPartitionAggrStats() throws Exception {
        String dbName = "testTableColStatsOps1";
        String tblName = "tbl1";
        String colName = "f1";
        Database db = new Database(dbName, null, "some_location", null);
        db.setCatalogName("hive");
        this.cachedStore.createDatabase(db);
        ArrayList<FieldSchema> cols = new ArrayList<FieldSchema>();
        cols.add(new FieldSchema(colName, "int", null));
        ArrayList<FieldSchema> partCols = new ArrayList<FieldSchema>();
        partCols.add(new FieldSchema("col", "int", null));
        StorageDescriptor sd = new StorageDescriptor(cols, null, "input", "output", false, 0, new SerDeInfo("serde", "seriallib", new HashMap()), null, null, null);
        Table tbl = new Table(tblName, dbName, null, 0, 0, 0, sd, partCols, new HashMap(), null, null, TableType.MANAGED_TABLE.toString());
        tbl.setCatName("hive");
        this.cachedStore.createTable(tbl);
        ArrayList<String> partVals1 = new ArrayList<String>();
        partVals1.add("1");
        ArrayList<String> partVals2 = new ArrayList<String>();
        partVals2.add("2");
        Partition ptn1 = new Partition(partVals1, dbName, tblName, 0, 0, sd, new HashMap());
        ptn1.setCatName("hive");
        this.cachedStore.addPartition(ptn1);
        Partition ptn2 = new Partition(partVals2, dbName, tblName, 0, 0, sd, new HashMap());
        ptn2.setCatName("hive");
        this.cachedStore.addPartition(ptn2);
        ColumnStatistics stats = new ColumnStatistics();
        ColumnStatisticsDesc statsDesc = new ColumnStatisticsDesc(true, dbName, tblName);
        statsDesc.setPartName("col");
        ArrayList<ColumnStatisticsObj> colStatObjs = new ArrayList<ColumnStatisticsObj>();
        ColumnStatisticsData data = new ColumnStatisticsData();
        ColumnStatisticsObj colStats = new ColumnStatisticsObj(colName, "int", data);
        LongColumnStatsDataInspector longStats = new LongColumnStatsDataInspector();
        longStats.setLowValue(0L);
        longStats.setHighValue(100L);
        longStats.setNumNulls(50L);
        longStats.setNumDVs(30L);
        data.setLongStats((LongColumnStatsData)longStats);
        colStatObjs.add(colStats);
        stats.setStatsDesc(statsDesc);
        stats.setStatsObj(colStatObjs);
        this.cachedStore.updatePartitionColumnStatistics(stats.deepCopy(), partVals1);
        longStats.setNumDVs(40L);
        this.cachedStore.updatePartitionColumnStatistics(stats.deepCopy(), partVals2);
        ArrayList<String> colNames = new ArrayList<String>();
        colNames.add(colName);
        ArrayList<String> aggrPartVals = new ArrayList<String>();
        aggrPartVals.add("1");
        aggrPartVals.add("2");
        AggrStats aggrStats = this.cachedStore.get_aggr_stats_for("hive", dbName, tblName, aggrPartVals, colNames);
        Assert.assertEquals((long)((ColumnStatisticsObj)aggrStats.getColStats().get(0)).getStatsData().getLongStats().getNumNulls(), (long)100L);
        Assert.assertEquals((long)((ColumnStatisticsObj)aggrStats.getColStats().get(0)).getStatsData().getLongStats().getNumDVs(), (long)40L);
        aggrStats = this.cachedStore.get_aggr_stats_for("hive", dbName, tblName, aggrPartVals, colNames);
        Assert.assertEquals((long)((ColumnStatisticsObj)aggrStats.getColStats().get(0)).getStatsData().getLongStats().getNumNulls(), (long)100L);
        Assert.assertEquals((long)((ColumnStatisticsObj)aggrStats.getColStats().get(0)).getStatsData().getLongStats().getNumDVs(), (long)40L);
    }

    @Test
    public void testPartitionAggrStatsBitVector() throws Exception {
        String dbName = "testTableColStatsOps2";
        String tblName = "tbl2";
        String colName = "f1";
        Database db = new Database(dbName, null, "some_location", null);
        db.setCatalogName("hive");
        this.cachedStore.createDatabase(db);
        ArrayList<FieldSchema> cols = new ArrayList<FieldSchema>();
        cols.add(new FieldSchema(colName, "int", null));
        ArrayList<FieldSchema> partCols = new ArrayList<FieldSchema>();
        partCols.add(new FieldSchema("col", "int", null));
        StorageDescriptor sd = new StorageDescriptor(cols, null, "input", "output", false, 0, new SerDeInfo("serde", "seriallib", new HashMap()), null, null, null);
        Table tbl = new Table(tblName, dbName, null, 0, 0, 0, sd, partCols, new HashMap(), null, null, TableType.MANAGED_TABLE.toString());
        tbl.setCatName("hive");
        this.cachedStore.createTable(tbl);
        ArrayList<String> partVals1 = new ArrayList<String>();
        partVals1.add("1");
        ArrayList<String> partVals2 = new ArrayList<String>();
        partVals2.add("2");
        Partition ptn1 = new Partition(partVals1, dbName, tblName, 0, 0, sd, new HashMap());
        ptn1.setCatName("hive");
        this.cachedStore.addPartition(ptn1);
        Partition ptn2 = new Partition(partVals2, dbName, tblName, 0, 0, sd, new HashMap());
        ptn2.setCatName("hive");
        this.cachedStore.addPartition(ptn2);
        ColumnStatistics stats = new ColumnStatistics();
        ColumnStatisticsDesc statsDesc = new ColumnStatisticsDesc(true, dbName, tblName);
        statsDesc.setPartName("col");
        ArrayList<ColumnStatisticsObj> colStatObjs = new ArrayList<ColumnStatisticsObj>();
        ColumnStatisticsData data = new ColumnStatisticsData();
        ColumnStatisticsObj colStats = new ColumnStatisticsObj(colName, "int", data);
        LongColumnStatsDataInspector longStats = new LongColumnStatsDataInspector();
        longStats.setLowValue(0L);
        longStats.setHighValue(100L);
        longStats.setNumNulls(50L);
        longStats.setNumDVs(30L);
        HyperLogLog hll = HyperLogLog.builder().build();
        hll.addLong(1L);
        hll.addLong(2L);
        hll.addLong(3L);
        longStats.setBitVectors(hll.serialize());
        data.setLongStats((LongColumnStatsData)longStats);
        colStatObjs.add(colStats);
        stats.setStatsDesc(statsDesc);
        stats.setStatsObj(colStatObjs);
        this.cachedStore.updatePartitionColumnStatistics(stats.deepCopy(), partVals1);
        longStats.setNumDVs(40L);
        hll = HyperLogLog.builder().build();
        hll.addLong(2L);
        hll.addLong(3L);
        hll.addLong(4L);
        hll.addLong(5L);
        longStats.setBitVectors(hll.serialize());
        this.cachedStore.updatePartitionColumnStatistics(stats.deepCopy(), partVals2);
        ArrayList<String> colNames = new ArrayList<String>();
        colNames.add(colName);
        ArrayList<String> aggrPartVals = new ArrayList<String>();
        aggrPartVals.add("1");
        aggrPartVals.add("2");
        AggrStats aggrStats = this.cachedStore.get_aggr_stats_for("hive", dbName, tblName, aggrPartVals, colNames);
        Assert.assertEquals((long)((ColumnStatisticsObj)aggrStats.getColStats().get(0)).getStatsData().getLongStats().getNumNulls(), (long)100L);
        Assert.assertEquals((long)((ColumnStatisticsObj)aggrStats.getColStats().get(0)).getStatsData().getLongStats().getNumDVs(), (long)5L);
        aggrStats = this.cachedStore.get_aggr_stats_for("hive", dbName, tblName, aggrPartVals, colNames);
        Assert.assertEquals((long)((ColumnStatisticsObj)aggrStats.getColStats().get(0)).getStatsData().getLongStats().getNumNulls(), (long)100L);
        Assert.assertEquals((long)((ColumnStatisticsObj)aggrStats.getColStats().get(0)).getStatsData().getLongStats().getNumDVs(), (long)5L);
    }

    @Test
    public void testMultiThreadedSharedCacheOps() throws Exception {
        final ArrayList<String> dbNames = new ArrayList<String>(Arrays.asList("db1", "db2", "db3", "db4", "db5"));
        ArrayList<Callable<Object>> tasks = new ArrayList<Callable<Object>>();
        ExecutorService executor = Executors.newFixedThreadPool(50, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = Executors.defaultThreadFactory().newThread(r);
                t.setDaemon(true);
                return t;
            }
        });
        for (final String string : dbNames) {
            Callable<Object> callable = new Callable<Object>(){

                @Override
                public Object call() {
                    Database db = TestCachedStore.this.createTestDb(string, "user1");
                    TestCachedStore.this.sharedCache.addDatabaseToCache(db);
                    return null;
                }
            };
            tasks.add(callable);
        }
        executor.invokeAll(tasks);
        for (String string : dbNames) {
            Database database = this.sharedCache.getDatabaseFromCache("hive", string);
            Assert.assertNotNull((Object)database);
            Assert.assertEquals((Object)string, (Object)database.getName());
        }
        ArrayList<String> tblNames = new ArrayList<String>(Arrays.asList("tbl1", "tbl2", "tbl3", "tbl4", "tbl5"));
        tasks.clear();
        for (final String string : tblNames) {
            FieldSchema col1 = new FieldSchema("col1", "int", "integer column");
            FieldSchema col2 = new FieldSchema("col2", "string", "string column");
            final ArrayList<FieldSchema> cols = new ArrayList<FieldSchema>();
            cols.add(col1);
            cols.add(col2);
            FieldSchema ptnCol1 = new FieldSchema("part1", "string", "string partition column");
            final ArrayList<FieldSchema> ptnCols = new ArrayList<FieldSchema>();
            ptnCols.add(ptnCol1);
            Callable<Object> callable = new Callable<Object>(){

                @Override
                public Object call() {
                    Table tbl = TestCachedStore.this.createTestTbl((String)dbNames.get(0), string, "user1", cols, ptnCols);
                    TestCachedStore.this.sharedCache.addTableToCache("hive", (String)dbNames.get(0), string, tbl);
                    return null;
                }
            };
            tasks.add(callable);
        }
        executor.invokeAll(tasks);
        for (String string : tblNames) {
            Table tbl = this.sharedCache.getTableFromCache("hive", (String)dbNames.get(0), string);
            Assert.assertNotNull((Object)tbl);
            Assert.assertEquals((Object)string, (Object)tbl.getTableName());
        }
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList("aaa", "bbb", "ccc", "ddd", "eee"));
        tasks.clear();
        for (final String tblName : tblNames) {
            final Table tbl = this.sharedCache.getTableFromCache("hive", (String)dbNames.get(0), tblName);
            for (final String ptnVal : arrayList) {
                final HashMap partParams = new HashMap();
                Callable<Object> callable = new Callable<Object>(){

                    @Override
                    public Object call() {
                        Partition ptn = new Partition(Arrays.asList(ptnVal), (String)dbNames.get(0), tblName, 0, 0, tbl.getSd(), partParams);
                        TestCachedStore.this.sharedCache.addPartitionToCache("hive", (String)dbNames.get(0), tblName, ptn);
                        return null;
                    }
                };
                tasks.add(callable);
            }
        }
        executor.invokeAll(tasks);
        for (final String tblName : tblNames) {
            for (String ptnVal : arrayList) {
                Partition ptn = this.sharedCache.getPartitionFromCache("hive", (String)dbNames.get(0), tblName, Arrays.asList(ptnVal));
                Assert.assertNotNull((Object)ptn);
                Assert.assertEquals((Object)tblName, (Object)ptn.getTableName());
                Assert.assertEquals((Object)tblName, (Object)ptn.getTableName());
                Assert.assertEquals(Arrays.asList(ptnVal), (Object)ptn.getValues());
            }
        }
        ArrayList<String> arrayList2 = new ArrayList<String>(Arrays.asList("fff", "ggg"));
        ArrayList<String> dropPtnTblNames = new ArrayList<String>(Arrays.asList("tbl1", "tbl2", "tbl3"));
        ArrayList<String> addPtnTblNames = new ArrayList<String>(Arrays.asList("tbl4", "tbl5"));
        tasks.clear();
        for (final String tblName : dropPtnTblNames) {
            for (final String string : arrayList) {
                Callable<Object> c3 = new Callable<Object>(){

                    @Override
                    public Object call() {
                        TestCachedStore.this.sharedCache.removePartitionFromCache("hive", (String)dbNames.get(0), tblName, Arrays.asList(string));
                        return null;
                    }
                };
                tasks.add(c3);
            }
        }
        for (final String tblName : addPtnTblNames) {
            final Table tbl = this.sharedCache.getTableFromCache("hive", (String)dbNames.get(0), tblName);
            for (final String ptnVal : arrayList2) {
                final HashMap partParams = new HashMap();
                Callable<Object> c4 = new Callable<Object>(){

                    @Override
                    public Object call() {
                        Partition ptn = new Partition(Arrays.asList(ptnVal), (String)dbNames.get(0), tblName, 0, 0, tbl.getSd(), partParams);
                        TestCachedStore.this.sharedCache.addPartitionToCache("hive", (String)dbNames.get(0), tblName, ptn);
                        return null;
                    }
                };
                tasks.add(c4);
            }
        }
        executor.invokeAll(tasks);
        for (final String tblName : addPtnTblNames) {
            for (String string : arrayList2) {
                Partition ptn = this.sharedCache.getPartitionFromCache("hive", (String)dbNames.get(0), tblName, Arrays.asList(string));
                Assert.assertNotNull((Object)ptn);
                Assert.assertEquals((Object)tblName, (Object)ptn.getTableName());
                Assert.assertEquals((Object)tblName, (Object)ptn.getTableName());
                Assert.assertEquals(Arrays.asList(string), (Object)ptn.getValues());
            }
        }
        for (final String tblName : dropPtnTblNames) {
            List ptns = this.sharedCache.listCachedPartitions("hive", (String)dbNames.get(0), tblName, 100);
            Assert.assertEquals((long)0L, (long)ptns.size());
        }
        this.sharedCache.getDatabaseCache().clear();
        this.sharedCache.getTableCache().clear();
        this.sharedCache.getSdCache().clear();
    }

    private Database createTestDb(String dbName, String dbOwner) {
        String dbDescription = dbName;
        String dbLocation = "file:/tmp";
        HashMap dbParams = new HashMap();
        Database db = new Database(dbName, dbDescription, dbLocation, dbParams);
        db.setOwnerName(dbOwner);
        db.setOwnerType(PrincipalType.USER);
        db.setCatalogName("hive");
        return db;
    }

    private Table createTestTbl(String dbName, String tblName, String tblOwner, List<FieldSchema> cols, List<FieldSchema> ptnCols) {
        String serdeLocation = "file:/tmp";
        HashMap serdeParams = new HashMap();
        HashMap tblParams = new HashMap();
        SerDeInfo serdeInfo = new SerDeInfo("serde", "seriallib", new HashMap());
        StorageDescriptor sd = new StorageDescriptor(cols, serdeLocation, "input", "output", false, 0, serdeInfo, null, null, serdeParams);
        sd.setStoredAsSubDirectories(false);
        Table tbl = new Table(tblName, dbName, tblOwner, 0, 0, 0, sd, ptnCols, tblParams, null, null, TableType.MANAGED_TABLE.toString());
        tbl.setCatName("hive");
        return tbl;
    }

    private void updateCache(CachedStore cachedStore) throws InterruptedException {
        int maxTries = 100000;
        long updateCountBefore = cachedStore.getCacheUpdateCount();
        CachedStore.startCacheUpdateService((Configuration)cachedStore.getConf(), (boolean)true, (boolean)false);
        while (cachedStore.getCacheUpdateCount() != updateCountBefore + 1L && maxTries-- > 0) {
            Thread.sleep(1000L);
        }
        CachedStore.stopCacheUpdateService((long)100L);
    }
}

