/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import java.util.Arrays;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.HiveAlterHandler;
import org.apache.hadoop.hive.metastore.RawStore;
import org.apache.hadoop.hive.metastore.annotation.MetastoreUnitTest;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.InvalidObjectException;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@Category(value={MetastoreUnitTest.class})
public class TestHiveAlterHandler {
    private Configuration conf = MetastoreConf.newMetastoreConf();

    @Test
    public void testAlterTableAddColNotUpdateStats() throws MetaException, InvalidObjectException, NoSuchObjectException {
        FieldSchema col1 = new FieldSchema("col1", "string", "col1 comment");
        FieldSchema col2 = new FieldSchema("col2", "string", "col2 comment");
        FieldSchema col3 = new FieldSchema("col3", "string", "col3 comment");
        FieldSchema col4 = new FieldSchema("col4", "string", "col4 comment");
        StorageDescriptor oldSd = new StorageDescriptor();
        oldSd.setCols(Arrays.asList(col1, col2, col3));
        Table oldTable = new Table();
        oldTable.setDbName("default");
        oldTable.setTableName("test_table");
        oldTable.setSd(oldSd);
        StorageDescriptor newSd = new StorageDescriptor(oldSd);
        newSd.setCols(Arrays.asList(col1, col2, col3, col4));
        Table newTable = new Table(oldTable);
        newTable.setSd(newSd);
        RawStore msdb = (RawStore)Mockito.mock(RawStore.class);
        ((RawStore)Mockito.doThrow((Throwable)new RuntimeException("shouldn't be called")).when((Object)msdb)).getTableColumnStatistics(MetaStoreUtils.getDefaultCatalog((Configuration)this.conf), oldTable.getDbName(), oldTable.getTableName(), Arrays.asList("col1", "col2", "col3"));
        HiveAlterHandler handler = new HiveAlterHandler();
        handler.setConf(this.conf);
        handler.alterTableUpdateTableColumnStats(msdb, oldTable, newTable);
    }

    @Test
    public void testAlterTableDelColUpdateStats() throws MetaException, InvalidObjectException, NoSuchObjectException {
        FieldSchema col1 = new FieldSchema("col1", "string", "col1 comment");
        FieldSchema col2 = new FieldSchema("col2", "string", "col2 comment");
        FieldSchema col3 = new FieldSchema("col3", "string", "col3 comment");
        FieldSchema col4 = new FieldSchema("col4", "string", "col4 comment");
        StorageDescriptor oldSd = new StorageDescriptor();
        oldSd.setCols(Arrays.asList(col1, col2, col3, col4));
        Table oldTable = new Table();
        oldTable.setDbName("default");
        oldTable.setTableName("test_table");
        oldTable.setSd(oldSd);
        StorageDescriptor newSd = new StorageDescriptor(oldSd);
        newSd.setCols(Arrays.asList(col1, col2, col3));
        Table newTable = new Table(oldTable);
        newTable.setSd(newSd);
        RawStore msdb = (RawStore)Mockito.mock(RawStore.class);
        HiveAlterHandler handler = new HiveAlterHandler();
        handler.setConf(this.conf);
        handler.alterTableUpdateTableColumnStats(msdb, oldTable, newTable);
        ((RawStore)Mockito.verify((Object)msdb, (VerificationMode)Mockito.times((int)1))).getTableColumnStatistics(MetaStoreUtils.getDefaultCatalog((Configuration)this.conf), oldTable.getDbName(), oldTable.getTableName(), Arrays.asList("col1", "col2", "col3", "col4"));
    }

    @Test
    public void testAlterTableChangePosNotUpdateStats() throws MetaException, InvalidObjectException, NoSuchObjectException {
        FieldSchema col1 = new FieldSchema("col1", "string", "col1 comment");
        FieldSchema col2 = new FieldSchema("col2", "string", "col2 comment");
        FieldSchema col3 = new FieldSchema("col3", "string", "col3 comment");
        FieldSchema col4 = new FieldSchema("col4", "string", "col4 comment");
        StorageDescriptor oldSd = new StorageDescriptor();
        oldSd.setCols(Arrays.asList(col1, col2, col3, col4));
        Table oldTable = new Table();
        oldTable.setDbName("default");
        oldTable.setTableName("test_table");
        oldTable.setSd(oldSd);
        StorageDescriptor newSd = new StorageDescriptor(oldSd);
        newSd.setCols(Arrays.asList(col1, col4, col2, col3));
        Table newTable = new Table(oldTable);
        newTable.setSd(newSd);
        RawStore msdb = (RawStore)Mockito.mock(RawStore.class);
        ((RawStore)Mockito.doThrow((Throwable)new RuntimeException("shouldn't be called")).when((Object)msdb)).getTableColumnStatistics(MetaStoreUtils.getDefaultCatalog((Configuration)this.conf), oldTable.getDbName(), oldTable.getTableName(), Arrays.asList("col1", "col2", "col3", "col4"));
        HiveAlterHandler handler = new HiveAlterHandler();
        handler.setConf(this.conf);
        handler.alterTableUpdateTableColumnStats(msdb, oldTable, newTable);
    }
}

