/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.converters;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Base64;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.store.types.converters.TypeConverter;

public class SerializableStringConverter
implements TypeConverter<Serializable, String> {
    private static final long serialVersionUID = 5269636067035783545L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toDatastoreType(Serializable memberValue) {
        String str = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = null;
        try {
            try {
                oos = new ObjectOutputStream(baos);
                oos.writeObject(memberValue);
                str = Base64.getEncoder().encodeToString(baos.toByteArray());
            }
            finally {
                try {
                    baos.close();
                }
                finally {
                    if (oos != null) {
                        oos.close();
                    }
                }
            }
        }
        catch (IOException ioe) {
            throw new NucleusException("Error serialising object of type " + memberValue.getClass().getName() + " to String", ioe);
        }
        return str;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Serializable toMemberType(String datastoreValue) {
        byte[] bytes = Base64.getDecoder().decode(datastoreValue);
        Serializable obj = null;
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        ObjectInputStream ois = null;
        try {
            try {
                ois = new ObjectInputStream(bais);
                obj = (Serializable)ois.readObject();
            }
            finally {
                try {
                    bais.close();
                }
                finally {
                    if (ois != null) {
                        ois.close();
                    }
                }
            }
        }
        catch (Exception e) {
            throw new NucleusException("Error deserialising " + datastoreValue, e);
        }
        return obj;
    }
}

