/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.converters;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import javax.imageio.ImageIO;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.store.types.converters.TypeConverter;

public class BufferedImageByteBufferConverter
implements TypeConverter<BufferedImage, ByteBuffer> {
    private static final long serialVersionUID = 585211414298721468L;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ByteBuffer toDatastoreType(BufferedImage memberValue) {
        if (memberValue == null) {
            return null;
        }
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream(8192);){
            ImageIO.write((RenderedImage)memberValue, "jpg", baos);
            ByteBuffer byteBuffer = ByteBuffer.wrap(baos.toByteArray());
            return byteBuffer;
        }
        catch (IOException ioe) {
            throw new NucleusDataStoreException("Error serialising object of type BufferedImage to ByteBuffer", ioe);
        }
    }

    @Override
    public BufferedImage toMemberType(ByteBuffer datastoreValue) {
        if (datastoreValue == null || datastoreValue.limit() == 0) {
            return null;
        }
        byte[] dataStoreValueInBytes = new byte[datastoreValue.remaining()];
        datastoreValue.get(dataStoreValueInBytes);
        try {
            return ImageIO.read(new ByteArrayInputStream(dataStoreValueInBytes));
        }
        catch (IOException ioe) {
            throw new NucleusDataStoreException("Error deserialising image datastoreValue", ioe);
        }
    }
}

