/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.enhancer;

import org.datanucleus.enhancer.ClassEnhancer;
import org.datanucleus.enhancer.ClassMethod;
import org.datanucleus.enhancer.DataNucleusEnhancer;
import org.datanucleus.enhancer.EnhanceUtils;
import org.datanucleus.enhancer.EnhancementNamer;
import org.datanucleus.enhancer.asm.AnnotationVisitor;
import org.datanucleus.enhancer.asm.Attribute;
import org.datanucleus.enhancer.asm.ClassVisitor;
import org.datanucleus.enhancer.asm.Handle;
import org.datanucleus.enhancer.asm.Label;
import org.datanucleus.enhancer.asm.MethodVisitor;
import org.datanucleus.enhancer.asm.TypePath;
import org.datanucleus.util.Localiser;

public class EnhancerCloneAdapter
extends MethodVisitor {
    protected ClassEnhancer enhancer;
    protected MethodVisitor visitor = null;

    public EnhancerCloneAdapter(MethodVisitor mv, ClassEnhancer enhancer, ClassVisitor cv) {
        super(458752, mv);
        this.enhancer = enhancer;
        int access = 1;
        this.visitor = cv.visitMethod(access, enhancer.getNamer().getCloneMethodName(), "()Ljava/lang/Object;", null, new String[]{CloneNotSupportedException.class.getName().replace('.', '/')});
    }

    @Override
    public void visitEnd() {
        this.visitor.visitEnd();
        if (DataNucleusEnhancer.LOGGER.isDebugEnabled()) {
            String msg = ClassMethod.getMethodAdditionMessage(this.enhancer.getNamer().getCloneMethodName(), "Object", null, null);
            DataNucleusEnhancer.LOGGER.debug(Localiser.msg("005019", msg));
        }
        EnhancerCloneAdapter.generateCloneMethod(this.mv, this.enhancer, this.enhancer.getNamer());
    }

    public static void generateCloneMethod(MethodVisitor mv, ClassEnhancer enhancer, EnhancementNamer namer) {
        mv.visitCode();
        Label startLabel = new Label();
        mv.visitLabel(startLabel);
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(182, enhancer.getASMClassName(), namer.getCloneMethodName(), "()" + EnhanceUtils.CD_Object, false);
        mv.visitTypeInsn(192, enhancer.getASMClassName());
        mv.visitVarInsn(58, 1);
        Label l1 = new Label();
        mv.visitLabel(l1);
        mv.visitVarInsn(25, 1);
        mv.visitInsn(3);
        mv.visitFieldInsn(181, enhancer.getASMClassName(), namer.getFlagsFieldName(), "B");
        mv.visitVarInsn(25, 1);
        mv.visitInsn(1);
        mv.visitFieldInsn(181, enhancer.getASMClassName(), namer.getStateManagerFieldName(), namer.getStateManagerDescriptor());
        mv.visitVarInsn(25, 1);
        mv.visitInsn(176);
        Label endLabel = new Label();
        mv.visitLabel(endLabel);
        mv.visitLocalVariable("this", enhancer.getClassDescriptor(), null, startLabel, endLabel, 0);
        mv.visitLocalVariable("copy", enhancer.getClassDescriptor(), null, l1, endLabel, 1);
        mv.visitMaxs(2, 2);
        mv.visitEnd();
    }

    @Override
    public AnnotationVisitor visitAnnotation(String arg0, boolean arg1) {
        return this.mv.visitAnnotation(arg0, arg1);
    }

    @Override
    public AnnotationVisitor visitAnnotationDefault() {
        return this.visitor.visitAnnotationDefault();
    }

    @Override
    public void visitParameter(String name, int access) {
        this.visitor.visitParameter(name, access);
    }

    @Override
    public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
        return this.visitor.visitTypeAnnotation(typeRef, typePath, desc, visible);
    }

    @Override
    public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
        this.visitor.visitMethodInsn(opcode, owner, name, desc, itf);
    }

    @Override
    public void visitInvokeDynamicInsn(String name, String desc, Handle bsm, Object ... bsmArgs) {
        this.visitor.visitInvokeDynamicInsn(name, desc, bsm, bsmArgs);
    }

    @Override
    public AnnotationVisitor visitInsnAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
        return this.visitor.visitInsnAnnotation(typeRef, typePath, desc, visible);
    }

    @Override
    public AnnotationVisitor visitTryCatchAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
        return this.visitor.visitTryCatchAnnotation(typeRef, typePath, desc, visible);
    }

    @Override
    public AnnotationVisitor visitLocalVariableAnnotation(int typeRef, TypePath typePath, Label[] start, Label[] end, int[] index, String desc, boolean visible) {
        return this.visitor.visitLocalVariableAnnotation(typeRef, typePath, start, end, index, desc, visible);
    }

    @Override
    public void visitAttribute(Attribute arg0) {
        this.visitor.visitAttribute(arg0);
    }

    @Override
    public void visitCode() {
        this.visitor.visitCode();
    }

    @Override
    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
        this.visitor.visitFieldInsn(opcode, owner, name, desc);
    }

    @Override
    public void visitFrame(int arg0, int arg1, Object[] arg2, int arg3, Object[] arg4) {
        this.visitor.visitFrame(arg0, arg1, arg2, arg3, arg4);
    }

    @Override
    public void visitIincInsn(int arg0, int arg1) {
        this.visitor.visitIincInsn(arg0, arg1);
    }

    @Override
    public void visitInsn(int opcode) {
        this.visitor.visitInsn(opcode);
    }

    @Override
    public void visitIntInsn(int arg0, int arg1) {
        this.visitor.visitIntInsn(arg0, arg1);
    }

    @Override
    public void visitJumpInsn(int arg0, Label arg1) {
        this.visitor.visitJumpInsn(arg0, arg1);
    }

    @Override
    public void visitLabel(Label arg0) {
        this.visitor.visitLabel(arg0);
    }

    @Override
    public void visitLdcInsn(Object arg0) {
        this.visitor.visitLdcInsn(arg0);
    }

    @Override
    public void visitLineNumber(int arg0, Label arg1) {
        this.visitor.visitLineNumber(arg0, arg1);
    }

    @Override
    public void visitLocalVariable(String arg0, String arg1, String arg2, Label arg3, Label arg4, int arg5) {
        this.visitor.visitLocalVariable(arg0, arg1, arg2, arg3, arg4, arg5);
    }

    @Override
    public void visitLookupSwitchInsn(Label arg0, int[] arg1, Label[] arg2) {
        this.visitor.visitLookupSwitchInsn(arg0, arg1, arg2);
    }

    @Override
    public void visitMaxs(int arg0, int arg1) {
        this.visitor.visitMaxs(arg0, arg1);
    }

    @Override
    @Deprecated
    public void visitMethodInsn(int opcode, String owner, String name, String desc) {
        this.visitor.visitMethodInsn(opcode, owner, name, desc);
    }

    @Override
    public void visitMultiANewArrayInsn(String arg0, int arg1) {
        this.visitor.visitMultiANewArrayInsn(arg0, arg1);
    }

    @Override
    public AnnotationVisitor visitParameterAnnotation(int arg0, String arg1, boolean arg2) {
        return this.visitor.visitParameterAnnotation(arg0, arg1, arg2);
    }

    @Override
    public void visitTableSwitchInsn(int arg0, int arg1, Label arg2, Label ... arg3) {
        this.visitor.visitTableSwitchInsn(arg0, arg1, arg2, arg3);
    }

    @Override
    public void visitTryCatchBlock(Label arg0, Label arg1, Label arg2, String arg3) {
        this.visitor.visitTryCatchBlock(arg0, arg1, arg2, arg3);
    }

    @Override
    public void visitTypeInsn(int arg0, String arg1) {
        this.visitor.visitTypeInsn(arg0, arg1);
    }

    @Override
    public void visitVarInsn(int arg0, int arg1) {
        this.visitor.visitVarInsn(arg0, arg1);
    }
}

