/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.sql.expression;

import java.util.List;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.query.expression.Expression;
import org.datanucleus.store.rdbms.mapping.column.ColumnMapping;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.sql.SQLStatement;
import org.datanucleus.store.rdbms.sql.expression.BooleanExpression;
import org.datanucleus.store.rdbms.sql.expression.BooleanLiteral;
import org.datanucleus.store.rdbms.sql.expression.ByteExpression;
import org.datanucleus.store.rdbms.sql.expression.CharacterExpression;
import org.datanucleus.store.rdbms.sql.expression.IntegerLiteral;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.sql.expression.SQLLiteral;

public class CharacterLiteral
extends CharacterExpression
implements SQLLiteral {
    private final String value;

    public CharacterLiteral(SQLStatement stmt, JavaTypeMapping mapping, Object value, String parameterName) {
        super(stmt, null, mapping);
        this.parameterName = parameterName;
        if (value == null) {
            this.value = null;
        } else if (value instanceof Character) {
            this.value = ((Character)value).toString();
        } else if (value instanceof String) {
            this.value = (String)value;
        } else {
            throw new NucleusException("Cannot create " + this.getClass().getName() + " for value of type " + value.getClass().getName());
        }
        if (parameterName != null) {
            this.st.appendParameter(parameterName, mapping, this.value);
        } else {
            this.setStatement();
        }
    }

    @Override
    public BooleanExpression eq(SQLExpression expr) {
        if (this.isParameter() || expr.isParameter()) {
            return new BooleanExpression(this, Expression.OP_EQ, expr);
        }
        if (expr instanceof ByteExpression) {
            return expr.eq(this);
        }
        if (expr instanceof CharacterLiteral) {
            return new BooleanLiteral(this.stmt, this.stmt.getSQLExpressionFactory().getMappingForType(Boolean.TYPE, false), this.value.equals(((CharacterLiteral)expr).value));
        }
        return super.eq(expr);
    }

    @Override
    public BooleanExpression ne(SQLExpression expr) {
        if (this.isParameter() || expr.isParameter()) {
            return new BooleanExpression(this, Expression.OP_NOTEQ, expr);
        }
        if (expr instanceof ByteExpression) {
            return expr.ne(this);
        }
        if (expr instanceof CharacterLiteral) {
            return new BooleanLiteral(this.stmt, this.stmt.getSQLExpressionFactory().getMappingForType(Boolean.TYPE, false), !this.value.equals(((CharacterLiteral)expr).value));
        }
        return super.ne(expr);
    }

    @Override
    public BooleanExpression lt(SQLExpression expr) {
        if (this.isParameter() || expr.isParameter()) {
            return new BooleanExpression(this, Expression.OP_LT, expr);
        }
        if (expr instanceof CharacterLiteral) {
            return new BooleanLiteral(this.stmt, this.stmt.getSQLExpressionFactory().getMappingForType(Boolean.TYPE, false), this.value.compareTo(((CharacterLiteral)expr).value) < 0);
        }
        return super.lt(expr);
    }

    @Override
    public BooleanExpression le(SQLExpression expr) {
        if (this.isParameter() || expr.isParameter()) {
            return new BooleanExpression(this, Expression.OP_LTEQ, expr);
        }
        if (expr instanceof CharacterLiteral) {
            return new BooleanLiteral(this.stmt, this.stmt.getSQLExpressionFactory().getMappingForType(Boolean.TYPE, false), this.value.compareTo(((CharacterLiteral)expr).value) <= 0);
        }
        return super.le(expr);
    }

    @Override
    public BooleanExpression gt(SQLExpression expr) {
        if (this.isParameter() || expr.isParameter()) {
            return new BooleanExpression(this, Expression.OP_GT, expr);
        }
        if (expr instanceof CharacterLiteral) {
            return new BooleanLiteral(this.stmt, this.stmt.getSQLExpressionFactory().getMappingForType(Boolean.TYPE, false), this.value.compareTo(((CharacterLiteral)expr).value) > 0);
        }
        return super.gt(expr);
    }

    @Override
    public BooleanExpression ge(SQLExpression expr) {
        if (this.isParameter() || expr.isParameter()) {
            return new BooleanExpression(this, Expression.OP_GTEQ, expr);
        }
        if (expr instanceof CharacterLiteral) {
            return new BooleanLiteral(this.stmt, this.stmt.getSQLExpressionFactory().getMappingForType(Boolean.TYPE, false), this.value.compareTo(((CharacterLiteral)expr).value) >= 0);
        }
        return super.ge(expr);
    }

    @Override
    public SQLExpression add(SQLExpression expr) {
        if (expr instanceof CharacterLiteral) {
            int v = this.value.charAt(0) + ((CharacterLiteral)expr).value.charAt(0);
            return new IntegerLiteral(this.stmt, this.mapping, v, null);
        }
        if (expr instanceof IntegerLiteral) {
            int v = this.value.charAt(0) + ((Number)((IntegerLiteral)expr).getValue()).intValue();
            return new IntegerLiteral(this.stmt, this.mapping, v, null);
        }
        return super.add(expr);
    }

    @Override
    public SQLExpression sub(SQLExpression expr) {
        if (expr instanceof CharacterLiteral) {
            int v = this.value.charAt(0) - ((CharacterLiteral)expr).value.charAt(0);
            return new IntegerLiteral(this.stmt, this.mapping, v, null);
        }
        if (expr instanceof IntegerLiteral) {
            int v = this.value.charAt(0) - ((Number)((IntegerLiteral)expr).getValue()).intValue();
            return new IntegerLiteral(this.stmt, this.mapping, v, null);
        }
        return super.sub(expr);
    }

    @Override
    public SQLExpression mod(SQLExpression expr) {
        if (expr instanceof CharacterLiteral) {
            int v = this.value.charAt(0) % ((CharacterLiteral)expr).value.charAt(0);
            return new IntegerLiteral(this.stmt, this.mapping, v, null);
        }
        if (expr instanceof IntegerLiteral) {
            int v = this.value.charAt(0) % ((Number)((IntegerLiteral)expr).getValue()).intValue();
            return new IntegerLiteral(this.stmt, this.mapping, v, null);
        }
        return super.mod(expr);
    }

    @Override
    public SQLExpression neg() {
        char v = -this.value.charAt(0);
        return new IntegerLiteral(this.stmt, this.mapping, v, null);
    }

    @Override
    public SQLExpression com() {
        int v = ~this.value.charAt(0);
        return new IntegerLiteral(this.stmt, this.mapping, v, null);
    }

    @Override
    public SQLExpression invoke(String methodName, List args) {
        if (methodName.equals("toUpperCase")) {
            return new CharacterLiteral(this.stmt, this.mapping, (Object)this.value.toUpperCase(), this.parameterName);
        }
        if (methodName.equals("toLowerCase")) {
            return new CharacterLiteral(this.stmt, this.mapping, (Object)this.value.toLowerCase(), this.parameterName);
        }
        return super.invoke(methodName, args);
    }

    @Override
    public Object getValue() {
        if (this.value == null) {
            return null;
        }
        return Character.valueOf(this.value.charAt(0));
    }

    @Override
    public void setJavaTypeMapping(JavaTypeMapping m) {
        super.setJavaTypeMapping(m);
        if (!this.isParameter()) {
            this.setStatement();
        }
    }

    @Override
    public void setNotParameter() {
        if (this.parameterName == null) {
            return;
        }
        this.parameterName = null;
        this.setStatement();
    }

    protected void setStatement() {
        this.st.clearStatement();
        ColumnMapping colMapping = this.mapping.getColumnMapping(0);
        if (colMapping.isIntegerBased()) {
            this.st.append("" + this.value.charAt(0));
        } else {
            this.st.append('\'').append(this.value).append('\'');
        }
    }
}

