/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.common.ndv.hll;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Random;
import org.apache.hadoop.hive.common.ndv.hll.HyperLogLog;
import org.apache.hadoop.hive.common.ndv.hll.HyperLogLogUtils;
import org.apache.hadoop.hive.metastore.annotation.MetastoreUnitTest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Category(value={MetastoreUnitTest.class})
public class TestHLLSerialization {
    private int size;
    private File testFile;
    private static final String pathPrefix = ".";
    private static final int SEED = 100;
    private float longRangeTolerance = 5.0f;
    private float shortRangeTolerance = 2.5f;
    @Rule
    public TestName testCaseName = new TestName();

    public TestHLLSerialization(int n) {
        this.size = n;
        this.testFile = new File(pathPrefix + this.testCaseName.getMethodName() + "_" + this.size + ".hll");
    }

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        Object[][] data = new Object[][]{{2}, {10}, {100}, {1000}, {2000}, {3000}, {5000}, {6000}, {10000}, {100000}, {1000000}};
        return Arrays.asList(data);
    }

    @After
    public void close() {
        if (this.testFile.exists()) {
            this.testFile.delete();
        }
    }

    @Test
    public void testHLLSparseSerialization() throws IOException {
        HyperLogLog hll = HyperLogLog.builder().setEncoding(HyperLogLog.EncodingType.SPARSE).build();
        Random rand = new Random(100L);
        for (int i = 0; i < this.size; ++i) {
            hll.addLong(rand.nextLong());
        }
        FileOutputStream fos = new FileOutputStream(this.testFile);
        DataOutputStream out = new DataOutputStream(fos);
        HyperLogLogUtils.serializeHLL((OutputStream)out, (HyperLogLog)hll);
        FileInputStream fis = new FileInputStream(this.testFile);
        DataInputStream in = new DataInputStream(fis);
        HyperLogLog deserializedHLL = HyperLogLogUtils.deserializeHLL((InputStream)in);
        Assert.assertEquals((Object)hll, (Object)deserializedHLL);
        Assert.assertEquals((Object)hll.toString(), (Object)deserializedHLL.toString());
        Assert.assertEquals((Object)hll.toStringExtended(), (Object)deserializedHLL.toStringExtended());
        Assert.assertEquals((long)hll.hashCode(), (long)deserializedHLL.hashCode());
        Assert.assertEquals((long)hll.count(), (long)deserializedHLL.count());
    }

    @Test
    public void testHLLSparseSerializationHalfDistinct() throws IOException {
        HyperLogLog hll = HyperLogLog.builder().setEncoding(HyperLogLog.EncodingType.SPARSE).build();
        Random rand = new Random(100L);
        HashSet<Integer> hashset = new HashSet<Integer>();
        for (int i = 0; i < this.size; ++i) {
            int val = rand.nextInt(this.size / 2);
            hll.addLong((long)val);
            hashset.add(val);
        }
        FileOutputStream fos = new FileOutputStream(this.testFile);
        DataOutputStream out = new DataOutputStream(fos);
        HyperLogLogUtils.serializeHLL((OutputStream)out, (HyperLogLog)hll);
        double threshold = this.size > 40000 ? (double)this.longRangeTolerance : (double)this.shortRangeTolerance;
        double delta = threshold * (double)hashset.size() / 100.0;
        FileInputStream fis = new FileInputStream(this.testFile);
        DataInputStream in = new DataInputStream(fis);
        HyperLogLog deserializedHLL = HyperLogLogUtils.deserializeHLL((InputStream)in);
        Assert.assertEquals((Object)hll, (Object)deserializedHLL);
        Assert.assertEquals((Object)hll.toString(), (Object)deserializedHLL.toString());
        Assert.assertEquals((Object)hll.toStringExtended(), (Object)deserializedHLL.toStringExtended());
        Assert.assertEquals((long)hll.hashCode(), (long)deserializedHLL.hashCode());
        Assert.assertEquals((long)hll.count(), (long)deserializedHLL.count());
        Assert.assertEquals((double)hashset.size(), (double)hll.count(), (double)delta);
        Assert.assertEquals((double)hashset.size(), (double)deserializedHLL.count(), (double)delta);
    }

    @Test
    public void testHLLSparseNoBitPacking() throws IOException {
        HyperLogLog hll = HyperLogLog.builder().setEncoding(HyperLogLog.EncodingType.SPARSE).enableBitPacking(false).build();
        Random rand = new Random(100L);
        for (int i = 0; i < this.size; ++i) {
            hll.addLong(rand.nextLong());
        }
        FileOutputStream fos = new FileOutputStream(this.testFile);
        DataOutputStream out = new DataOutputStream(fos);
        HyperLogLogUtils.serializeHLL((OutputStream)out, (HyperLogLog)hll);
        FileInputStream fis = new FileInputStream(this.testFile);
        DataInputStream in = new DataInputStream(fis);
        HyperLogLog deserializedHLL = HyperLogLogUtils.deserializeHLL((InputStream)in);
        Assert.assertEquals((Object)hll, (Object)deserializedHLL);
        Assert.assertEquals((Object)hll.toString(), (Object)deserializedHLL.toString());
        Assert.assertEquals((Object)hll.toStringExtended(), (Object)deserializedHLL.toStringExtended());
        Assert.assertEquals((long)hll.hashCode(), (long)deserializedHLL.hashCode());
        Assert.assertEquals((long)hll.count(), (long)deserializedHLL.count());
    }

    @Test
    public void testHLLSparseNoBitPackingHalfDistinct() throws IOException {
        HyperLogLog hll = HyperLogLog.builder().setEncoding(HyperLogLog.EncodingType.SPARSE).enableBitPacking(false).build();
        Random rand = new Random(100L);
        HashSet<Integer> hashset = new HashSet<Integer>();
        for (int i = 0; i < this.size; ++i) {
            int val = rand.nextInt(this.size / 2);
            hll.addLong((long)val);
            hashset.add(val);
        }
        FileOutputStream fos = new FileOutputStream(this.testFile);
        DataOutputStream out = new DataOutputStream(fos);
        HyperLogLogUtils.serializeHLL((OutputStream)out, (HyperLogLog)hll);
        double threshold = this.size > 40000 ? (double)this.longRangeTolerance : (double)this.shortRangeTolerance;
        double delta = threshold * (double)hashset.size() / 100.0;
        FileInputStream fis = new FileInputStream(this.testFile);
        DataInputStream in = new DataInputStream(fis);
        HyperLogLog deserializedHLL = HyperLogLogUtils.deserializeHLL((InputStream)in);
        Assert.assertEquals((Object)hll, (Object)deserializedHLL);
        Assert.assertEquals((Object)hll.toString(), (Object)deserializedHLL.toString());
        Assert.assertEquals((Object)hll.toStringExtended(), (Object)deserializedHLL.toStringExtended());
        Assert.assertEquals((long)hll.hashCode(), (long)deserializedHLL.hashCode());
        Assert.assertEquals((long)hll.count(), (long)deserializedHLL.count());
        Assert.assertEquals((double)hashset.size(), (double)hll.count(), (double)delta);
        Assert.assertEquals((double)hashset.size(), (double)deserializedHLL.count(), (double)delta);
    }

    @Test
    public void testHLLDenseSerialization() throws IOException {
        HyperLogLog hll = HyperLogLog.builder().setEncoding(HyperLogLog.EncodingType.DENSE).build();
        Random rand = new Random(100L);
        for (int i = 0; i < this.size; ++i) {
            hll.addLong(rand.nextLong());
        }
        FileOutputStream fos = new FileOutputStream(this.testFile);
        DataOutputStream out = new DataOutputStream(fos);
        HyperLogLogUtils.serializeHLL((OutputStream)out, (HyperLogLog)hll);
        FileInputStream fis = new FileInputStream(this.testFile);
        DataInputStream in = new DataInputStream(fis);
        HyperLogLog deserializedHLL = HyperLogLogUtils.deserializeHLL((InputStream)in);
        Assert.assertEquals((Object)hll, (Object)deserializedHLL);
        Assert.assertEquals((Object)hll.toString(), (Object)deserializedHLL.toString());
        Assert.assertEquals((Object)hll.toStringExtended(), (Object)deserializedHLL.toStringExtended());
        Assert.assertEquals((long)hll.hashCode(), (long)deserializedHLL.hashCode());
        Assert.assertEquals((long)hll.count(), (long)deserializedHLL.count());
    }

    @Test
    public void testHLLDenseSerializationHalfDistinct() throws IOException {
        HyperLogLog hll = HyperLogLog.builder().setEncoding(HyperLogLog.EncodingType.DENSE).build();
        Random rand = new Random(100L);
        HashSet<Integer> hashset = new HashSet<Integer>();
        for (int i = 0; i < this.size; ++i) {
            int val = rand.nextInt(this.size / 2);
            hll.addLong((long)val);
            hashset.add(val);
        }
        FileOutputStream fos = new FileOutputStream(this.testFile);
        DataOutputStream out = new DataOutputStream(fos);
        HyperLogLogUtils.serializeHLL((OutputStream)out, (HyperLogLog)hll);
        double threshold = this.size > 40000 ? (double)this.longRangeTolerance : (double)this.shortRangeTolerance;
        double delta = threshold * (double)hashset.size() / 100.0;
        FileInputStream fis = new FileInputStream(this.testFile);
        DataInputStream in = new DataInputStream(fis);
        HyperLogLog deserializedHLL = HyperLogLogUtils.deserializeHLL((InputStream)in);
        Assert.assertEquals((Object)hll, (Object)deserializedHLL);
        Assert.assertEquals((Object)hll.toString(), (Object)deserializedHLL.toString());
        Assert.assertEquals((Object)hll.toStringExtended(), (Object)deserializedHLL.toStringExtended());
        Assert.assertEquals((long)hll.hashCode(), (long)deserializedHLL.hashCode());
        Assert.assertEquals((long)hll.count(), (long)deserializedHLL.count());
        Assert.assertEquals((double)hashset.size(), (double)hll.count(), (double)delta);
        Assert.assertEquals((double)hashset.size(), (double)deserializedHLL.count(), (double)delta);
    }

    @Test
    public void testHLLDenseNoBitPacking() throws IOException {
        HyperLogLog hll = HyperLogLog.builder().setEncoding(HyperLogLog.EncodingType.DENSE).enableBitPacking(false).build();
        Random rand = new Random(100L);
        for (int i = 0; i < this.size; ++i) {
            hll.addLong(rand.nextLong());
        }
        FileOutputStream fos = new FileOutputStream(this.testFile);
        DataOutputStream out = new DataOutputStream(fos);
        HyperLogLogUtils.serializeHLL((OutputStream)out, (HyperLogLog)hll);
        FileInputStream fis = new FileInputStream(this.testFile);
        DataInputStream in = new DataInputStream(fis);
        HyperLogLog deserializedHLL = HyperLogLogUtils.deserializeHLL((InputStream)in);
        Assert.assertEquals((Object)hll, (Object)deserializedHLL);
        Assert.assertEquals((Object)hll.toString(), (Object)deserializedHLL.toString());
        Assert.assertEquals((Object)hll.toStringExtended(), (Object)deserializedHLL.toStringExtended());
        Assert.assertEquals((long)hll.hashCode(), (long)deserializedHLL.hashCode());
        Assert.assertEquals((long)hll.count(), (long)deserializedHLL.count());
    }

    @Test
    public void testHLLDenseNoBitPackingHalfDistinct() throws IOException {
        HyperLogLog hll = HyperLogLog.builder().setEncoding(HyperLogLog.EncodingType.DENSE).enableBitPacking(false).build();
        Random rand = new Random(100L);
        HashSet<Integer> hashset = new HashSet<Integer>();
        for (int i = 0; i < this.size; ++i) {
            int val = rand.nextInt(this.size / 2);
            hll.addLong((long)val);
            hashset.add(val);
        }
        FileOutputStream fos = new FileOutputStream(this.testFile);
        DataOutputStream out = new DataOutputStream(fos);
        HyperLogLogUtils.serializeHLL((OutputStream)out, (HyperLogLog)hll);
        double threshold = this.size > 40000 ? (double)this.longRangeTolerance : (double)this.shortRangeTolerance;
        double delta = threshold * (double)hashset.size() / 100.0;
        FileInputStream fis = new FileInputStream(this.testFile);
        DataInputStream in = new DataInputStream(fis);
        HyperLogLog deserializedHLL = HyperLogLogUtils.deserializeHLL((InputStream)in);
        Assert.assertEquals((Object)hll, (Object)deserializedHLL);
        Assert.assertEquals((Object)hll.toString(), (Object)deserializedHLL.toString());
        Assert.assertEquals((Object)hll.toStringExtended(), (Object)deserializedHLL.toStringExtended());
        Assert.assertEquals((long)hll.hashCode(), (long)deserializedHLL.hashCode());
        Assert.assertEquals((long)hll.count(), (long)deserializedHLL.count());
        Assert.assertEquals((double)hashset.size(), (double)hll.count(), (double)delta);
        Assert.assertEquals((double)hashset.size(), (double)deserializedHLL.count(), (double)delta);
    }
}

