/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.datasource;

import com.jolbox.bonecp.BoneCPDataSource;
import com.zaxxer.hikari.HikariDataSource;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.annotation.MetastoreUnitTest;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.datasource.DataSourceProvider;
import org.apache.hadoop.hive.metastore.datasource.DataSourceProviderFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MetastoreUnitTest.class})
public class TestDataSourceProviderFactory {
    private Configuration conf;

    @Before
    public void init() {
        this.conf = MetastoreConf.newMetastoreConf();
        MetastoreConf.setVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.CONNECTION_USER_NAME, (String)"dummyUser");
        MetastoreConf.setVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.PWD, (String)"dummyPass");
    }

    @Test
    public void testNoDataSourceCreatedWithoutProps() throws SQLException {
        DataSourceProvider dsp = DataSourceProviderFactory.getDataSourceProvider((Configuration)this.conf);
        Assert.assertNull((Object)dsp);
        MetastoreConf.setVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.CONNECTION_POOLING_TYPE, (String)"bonecp");
        dsp = DataSourceProviderFactory.getDataSourceProvider((Configuration)this.conf);
        Assert.assertNull((Object)dsp);
    }

    @Test
    public void testCreateBoneCpDataSource() throws SQLException {
        MetastoreConf.setVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.CONNECTION_POOLING_TYPE, (String)"bonecp");
        this.conf.set("bonecp.firstProp", "value");
        this.conf.set("bonecp.secondProp", "value");
        DataSourceProvider dsp = DataSourceProviderFactory.getDataSourceProvider((Configuration)this.conf);
        Assert.assertNotNull((Object)dsp);
        DataSource ds = dsp.create(this.conf);
        Assert.assertTrue((boolean)(ds instanceof BoneCPDataSource));
    }

    @Test
    public void testSetBoneCpStringProperty() throws SQLException {
        MetastoreConf.setVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.CONNECTION_POOLING_TYPE, (String)"bonecp");
        this.conf.set("bonecp.initSQL", "select 1 from dual");
        DataSourceProvider dsp = DataSourceProviderFactory.getDataSourceProvider((Configuration)this.conf);
        Assert.assertNotNull((Object)dsp);
        DataSource ds = dsp.create(this.conf);
        Assert.assertTrue((boolean)(ds instanceof BoneCPDataSource));
        Assert.assertEquals((Object)"select 1 from dual", (Object)((BoneCPDataSource)ds).getInitSQL());
    }

    @Test
    public void testSetBoneCpNumberProperty() throws SQLException {
        MetastoreConf.setVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.CONNECTION_POOLING_TYPE, (String)"bonecp");
        this.conf.set("bonecp.acquireRetryDelayInMs", "599");
        DataSourceProvider dsp = DataSourceProviderFactory.getDataSourceProvider((Configuration)this.conf);
        Assert.assertNotNull((Object)dsp);
        DataSource ds = dsp.create(this.conf);
        Assert.assertTrue((boolean)(ds instanceof BoneCPDataSource));
        Assert.assertEquals((long)599L, (long)((BoneCPDataSource)ds).getAcquireRetryDelayInMs());
    }

    @Test
    public void testSetBoneCpBooleanProperty() throws SQLException {
        MetastoreConf.setVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.CONNECTION_POOLING_TYPE, (String)"bonecp");
        this.conf.set("bonecp.disableJMX", "true");
        DataSourceProvider dsp = DataSourceProviderFactory.getDataSourceProvider((Configuration)this.conf);
        Assert.assertNotNull((Object)dsp);
        DataSource ds = dsp.create(this.conf);
        Assert.assertTrue((boolean)(ds instanceof BoneCPDataSource));
        Assert.assertEquals((Object)true, (Object)((BoneCPDataSource)ds).isDisableJMX());
    }

    @Test
    public void testCreateHikariCpDataSource() throws SQLException {
        MetastoreConf.setVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.CONNECTION_POOLING_TYPE, (String)"hikari");
        this.conf.set("hikari.initializationFailTimeout", "-1");
        DataSourceProvider dsp = DataSourceProviderFactory.getDataSourceProvider((Configuration)this.conf);
        Assert.assertNotNull((Object)dsp);
        DataSource ds = dsp.create(this.conf);
        Assert.assertTrue((boolean)(ds instanceof HikariDataSource));
    }

    @Test
    public void testSetHikariCpStringProperty() throws SQLException {
        MetastoreConf.setVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.CONNECTION_POOLING_TYPE, (String)"hikari");
        this.conf.set("hikari.connectionInitSql", "select 1 from dual");
        this.conf.set("hikari.initializationFailTimeout", "-1");
        DataSourceProvider dsp = DataSourceProviderFactory.getDataSourceProvider((Configuration)this.conf);
        Assert.assertNotNull((Object)dsp);
        DataSource ds = dsp.create(this.conf);
        Assert.assertTrue((boolean)(ds instanceof HikariDataSource));
        Assert.assertEquals((Object)"select 1 from dual", (Object)((HikariDataSource)ds).getConnectionInitSql());
    }

    @Test
    public void testSetHikariCpNumberProperty() throws SQLException {
        MetastoreConf.setVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.CONNECTION_POOLING_TYPE, (String)"hikari");
        this.conf.set("hikari.idleTimeout", "59999");
        this.conf.set("hikari.initializationFailTimeout", "-1");
        DataSourceProvider dsp = DataSourceProviderFactory.getDataSourceProvider((Configuration)this.conf);
        Assert.assertNotNull((Object)dsp);
        DataSource ds = dsp.create(this.conf);
        Assert.assertTrue((boolean)(ds instanceof HikariDataSource));
        Assert.assertEquals((long)59999L, (long)((HikariDataSource)ds).getIdleTimeout());
    }

    @Test
    public void testSetHikariCpBooleanProperty() throws SQLException {
        MetastoreConf.setVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.CONNECTION_POOLING_TYPE, (String)"hikari");
        this.conf.set("hikari.allowPoolSuspension", "false");
        this.conf.set("hikari.initializationFailTimeout", "-1");
        DataSourceProvider dsp = DataSourceProviderFactory.getDataSourceProvider((Configuration)this.conf);
        Assert.assertNotNull((Object)dsp);
        DataSource ds = dsp.create(this.conf);
        Assert.assertTrue((boolean)(ds instanceof HikariDataSource));
        Assert.assertEquals((Object)false, (Object)((HikariDataSource)ds).isAllowPoolSuspension());
    }
}

