/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.MetaStoreFilterHook;
import org.apache.hadoop.hive.metastore.MetaStoreTestUtils;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.annotation.MetastoreUnitTest;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.PartitionSpec;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.api.TableMeta;
import org.apache.hadoop.hive.metastore.client.builder.DatabaseBuilder;
import org.apache.hadoop.hive.metastore.client.builder.PartitionBuilder;
import org.apache.hadoop.hive.metastore.client.builder.TableBuilder;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.util.StringUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MetastoreUnitTest.class})
public class TestFilterHooks {
    private static final Logger LOG = LoggerFactory.getLogger(TestFilterHooks.class);
    protected static HiveMetaStoreClient client;
    protected static Configuration conf;
    protected static Warehouse warehouse;
    private static final int DEFAULT_LIMIT_PARTITION_REQUEST = 100;
    private static String DBNAME1;
    private static String DBNAME2;
    private static final String TAB1 = "tab1";
    private static final String TAB2 = "tab2";

    protected HiveMetaStoreClient createClient(Configuration metaStoreConf) throws Exception {
        try {
            return new HiveMetaStoreClient(metaStoreConf);
        }
        catch (Throwable e) {
            System.err.println("Unable to open the metastore");
            System.err.println(StringUtils.stringifyException((Throwable)e));
            throw new Exception(e);
        }
    }

    @BeforeClass
    public static void setUp() throws Exception {
        DummyMetaStoreFilterHookImpl.blockResults = true;
    }

    @Before
    public void setUpForTest() throws Exception {
        conf = MetastoreConf.newMetastoreConf();
        conf.set("fs.defaultFS", "file:///");
        MetastoreConf.setLongVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.THRIFT_CONNECTION_RETRIES, (long)3L);
        MetastoreConf.setBoolVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.HIVE_SUPPORT_CONCURRENCY, (boolean)false);
        MetastoreConf.setClass((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.FILTER_HOOK, DummyMetaStoreFilterHookImpl.class, MetaStoreFilterHook.class);
        MetastoreConf.setBoolVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.METRICS_ENABLED, (boolean)true);
        conf.set("hive.key1", "value1");
        conf.set("hive.key2", "http://www.example.com");
        conf.set("hive.key3", "");
        conf.set("hive.key4", "0");
        conf.set("datanucleus.autoCreateTables", "false");
        conf.set("hive.in.test", "true");
        MetastoreConf.setLongVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.BATCH_RETRIEVE_MAX, (long)2L);
        MetastoreConf.setLongVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.LIMIT_PARTITION_REQUEST, (long)100L);
        MetastoreConf.setVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.STORAGE_SCHEMA_READER_IMPL, (String)"no.such.class");
        MetaStoreTestUtils.setConfForStandloneMode(conf);
        warehouse = new Warehouse(conf);
    }

    protected void creatEnv(Configuration conf) throws Exception {
        client = this.createClient(conf);
        client.dropDatabase(DBNAME1, true, true, true);
        client.dropDatabase(DBNAME2, true, true, true);
        Database db1 = new DatabaseBuilder().setName(DBNAME1).setCatalogName("hive").create((IMetaStoreClient)client, conf);
        Database db2 = new DatabaseBuilder().setName(DBNAME2).setCatalogName("hive").create((IMetaStoreClient)client, conf);
        ((TableBuilder)((TableBuilder)new TableBuilder().setDbName(DBNAME1).setTableName(TAB1).addCol("id", "int")).addCol("name", "string")).create((IMetaStoreClient)client, conf);
        Table tab2 = ((TableBuilder)new TableBuilder().setDbName(DBNAME1).setTableName(TAB2).addCol("id", "int")).addPartCol("name", "string").create((IMetaStoreClient)client, conf);
        new PartitionBuilder().inTable(tab2).addValue("value1").addToTable((IMetaStoreClient)client, conf);
        new PartitionBuilder().inTable(tab2).addValue("value2").addToTable((IMetaStoreClient)client, conf);
    }

    @Test
    public void testHMSServerWithoutFilter() throws Exception {
        MetastoreConf.setBoolVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.METASTORE_CLIENT_FILTER_ENABLED, (boolean)false);
        DBNAME1 = "db_testHMSServerWithoutFilter_1";
        DBNAME2 = "db_testHMSServerWithoutFilter_2";
        this.creatEnv(conf);
        Assert.assertNotNull((Object)client.getTable(DBNAME1, TAB1));
        Assert.assertEquals((long)2L, (long)client.getTables(DBNAME1, "*").size());
        Assert.assertEquals((long)2L, (long)client.getAllTables(DBNAME1).size());
        Assert.assertEquals((long)1L, (long)client.getTables(DBNAME1, TAB2).size());
        Assert.assertEquals((long)0L, (long)client.getAllTables(DBNAME2).size());
        Assert.assertNotNull((Object)client.getDatabase(DBNAME1));
        Assert.assertEquals((long)2L, (long)client.getDatabases("*testHMSServerWithoutFilter*").size());
        Assert.assertEquals((long)1L, (long)client.getDatabases(DBNAME1).size());
        Assert.assertNotNull((Object)client.getPartition(DBNAME1, TAB2, "name=value1"));
        Assert.assertEquals((long)1L, (long)client.getPartitionsByNames(DBNAME1, TAB2, (List)Lists.newArrayList((Object[])new String[]{"name=value1"})).size());
    }

    @Test
    public void testHMSServerWithFilter() throws Exception {
        MetastoreConf.setBoolVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.METASTORE_CLIENT_FILTER_ENABLED, (boolean)false);
        MetastoreConf.setBoolVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.METASTORE_SERVER_FILTER_ENABLED, (boolean)true);
        DBNAME1 = "db_testHMSServerWithFilter_1";
        DBNAME2 = "db_testHMSServerWithFilter_2";
        this.creatEnv(conf);
        this.testFilterForDb(true);
        this.testFilterForTables(true);
        this.testFilterForPartition(true);
    }

    @Test
    public void testHMSClientWithoutFilter() throws Exception {
        MetastoreConf.setBoolVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.METASTORE_CLIENT_FILTER_ENABLED, (boolean)false);
        DBNAME1 = "db_testHMSClientWithoutFilter_1";
        DBNAME2 = "db_testHMSClientWithoutFilter_2";
        this.creatEnv(conf);
        Assert.assertNotNull((Object)client.getTable(DBNAME1, TAB1));
        Assert.assertEquals((long)2L, (long)client.getTables(DBNAME1, "*").size());
        Assert.assertEquals((long)2L, (long)client.getAllTables(DBNAME1).size());
        Assert.assertEquals((long)1L, (long)client.getTables(DBNAME1, TAB2).size());
        Assert.assertEquals((long)0L, (long)client.getAllTables(DBNAME2).size());
        Assert.assertNotNull((Object)client.getDatabase(DBNAME1));
        Assert.assertEquals((long)2L, (long)client.getDatabases("*testHMSClientWithoutFilter*").size());
        Assert.assertEquals((long)1L, (long)client.getDatabases(DBNAME1).size());
        Assert.assertNotNull((Object)client.getPartition(DBNAME1, TAB2, "name=value1"));
        Assert.assertEquals((long)1L, (long)client.getPartitionsByNames(DBNAME1, TAB2, (List)Lists.newArrayList((Object[])new String[]{"name=value1"})).size());
    }

    @Test
    public void testHMSClientWithFilter() throws Exception {
        MetastoreConf.setBoolVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.METASTORE_SERVER_FILTER_ENABLED, (boolean)false);
        DBNAME1 = "db_testHMSClientWithFilter_1";
        DBNAME2 = "db_testHMSClientWithFilter_2";
        this.creatEnv(conf);
        this.testFilterForDb(false);
        this.testFilterForTables(false);
        this.testFilterForPartition(false);
    }

    protected void testFilterForDb(boolean filterAtServer) throws Exception {
        if (!filterAtServer) {
            try {
                Assert.assertNotNull((Object)client.getDatabase(DBNAME1));
                Assert.fail((String)"getDatabase() should fail with blocking mode");
            }
            catch (NoSuchObjectException noSuchObjectException) {
                // empty catch block
            }
        }
        Assert.assertEquals((long)0L, (long)client.getDatabases("*").size());
        Assert.assertEquals((long)0L, (long)client.getAllDatabases().size());
        Assert.assertEquals((long)0L, (long)client.getDatabases(DBNAME1).size());
    }

    protected void testFilterForTables(boolean filterAtServer) throws Exception {
        if (!filterAtServer) {
            try {
                client.getTable(DBNAME1, TAB1);
                Assert.fail((String)"getTable() should fail with blocking mode");
            }
            catch (NoSuchObjectException noSuchObjectException) {
                // empty catch block
            }
        }
        Assert.assertEquals((long)0L, (long)client.getTables(DBNAME1, "*").size());
        Assert.assertEquals((long)0L, (long)client.getAllTables(DBNAME1).size());
        Assert.assertEquals((long)0L, (long)client.getTables(DBNAME1, TAB2).size());
    }

    protected void testFilterForPartition(boolean filterAtServer) throws Exception {
        try {
            Assert.assertNotNull((Object)client.getPartition(DBNAME1, TAB2, "name=value1"));
            Assert.fail((String)"getPartition() should fail with blocking mode");
        }
        catch (NoSuchObjectException noSuchObjectException) {
            // empty catch block
        }
        if (filterAtServer) {
            try {
                client.getPartitionsByNames(DBNAME1, TAB2, (List)Lists.newArrayList((Object[])new String[]{"name=value1"})).size();
                Assert.fail((String)"getPartitionsByNames() should fail with blocking mode at server side");
            }
            catch (NoSuchObjectException noSuchObjectException) {}
        } else {
            Assert.assertEquals((long)0L, (long)client.getPartitionsByNames(DBNAME1, TAB2, (List)Lists.newArrayList((Object[])new String[]{"name=value1"})).size());
        }
    }

    static {
        DBNAME1 = "testdb1";
        DBNAME2 = "testdb2";
    }

    public static class DummyMetaStoreFilterHookImpl
    implements MetaStoreFilterHook {
        private static boolean blockResults = false;

        public DummyMetaStoreFilterHookImpl(Configuration conf) {
        }

        public List<String> filterDatabases(List<String> dbList) throws MetaException {
            if (blockResults) {
                return new ArrayList<String>();
            }
            return dbList;
        }

        public Database filterDatabase(Database dataBase) throws NoSuchObjectException {
            if (blockResults) {
                throw new NoSuchObjectException("Blocked access");
            }
            return dataBase;
        }

        public List<String> filterTableNames(String catName, String dbName, List<String> tableList) throws MetaException {
            if (blockResults) {
                return new ArrayList<String>();
            }
            return tableList;
        }

        public Table filterTable(Table table) throws NoSuchObjectException {
            if (blockResults) {
                throw new NoSuchObjectException("Blocked access");
            }
            return table;
        }

        public List<Table> filterTables(List<Table> tableList) throws MetaException {
            if (blockResults) {
                return new ArrayList<Table>();
            }
            return tableList;
        }

        public List<TableMeta> filterTableMetas(List<TableMeta> tableMetas) throws MetaException {
            return tableMetas;
        }

        public List<Partition> filterPartitions(List<Partition> partitionList) throws MetaException {
            if (blockResults) {
                return new ArrayList<Partition>();
            }
            return partitionList;
        }

        public List<PartitionSpec> filterPartitionSpecs(List<PartitionSpec> partitionSpecList) throws MetaException {
            if (blockResults) {
                return new ArrayList<PartitionSpec>();
            }
            return partitionSpecList;
        }

        public Partition filterPartition(Partition partition) throws NoSuchObjectException {
            if (blockResults) {
                throw new NoSuchObjectException("Blocked access");
            }
            return partition;
        }

        public List<String> filterPartitionNames(String catName, String dbName, String tblName, List<String> partitionNames) throws MetaException {
            if (blockResults) {
                return new ArrayList<String>();
            }
            return partitionNames;
        }
    }
}

