/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.query.inmemory.method;

import java.math.BigDecimal;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.query.QueryUtils;
import org.datanucleus.query.expression.DyadicExpression;
import org.datanucleus.query.expression.Expression;
import org.datanucleus.query.expression.InvokeExpression;
import org.datanucleus.query.expression.Literal;
import org.datanucleus.query.expression.ParameterExpression;
import org.datanucleus.query.expression.PrimaryExpression;
import org.datanucleus.query.inmemory.InMemoryExpressionEvaluator;
import org.datanucleus.query.inmemory.InvocationEvaluator;

public abstract class MathFunction
implements InvocationEvaluator {
    @Override
    public Object evaluate(InvokeExpression expr, Object invokedValue, InMemoryExpressionEvaluator eval) {
        String method = expr.getOperation();
        Expression param = expr.getArguments().get(0);
        Object paramValue = null;
        if (param instanceof PrimaryExpression) {
            PrimaryExpression primExpr = (PrimaryExpression)param;
            paramValue = eval.getValueForPrimaryExpression(primExpr);
        } else if (param instanceof ParameterExpression) {
            ParameterExpression paramExpr = (ParameterExpression)param;
            paramValue = QueryUtils.getValueForParameterExpression(eval.getParameterValues(), paramExpr);
        } else if (param instanceof InvokeExpression) {
            InvokeExpression invokeExpr = (InvokeExpression)param;
            paramValue = eval.getValueForInvokeExpression(invokeExpr);
        } else if (param instanceof Literal) {
            paramValue = ((Literal)param).getLiteral();
        } else if (param instanceof DyadicExpression) {
            DyadicExpression dyExpr = (DyadicExpression)param;
            paramValue = dyExpr.evaluate(eval);
        } else {
            throw new NucleusException(method + "(num) where num is instanceof " + param.getClass().getName() + " not supported");
        }
        Number result = null;
        if (paramValue instanceof Double) {
            result = new Double(this.evaluateMathFunction((Double)paramValue));
        } else if (paramValue instanceof Float) {
            result = new Float(this.evaluateMathFunction(((Float)paramValue).floatValue()));
        } else if (paramValue instanceof BigDecimal) {
            result = new BigDecimal(this.evaluateMathFunction(((BigDecimal)paramValue).doubleValue()));
        } else if (paramValue instanceof Integer) {
            result = new Double(this.evaluateMathFunction(((Integer)paramValue).doubleValue()));
        } else if (paramValue instanceof Long) {
            result = new Double(this.evaluateMathFunction(((Long)paramValue).doubleValue()));
        } else {
            throw new NucleusException("Not possible to use " + this.getFunctionName() + " on value of type " + paramValue.getClass().getName());
        }
        return result;
    }

    protected abstract String getFunctionName();

    protected abstract double evaluateMathFunction(double var1);
}

