/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.MetaStoreTestUtils;
import org.apache.hadoop.hive.metastore.MockPartitionExpressionForMetastore;
import org.apache.hadoop.hive.metastore.PartitionExpressionProxy;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.annotation.MetastoreUnitTest;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.util.StringUtils;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MetastoreUnitTest.class})
public class TestMetaCreateObjects {
    private static final Logger LOG = LoggerFactory.getLogger(TestMetaCreateObjects.class);
    protected static HiveMetaStoreClient client;
    protected static Configuration conf;
    protected static Warehouse warehouse;

    @BeforeClass
    public static void setUp() throws Exception {
        conf = MetastoreConf.newMetastoreConf();
        conf.set("fs.defaultFS", "file:///");
        MetastoreConf.setBoolVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.METASTORE_ALLOW_NEW_DB_IN_EXISTING_DIRECTORY, (boolean)false);
        MetastoreConf.setVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.CONNECT_URL_KEY, (String)"jdbc:derby:memory:${test.tmp.dir}/junit_metastore_db_test_meta_create_objects;create=true");
        MetastoreConf.setClass((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.EXPRESSION_PROXY_CLASS, MockPartitionExpressionForMetastore.class, PartitionExpressionProxy.class);
        MetaStoreTestUtils.setConfForStandloneMode(conf);
        warehouse = new Warehouse(conf);
        client = new HiveMetaStoreClient(conf);
    }

    @AfterClass
    public static void tearDown() {
        try {
            client.close();
        }
        catch (Throwable e) {
            LOG.info("Unable to close metastore");
            LOG.info(StringUtils.stringifyException((Throwable)e));
            throw e;
        }
    }

    @Test
    public void testDataBaseLocationAlreadyExistsNegative() throws Exception {
        String dbName = "db";
        LocalFileSystem fs = new LocalFileSystem();
        fs.initialize(fs.getWorkingDirectory().toUri(), conf);
        String dbLocation = "/tmp/" + dbName;
        Path dbLocationPath = new Path(dbLocation);
        fs.mkdirs(dbLocationPath);
        Database db = new Database();
        db.setName(dbName);
        db.setLocationUri(dbLocation);
        try {
            client.createDatabase(db);
            Assert.fail((String)"should throw exception.");
        }
        catch (Exception e) {
            Assert.assertTrue((String)"unexpected MetaException", (boolean)e.getMessage().contains("Failed to create database. Database directory already exists"));
        }
    }

    @Test
    public void testDataBaseLocationAlreadyExistsPositive() throws Exception {
        String dbName = "db";
        LocalFileSystem fs = new LocalFileSystem();
        fs.initialize(fs.getWorkingDirectory().toUri(), conf);
        String dbLocation = "/tmp/" + dbName;
        Path dbLocationPath = new Path(dbLocation);
        if (fs.exists(dbLocationPath)) {
            fs.delete(dbLocationPath, true);
        }
        Database db = new Database();
        db.setName(dbName);
        db.setLocationUri(dbLocation);
        try {
            client.createDatabase(db);
        }
        catch (MetaException e) {
            Assert.fail((String)("should not throw exception: " + e.getMessage()));
        }
        client.dropDatabase(dbName, true, true);
    }
}

