/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.DummyListener;
import org.apache.hadoop.hive.metastore.DummyRawStoreControlledCommit;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.MetaStoreTestUtils;
import org.apache.hadoop.hive.metastore.annotation.MetastoreUnitTest;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.client.builder.DatabaseBuilder;
import org.apache.hadoop.hive.metastore.client.builder.PartitionBuilder;
import org.apache.hadoop.hive.metastore.client.builder.TableBuilder;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.events.ListenerEvent;
import org.apache.hadoop.hive.metastore.security.HadoopThriftAuthBridge;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MetastoreUnitTest.class})
public class TestMetaStoreEventListenerOnlyOnCommit {
    private Configuration conf;
    private HiveMetaStoreClient msc;

    @Before
    public void setUp() throws Exception {
        DummyRawStoreControlledCommit.setCommitSucceed(true);
        System.setProperty(MetastoreConf.ConfVars.EVENT_LISTENERS.toString(), DummyListener.class.getName());
        System.setProperty(MetastoreConf.ConfVars.RAW_STORE_IMPL.toString(), DummyRawStoreControlledCommit.class.getName());
        this.conf = MetastoreConf.newMetastoreConf();
        MetastoreConf.setLongVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.THRIFT_CONNECTION_RETRIES, (long)3L);
        MetastoreConf.setBoolVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.HIVE_SUPPORT_CONCURRENCY, (boolean)false);
        MetaStoreTestUtils.setConfForStandloneMode(this.conf);
        MetaStoreTestUtils.startMetaStoreWithRetry(HadoopThriftAuthBridge.getBridge(), this.conf);
        this.msc = new HiveMetaStoreClient(this.conf);
        DummyListener.notifyList.clear();
    }

    @Test
    public void testEventStatus() throws Exception {
        int listSize = 0;
        List<ListenerEvent> notifyList = DummyListener.notifyList;
        Assert.assertEquals((long)notifyList.size(), (long)listSize);
        String dbName = "tmpDb";
        Database db = new DatabaseBuilder().setName(dbName).setCatalogName("hive").create((IMetaStoreClient)this.msc, this.conf);
        notifyList = DummyListener.notifyList;
        Assert.assertEquals((long)notifyList.size(), (long)(++listSize));
        Assert.assertTrue((boolean)DummyListener.getLastEvent().getStatus());
        String tableName = "unittest_TestMetaStoreEventListenerOnlyOnCommit";
        Table table = ((TableBuilder)new TableBuilder().inDb(db).setTableName(tableName).addCol("id", "int")).addPartCol("ds", "string").create((IMetaStoreClient)this.msc, this.conf);
        notifyList = DummyListener.notifyList;
        Assert.assertEquals((long)notifyList.size(), (long)(++listSize));
        Assert.assertTrue((boolean)DummyListener.getLastEvent().getStatus());
        new PartitionBuilder().inTable(table).addValue("foo1").addToTable((IMetaStoreClient)this.msc, this.conf);
        notifyList = DummyListener.notifyList;
        Assert.assertEquals((long)notifyList.size(), (long)(++listSize));
        Assert.assertTrue((boolean)DummyListener.getLastEvent().getStatus());
        DummyRawStoreControlledCommit.setCommitSucceed(false);
        new PartitionBuilder().inTable(table).addValue("foo2").addToTable((IMetaStoreClient)this.msc, this.conf);
        notifyList = DummyListener.notifyList;
        Assert.assertEquals((long)notifyList.size(), (long)(++listSize));
        Assert.assertFalse((boolean)DummyListener.getLastEvent().getStatus());
    }
}

