/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.AggregateStatsCache;
import org.apache.hadoop.hive.metastore.annotation.MetastoreUnitTest;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsData;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.api.LongColumnStatsData;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hive.common.util.BloomFilter;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MetastoreUnitTest.class})
public class TestAggregateStatsCache {
    static String DB_NAME = "db";
    static String TAB_PREFIX = "tab";
    static String PART_PREFIX = "part";
    static String COL_PREFIX = "col";
    static int NUM_TABS = 2;
    static int NUM_PARTS = 20;
    static int NUM_COLS = 5;
    static int MAX_CACHE_NODES = 10;
    static int MAX_PARTITIONS_PER_CACHE_NODE = 10;
    static long TIME_TO_LIVE = 2L;
    static long MAX_WRITER_WAIT = 1L;
    static long MAX_READER_WAIT = 1L;
    static double FALSE_POSITIVE_PROBABILITY = 0.01;
    static double MAX_VARIANCE = 0.5;
    static AggregateStatsCache cache;
    static List<String> tables;
    static List<String> tabParts;
    static List<String> tabCols;

    @BeforeClass
    public static void beforeTest() {
        TestAggregateStatsCache.initializeTables();
        TestAggregateStatsCache.initializePartitions();
        TestAggregateStatsCache.initializeColumns();
    }

    private static void initializeTables() {
        for (int i = 1; i <= NUM_TABS; ++i) {
            tables.add(TAB_PREFIX + i);
        }
    }

    private static void initializePartitions() {
        for (int i = 1; i <= NUM_PARTS; ++i) {
            tabParts.add(PART_PREFIX + i);
        }
    }

    private static void initializeColumns() {
        for (int i = 1; i <= NUM_COLS; ++i) {
            tabCols.add(COL_PREFIX + i);
        }
    }

    @AfterClass
    public static void afterTest() {
    }

    @Before
    public void setUp() {
        Configuration conf = MetastoreConf.newMetastoreConf();
        MetastoreConf.setLongVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.AGGREGATE_STATS_CACHE_SIZE, (long)MAX_CACHE_NODES);
        MetastoreConf.setLongVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.AGGREGATE_STATS_CACHE_MAX_PARTITIONS, (long)MAX_PARTITIONS_PER_CACHE_NODE);
        MetastoreConf.setDoubleVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.AGGREGATE_STATS_CACHE_FPP, (double)FALSE_POSITIVE_PROBABILITY);
        MetastoreConf.setDoubleVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.AGGREGATE_STATS_CACHE_MAX_VARIANCE, (double)MAX_VARIANCE);
        MetastoreConf.setTimeVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.AGGREGATE_STATS_CACHE_TTL, (long)TIME_TO_LIVE, (TimeUnit)TimeUnit.SECONDS);
        MetastoreConf.setTimeVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.AGGREGATE_STATS_CACHE_MAX_WRITER_WAIT, (long)MAX_WRITER_WAIT, (TimeUnit)TimeUnit.SECONDS);
        MetastoreConf.setTimeVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.AGGREGATE_STATS_CACHE_MAX_READER_WAIT, (long)MAX_READER_WAIT, (TimeUnit)TimeUnit.SECONDS);
        cache = AggregateStatsCache.getInstance((Configuration)conf);
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testCacheKey() {
        AggregateStatsCache.Key k1 = new AggregateStatsCache.Key("cat", "db", "tbl1", "col");
        AggregateStatsCache.Key k2 = new AggregateStatsCache.Key("cat", "db", "tbl1", "col");
        Assert.assertEquals((Object)k1, (Object)k2);
        AggregateStatsCache.Key k3 = new AggregateStatsCache.Key("cat", "db", "tbl2", "col");
        Assert.assertNotEquals((Object)k1, (Object)k3);
    }

    @Test
    public void testBasicAddAndGet() throws Exception {
        List<String> partNames = this.preparePartNames(tables.get(0), 1, 9);
        BloomFilter bloomFilter = this.prepareBloomFilter(partNames);
        String tblName = tables.get(0);
        String colName = tabCols.get(0);
        int highVal = 100;
        int lowVal = 10;
        int numDVs = 50;
        int numNulls = 5;
        ColumnStatisticsObj aggrColStats = this.getDummyLongColStat(colName, highVal, lowVal, numDVs, numNulls);
        cache.add("hive", DB_NAME, tblName, colName, 10L, aggrColStats, bloomFilter);
        AggregateStatsCache.AggrColStats aggrStatsCached = cache.get("hive", DB_NAME, tblName, colName, partNames);
        Assert.assertNotNull((Object)aggrStatsCached);
        ColumnStatisticsObj aggrColStatsCached = aggrStatsCached.getColStats();
        Assert.assertEquals((Object)aggrColStats, (Object)aggrColStatsCached);
        aggrStatsCached = cache.get("hive", "dbNotThere", tblName, colName, partNames);
        Assert.assertNull((Object)aggrStatsCached);
    }

    @Test
    public void testAddGetWithVariance() throws Exception {
        List<String> partNames = this.preparePartNames(tables.get(0), 1, 9);
        BloomFilter bloomFilter = this.prepareBloomFilter(partNames);
        String tblName = tables.get(0);
        String colName = tabCols.get(0);
        int highVal = 100;
        int lowVal = 10;
        int numDVs = 50;
        int numNulls = 5;
        ColumnStatisticsObj aggrColStats = this.getDummyLongColStat(colName, highVal, lowVal, numDVs, numNulls);
        cache.add("hive", DB_NAME, tblName, colName, 10L, aggrColStats, bloomFilter);
        partNames = this.preparePartNames(tables.get(0), 1, 5);
        AggregateStatsCache.AggrColStats aggrStatsCached = cache.get("hive", DB_NAME, tblName, colName, partNames);
        Assert.assertNull((Object)aggrStatsCached);
        partNames = this.preparePartNames(tables.get(0), 11, 20);
        aggrStatsCached = cache.get("hive", DB_NAME, tblName, colName, partNames);
        Assert.assertNull((Object)aggrStatsCached);
        partNames = this.preparePartNames(tables.get(0), 1, 8);
        aggrStatsCached = cache.get("hive", DB_NAME, tblName, colName, partNames);
        Assert.assertNotNull((Object)aggrStatsCached);
        ColumnStatisticsObj aggrColStatsCached = aggrStatsCached.getColStats();
        Assert.assertEquals((Object)aggrColStats, (Object)aggrColStatsCached);
    }

    @Test
    public void testTimeToLive() throws Exception {
        List<String> partNames = this.preparePartNames(tables.get(0), 1, 9);
        BloomFilter bloomFilter = this.prepareBloomFilter(partNames);
        String tblName = tables.get(0);
        String colName = tabCols.get(0);
        int highVal = 100;
        int lowVal = 10;
        int numDVs = 50;
        int numNulls = 5;
        ColumnStatisticsObj aggrColStats = this.getDummyLongColStat(colName, highVal, lowVal, numDVs, numNulls);
        cache.add("hive", DB_NAME, tblName, colName, 10L, aggrColStats, bloomFilter);
        Thread.sleep(3000L);
        AggregateStatsCache.AggrColStats aggrStatsCached = cache.get("hive", DB_NAME, tblName, colName, partNames);
        Assert.assertNull((Object)aggrStatsCached);
    }

    private List<String> preparePartNames(String tabName, int minPart, int maxPart) throws Exception {
        if (minPart < 1 || maxPart > NUM_PARTS) {
            throw new Exception("tabParts does not have these partition numbers");
        }
        ArrayList<String> partNames = new ArrayList<String>();
        for (int i = minPart; i <= maxPart; ++i) {
            String partName = tabParts.get(i - 1);
            partNames.add(tabName + partName);
        }
        return partNames;
    }

    private BloomFilter prepareBloomFilter(List<String> partNames) {
        BloomFilter bloomFilter = new BloomFilter((long)MAX_PARTITIONS_PER_CACHE_NODE, FALSE_POSITIVE_PROBABILITY);
        for (String partName : partNames) {
            bloomFilter.add(partName.getBytes());
        }
        return bloomFilter;
    }

    private ColumnStatisticsObj getDummyLongColStat(String colName, int highVal, int lowVal, int numDVs, int numNulls) {
        ColumnStatisticsObj aggrColStats = new ColumnStatisticsObj();
        aggrColStats.setColName(colName);
        aggrColStats.setColType("long");
        LongColumnStatsData longStatsData = new LongColumnStatsData();
        longStatsData.setHighValue((long)highVal);
        longStatsData.setLowValue((long)lowVal);
        longStatsData.setNumDVs((long)numDVs);
        longStatsData.setNumNulls((long)numNulls);
        ColumnStatisticsData aggrColStatsData = new ColumnStatisticsData();
        aggrColStatsData.setLongStats(longStatsData);
        aggrColStats.setStatsData(aggrColStatsData);
        return aggrColStats;
    }

    static {
        tables = new ArrayList<String>();
        tabParts = new ArrayList<String>();
        tabCols = new ArrayList<String>();
    }
}

