/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.servlet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.SerDeInfo;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.ql.io.HiveInputFormat;
import org.apache.hadoop.hive.ql.io.HiveOutputFormat;
import org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveServer2StatusServlet
extends HttpServlet {
    private static final Logger LOG = LoggerFactory.getLogger(HiveServer2StatusServlet.class);

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.setContentType("text/plain");
        response.setCharacterEncoding("UTF-8");
        try {
            HiveMetaStoreClient client = new HiveMetaStoreClient((Configuration)new HiveConf(((Object)((Object)this)).getClass()));
            String defaultDb = "default";
            Table table = new Table();
            table.setTemporary(true);
            table.setDbName(defaultDb);
            String tblName = String.format("status_%s", System.currentTimeMillis());
            table.setTableName(tblName);
            ArrayList<FieldSchema> cols = new ArrayList<FieldSchema>();
            cols.add(new FieldSchema("c1", "int", ""));
            this.addSd(cols, table);
            client.createTable(table);
            LOG.info("Created temp table {}", (Object)tblName);
            client.dropTable(defaultDb, tblName);
            LOG.info("Dropped temp table {}", (Object)tblName);
        }
        catch (Throwable e) {
            response.getWriter().write("2");
            return;
        }
        response.getWriter().write("0");
    }

    private void addSd(List<FieldSchema> cols, Table tbl) {
        StorageDescriptor sd = new StorageDescriptor();
        sd.setCols(cols);
        sd.setCompressed(false);
        sd.setNumBuckets(1);
        sd.setParameters(new HashMap());
        sd.setBucketCols(new ArrayList());
        sd.setSerdeInfo(new SerDeInfo());
        sd.getSerdeInfo().setName(tbl.getTableName());
        sd.getSerdeInfo().setParameters(new HashMap());
        sd.getSerdeInfo().getParameters().put("serialization.format", "1");
        sd.setSortCols(new ArrayList());
        sd.getSerdeInfo().setSerializationLib(LazySimpleSerDe.class.getName());
        sd.setInputFormat(HiveInputFormat.class.getName());
        sd.setOutputFormat(HiveOutputFormat.class.getName());
        tbl.setSd(sd);
    }
}

