/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.auth.ldap;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.SearchResult;
import org.mockito.Mockito;
import org.mockito.stubbing.OngoingStubbing;

public final class LdapTestUtils {
    private LdapTestUtils() {
    }

    public static NamingEnumeration<SearchResult> mockEmptyNamingEnumeration() throws NamingException {
        return LdapTestUtils.mockNamingEnumeration(new SearchResult[0]);
    }

    public static NamingEnumeration<SearchResult> mockNamingEnumeration(String ... dns) throws NamingException {
        return LdapTestUtils.mockNamingEnumeration(LdapTestUtils.mockSearchResults(dns).toArray(new SearchResult[0]));
    }

    public static NamingEnumeration<SearchResult> mockNamingEnumeration(SearchResult ... searchResults) throws NamingException {
        NamingEnumeration ne = (NamingEnumeration)Mockito.mock(NamingEnumeration.class);
        LdapTestUtils.mockHasMoreMethod(ne, searchResults.length);
        if (searchResults.length > 0) {
            List<SearchResult> mockedResults = Arrays.asList(searchResults);
            LdapTestUtils.mockNextMethod(ne, mockedResults);
        }
        return ne;
    }

    public static void mockHasMoreMethod(NamingEnumeration<SearchResult> ne, int length) throws NamingException {
        OngoingStubbing hasMoreStub = Mockito.when((Object)ne.hasMore());
        for (int i = 0; i < length; ++i) {
            hasMoreStub = hasMoreStub.thenReturn((Object)true);
        }
        hasMoreStub.thenReturn((Object)false);
    }

    public static void mockNextMethod(NamingEnumeration<SearchResult> ne, List<SearchResult> searchResults) throws NamingException {
        OngoingStubbing nextStub = Mockito.when((Object)ne.next());
        for (SearchResult searchResult : searchResults) {
            nextStub = nextStub.thenReturn((Object)searchResult);
        }
    }

    public static List<SearchResult> mockSearchResults(String[] dns) {
        ArrayList<SearchResult> list = new ArrayList<SearchResult>();
        for (String dn : dns) {
            list.add(LdapTestUtils.mockSearchResult(dn, null));
        }
        return list;
    }

    public static SearchResult mockSearchResult(String dn, Attributes attributes) {
        SearchResult searchResult = (SearchResult)Mockito.mock(SearchResult.class);
        Mockito.when((Object)searchResult.getNameInNamespace()).thenReturn((Object)dn);
        Mockito.when((Object)searchResult.getAttributes()).thenReturn((Object)attributes);
        return searchResult;
    }

    public static Attributes mockEmptyAttributes() throws NamingException {
        return LdapTestUtils.mockAttributes(new NameValues[0]);
    }

    public static Attributes mockAttributes(String name, String value) throws NamingException {
        return LdapTestUtils.mockAttributes(new NameValues(name, value));
    }

    public static Attributes mockAttributes(String name1, String value1, String name2, String value2) throws NamingException {
        if (name1.equals(name2)) {
            return LdapTestUtils.mockAttributes(new NameValues(name1, value1, value2));
        }
        return LdapTestUtils.mockAttributes(new NameValues(name1, value1), new NameValues(name2, value2));
    }

    private static Attributes mockAttributes(NameValues ... namedValues) throws NamingException {
        BasicAttributes attributes = new BasicAttributes();
        for (NameValues namedValue : namedValues) {
            BasicAttribute attr = new BasicAttribute(namedValue.name);
            for (String value : namedValue.values) {
                attr.add(value);
            }
            attributes.put(attr);
        }
        return attributes;
    }

    private static final class NameValues {
        final String name;
        final String[] values;

        public NameValues(String name, String ... values) {
            this.name = name;
            this.values = values;
        }
    }
}

