/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.auth.ldap;

import com.google.common.base.Preconditions;
import org.apache.hive.service.auth.ldap.Credentials;

public final class User {
    private final String dn;
    private final String id;
    private final String password;

    private User(Builder builder) {
        this.dn = builder.dn;
        this.id = builder.id;
        this.password = builder.password;
    }

    public String getDn() {
        return this.dn;
    }

    public String getId() {
        return this.id;
    }

    public String getPassword() {
        return this.password;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Credentials credentialsWithDn() {
        return Credentials.of(this.dn, this.password);
    }

    public Credentials credentialsWithId() {
        return Credentials.of(this.id, this.password);
    }

    public static final class Builder {
        private String dn;
        private String id;
        private String password;

        private Builder() {
        }

        public Builder dn(String dn) {
            Preconditions.checkNotNull((Object)dn, (Object)"DN should not be NULL");
            Preconditions.checkState((this.dn == null ? 1 : 0) != 0, (Object)"DN has been set already");
            this.dn = dn;
            return this;
        }

        public Builder id(String id) {
            Preconditions.checkNotNull((Object)id, (Object)"ID should not be NULL");
            Preconditions.checkState((this.id == null ? 1 : 0) != 0, (Object)"ID has been set already");
            this.id = id;
            return this;
        }

        public Builder password(String password) {
            Preconditions.checkNotNull((Object)password, (Object)"Password should not be NULL");
            Preconditions.checkState((this.password == null ? 1 : 0) != 0, (Object)"Password has been set already");
            this.password = password;
            return this;
        }

        public Builder useIdForPassword() {
            Preconditions.checkState((this.id != null ? 1 : 0) != 0, (Object)"User ID has not been set");
            return this.password(this.id);
        }

        public User build() {
            Preconditions.checkNotNull((Object)this.dn, (Object)"DN is required");
            Preconditions.checkNotNull((Object)this.id, (Object)"ID is required");
            Preconditions.checkNotNull((Object)this.password, (Object)"Password is required");
            return new User(this);
        }
    }
}

