/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.auth.ldap;

import java.io.IOException;
import javax.naming.NamingException;
import javax.security.sasl.AuthenticationException;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hive.service.auth.ldap.DirSearch;
import org.apache.hive.service.auth.ldap.Filter;
import org.apache.hive.service.auth.ldap.FilterFactory;
import org.apache.hive.service.auth.ldap.UserSearchFilterFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class TestUserSearchFilter {
    private FilterFactory factory;
    private HiveConf conf;
    @Mock
    private DirSearch search;

    @Before
    public void setup() {
        this.conf = new HiveConf();
        this.factory = new UserSearchFilterFactory();
    }

    @Test
    public void testFactoryWhenNoGroupOrUserFilters() {
        Assert.assertNull((Object)this.factory.getInstance(this.conf));
    }

    @Test
    public void testFactoryWhenGroupFilter() {
        this.conf.setVar(HiveConf.ConfVars.HIVE_SERVER2_PLAIN_LDAP_GROUPFILTER, "Grp1,Grp2");
        Assert.assertNotNull((Object)this.factory.getInstance(this.conf));
    }

    @Test
    public void testFactoryWhenUserFilter() {
        this.conf.setVar(HiveConf.ConfVars.HIVE_SERVER2_PLAIN_LDAP_USERFILTER, "User1,User2");
        Assert.assertNotNull((Object)this.factory.getInstance(this.conf));
    }

    @Test
    public void testApplyPositive() throws AuthenticationException, NamingException, IOException {
        this.conf.setVar(HiveConf.ConfVars.HIVE_SERVER2_PLAIN_LDAP_USERFILTER, "User1");
        Filter filter = this.factory.getInstance(this.conf);
        Mockito.when((Object)this.search.findUserDn(Mockito.anyString())).thenReturn((Object)"cn=User1,ou=People,dc=example,dc=com");
        filter.apply(this.search, "User1");
    }

    @Test(expected=AuthenticationException.class)
    public void testApplyWhenNamingException() throws AuthenticationException, NamingException, IOException {
        this.conf.setVar(HiveConf.ConfVars.HIVE_SERVER2_PLAIN_LDAP_USERFILTER, "User1");
        Filter filter = this.factory.getInstance(this.conf);
        Mockito.when((Object)this.search.findUserDn(Mockito.anyString())).thenThrow(new Class[]{NamingException.class});
        filter.apply(this.search, "User3");
    }

    @Test(expected=AuthenticationException.class)
    public void testApplyWhenNotFound() throws AuthenticationException, NamingException, IOException {
        this.conf.setVar(HiveConf.ConfVars.HIVE_SERVER2_PLAIN_LDAP_USERFILTER, "User1");
        Filter filter = this.factory.getInstance(this.conf);
        Mockito.when((Object)this.search.findUserDn(Mockito.anyString())).thenReturn(null);
        filter.apply(this.search, "User3");
    }
}

