/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.cli.operation;

import com.google.common.collect.Maps;
import java.util.Map;
import org.apache.hadoop.hive.common.metrics.MetricsTestUtils;
import org.apache.hadoop.hive.common.metrics.common.MetricsFactory;
import org.apache.hadoop.hive.common.metrics.metrics2.CodahaleMetrics;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hive.service.cli.OperationState;
import org.apache.hive.service.cli.operation.SQLOperation;
import org.apache.hive.service.cli.session.HiveSession;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TestSQLOperationMetrics {
    private SQLOperation operation;
    private CodahaleMetrics metrics;

    @Before
    public void setup() throws Exception {
        HiveConf conf = new HiveConf();
        conf.setBoolVar(HiveConf.ConfVars.HIVE_SERVER2_METRICS_ENABLED, true);
        MetricsFactory.init((HiveConf)conf);
        HiveSession session = (HiveSession)Mockito.mock(HiveSession.class);
        Mockito.when((Object)session.getHiveConf()).thenReturn((Object)conf);
        Mockito.when((Object)session.getSessionState()).thenReturn(Mockito.mock(SessionState.class));
        Mockito.when((Object)session.getUserName()).thenReturn((Object)"userName");
        this.operation = new SQLOperation(session, "select * from dummy", (Map)Maps.newHashMap(), false, 0L);
        this.metrics = (CodahaleMetrics)MetricsFactory.getInstance();
    }

    @After
    public void tearDown() throws Exception {
        MetricsFactory.getInstance().close();
    }

    @Test
    public void testSubmittedQueryCount() throws Exception {
        String json = this.metrics.dumpJson();
        MetricsTestUtils.verifyMetricsJson((String)json, (MetricsTestUtils.MetricsCategory)MetricsTestUtils.TIMER, (String)"hs2_submitted_queries", (Object)"0");
        this.operation.onNewState(OperationState.FINISHED, OperationState.RUNNING);
        json = this.metrics.dumpJson();
        MetricsTestUtils.verifyMetricsJson((String)json, (MetricsTestUtils.MetricsCategory)MetricsTestUtils.TIMER, (String)"hs2_submitted_queries", (Object)"1");
    }

    @Test
    public void testActiveUserQueriesCount() throws Exception {
        String name = "hs2_sql_operation_active_user";
        String json = this.metrics.dumpJson();
        MetricsTestUtils.verifyMetricsJson((String)json, (MetricsTestUtils.MetricsCategory)MetricsTestUtils.COUNTER, (String)name, (Object)"");
        this.operation.onNewState(OperationState.RUNNING, OperationState.INITIALIZED);
        json = this.metrics.dumpJson();
        MetricsTestUtils.verifyMetricsJson((String)json, (MetricsTestUtils.MetricsCategory)MetricsTestUtils.COUNTER, (String)name, (Object)"1");
        this.operation.onNewState(OperationState.RUNNING, OperationState.RUNNING);
        json = this.metrics.dumpJson();
        MetricsTestUtils.verifyMetricsJson((String)json, (MetricsTestUtils.MetricsCategory)MetricsTestUtils.COUNTER, (String)name, (Object)"1");
        this.operation.onNewState(OperationState.FINISHED, OperationState.RUNNING);
        json = this.metrics.dumpJson();
        MetricsTestUtils.verifyMetricsJson((String)json, (MetricsTestUtils.MetricsCategory)MetricsTestUtils.COUNTER, (String)name, (Object)"0");
    }

    @Test
    public void testSucceededQueriesCount() throws Exception {
        String json = this.metrics.dumpJson();
        MetricsTestUtils.verifyMetricsJson((String)json, (MetricsTestUtils.MetricsCategory)MetricsTestUtils.METER, (String)"hs2_succeeded_queries", (Object)"");
        this.operation.onNewState(OperationState.FINISHED, OperationState.RUNNING);
        json = this.metrics.dumpJson();
        MetricsTestUtils.verifyMetricsJson((String)json, (MetricsTestUtils.MetricsCategory)MetricsTestUtils.METER, (String)"hs2_succeeded_queries", (Object)"1");
        this.operation.onNewState(OperationState.ERROR, OperationState.RUNNING);
        json = this.metrics.dumpJson();
        MetricsTestUtils.verifyMetricsJson((String)json, (MetricsTestUtils.MetricsCategory)MetricsTestUtils.METER, (String)"hs2_succeeded_queries", (Object)"1");
        this.operation.onNewState(OperationState.CANCELED, OperationState.RUNNING);
        json = this.metrics.dumpJson();
        MetricsTestUtils.verifyMetricsJson((String)json, (MetricsTestUtils.MetricsCategory)MetricsTestUtils.METER, (String)"hs2_succeeded_queries", (Object)"1");
        this.operation.onNewState(OperationState.FINISHED, OperationState.RUNNING);
        json = this.metrics.dumpJson();
        MetricsTestUtils.verifyMetricsJson((String)json, (MetricsTestUtils.MetricsCategory)MetricsTestUtils.METER, (String)"hs2_succeeded_queries", (Object)"2");
    }

    @Test
    public void testFailedQueriesCount() throws Exception {
        String json = this.metrics.dumpJson();
        MetricsTestUtils.verifyMetricsJson((String)json, (MetricsTestUtils.MetricsCategory)MetricsTestUtils.METER, (String)"hs2_failed_queries", (Object)"");
        this.operation.onNewState(OperationState.ERROR, OperationState.RUNNING);
        json = this.metrics.dumpJson();
        MetricsTestUtils.verifyMetricsJson((String)json, (MetricsTestUtils.MetricsCategory)MetricsTestUtils.METER, (String)"hs2_failed_queries", (Object)"1");
        this.operation.onNewState(OperationState.FINISHED, OperationState.RUNNING);
        json = this.metrics.dumpJson();
        MetricsTestUtils.verifyMetricsJson((String)json, (MetricsTestUtils.MetricsCategory)MetricsTestUtils.METER, (String)"hs2_failed_queries", (Object)"1");
        this.operation.onNewState(OperationState.CANCELED, OperationState.RUNNING);
        json = this.metrics.dumpJson();
        MetricsTestUtils.verifyMetricsJson((String)json, (MetricsTestUtils.MetricsCategory)MetricsTestUtils.METER, (String)"hs2_failed_queries", (Object)"1");
        this.operation.onNewState(OperationState.ERROR, OperationState.RUNNING);
        json = this.metrics.dumpJson();
        MetricsTestUtils.verifyMetricsJson((String)json, (MetricsTestUtils.MetricsCategory)MetricsTestUtils.METER, (String)"hs2_failed_queries", (Object)"2");
    }
}

