/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2.io;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.hive.common.type.Date;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.WritableUtils;

public class DateWritableV2
implements WritableComparable<DateWritableV2> {
    private Date date = new Date();

    public DateWritableV2() {
    }

    public DateWritableV2(DateWritableV2 d) {
        this.set(d);
    }

    public DateWritableV2(Date d) {
        this.set(d);
    }

    public DateWritableV2(int d) {
        this.set(d);
    }

    public void set(int d) {
        this.date = Date.ofEpochDay((int)d);
    }

    public void set(Date d) {
        if (d == null) {
            this.date = new Date();
            return;
        }
        this.set(d.toEpochDay());
    }

    public void set(DateWritableV2 d) {
        this.set(d.getDays());
    }

    public Date get() {
        return this.date;
    }

    public int getDays() {
        return this.date.toEpochDay();
    }

    public long getTimeInSeconds() {
        return this.date.toEpochSecond();
    }

    public static Date timeToDate(long seconds) {
        return Date.ofEpochMilli((long)(seconds * 1000L));
    }

    public static long daysToMillis(int days) {
        return Date.ofEpochDay((int)days).toEpochMilli();
    }

    public static int millisToDays(long millis) {
        return Date.ofEpochMilli((long)millis).toEpochDay();
    }

    public static int dateToDays(Date d) {
        return d.toEpochDay();
    }

    @Deprecated
    public static int dateToDays(java.sql.Date d) {
        return Date.ofEpochMilli((long)d.getTime()).toEpochDay();
    }

    public void readFields(DataInput in) throws IOException {
        this.date.setTimeInDays(WritableUtils.readVInt((DataInput)in));
    }

    public void write(DataOutput out) throws IOException {
        WritableUtils.writeVInt((DataOutput)out, (int)this.date.toEpochDay());
    }

    public int compareTo(DateWritableV2 d) {
        return this.date.compareTo(d.date);
    }

    public boolean equals(Object o) {
        if (!(o instanceof DateWritableV2)) {
            return false;
        }
        return this.compareTo((DateWritableV2)o) == 0;
    }

    public String toString() {
        return this.date.toString();
    }

    public int hashCode() {
        return this.date.toEpochDay();
    }
}

