/*
 * Decompiled with CFR 0.152.
 */
package jodd.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public class UnicodeInputStream
extends InputStream {
    public static final int MAX_BOM_SIZE = 4;
    private final PushbackInputStream internalInputStream;
    private boolean initialized;
    private int BOMSize = -1;
    private Charset encoding;
    private final Charset targetEncoding;
    public static final byte[] BOM_UTF32_BE = new byte[]{0, 0, -2, -1};
    public static final byte[] BOM_UTF32_LE = new byte[]{-1, -2, 0, 0};
    public static final byte[] BOM_UTF8 = new byte[]{-17, -69, -65};
    public static final byte[] BOM_UTF16_BE = new byte[]{-2, -1};
    public static final byte[] BOM_UTF16_LE = new byte[]{-1, -2};

    public UnicodeInputStream(InputStream in, Charset targetEncoding) {
        this.internalInputStream = new PushbackInputStream(in, 4);
        this.targetEncoding = targetEncoding;
    }

    public Charset getDetectedEncoding() {
        if (!this.initialized) {
            try {
                this.init();
            }
            catch (IOException ioex) {
                throw new IllegalStateException(ioex);
            }
        }
        return this.encoding;
    }

    protected void init() throws IOException {
        if (this.initialized) {
            return;
        }
        if (this.targetEncoding == null) {
            int unread;
            byte[] bom = new byte[4];
            int n = this.internalInputStream.read(bom, 0, bom.length);
            if (bom[0] == BOM_UTF32_BE[0] && bom[1] == BOM_UTF32_BE[1] && bom[2] == BOM_UTF32_BE[2] && bom[3] == BOM_UTF32_BE[3]) {
                this.encoding = Charset.forName("UTF-32BE");
                unread = n - 4;
            } else if (bom[0] == BOM_UTF32_LE[0] && bom[1] == BOM_UTF32_LE[1] && bom[2] == BOM_UTF32_LE[2] && bom[3] == BOM_UTF32_LE[3]) {
                this.encoding = Charset.forName("UTF-32LE");
                unread = n - 4;
            } else if (bom[0] == BOM_UTF8[0] && bom[1] == BOM_UTF8[1] && bom[2] == BOM_UTF8[2]) {
                this.encoding = StandardCharsets.UTF_8;
                unread = n - 3;
            } else if (bom[0] == BOM_UTF16_BE[0] && bom[1] == BOM_UTF16_BE[1]) {
                this.encoding = StandardCharsets.UTF_16BE;
                unread = n - 2;
            } else if (bom[0] == BOM_UTF16_LE[0] && bom[1] == BOM_UTF16_LE[1]) {
                this.encoding = StandardCharsets.UTF_16LE;
                unread = n - 2;
            } else {
                unread = n;
            }
            this.BOMSize = 4 - unread;
            if (unread > 0) {
                this.internalInputStream.unread(bom, n - unread, unread);
            }
        } else {
            String targetEncodingName;
            byte[] bom = null;
            switch (targetEncodingName = this.targetEncoding.name()) {
                case "UTF-8": {
                    bom = BOM_UTF8;
                    break;
                }
                case "UTF-16LE": {
                    bom = BOM_UTF16_LE;
                    break;
                }
                case "UTF-16BE": 
                case "UTF-16": {
                    bom = BOM_UTF16_BE;
                    break;
                }
                case "UTF-32LE": {
                    bom = BOM_UTF32_LE;
                    break;
                }
                case "UTF-32BE": 
                case "UTF-32": {
                    bom = BOM_UTF32_BE;
                    break;
                }
            }
            if (bom != null) {
                byte[] fileBom = new byte[bom.length];
                int n = this.internalInputStream.read(fileBom, 0, bom.length);
                boolean bomDetected = true;
                for (int i = 0; i < n; ++i) {
                    if (fileBom[i] == bom[i]) continue;
                    bomDetected = false;
                    break;
                }
                if (!bomDetected) {
                    this.internalInputStream.unread(fileBom, 0, fileBom.length);
                }
            }
        }
        this.initialized = true;
    }

    @Override
    public void close() throws IOException {
        this.internalInputStream.close();
    }

    @Override
    public int read() throws IOException {
        this.init();
        return this.internalInputStream.read();
    }

    public int getBOMSize() {
        return this.BOMSize;
    }
}

