/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.sql.method;

import java.util.List;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.query.compiler.CompilationComponent;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.sql.SQLStatement;
import org.datanucleus.store.rdbms.sql.SelectStatement;
import org.datanucleus.store.rdbms.sql.expression.AggregateNumericExpression;
import org.datanucleus.store.rdbms.sql.expression.NumericSubqueryExpression;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.sql.expression.SQLExpressionFactory;
import org.datanucleus.store.rdbms.sql.method.SimpleNumericAggregateMethod;
import org.datanucleus.util.Localiser;

public class AvgFunction
extends SimpleNumericAggregateMethod {
    @Override
    protected String getFunctionName() {
        return "AVG";
    }

    public SQLExpression getExpression(SQLStatement stmt, SQLExpression expr, List args) {
        if (expr != null) {
            throw new NucleusException(Localiser.msg((String)"060002", (Object[])new Object[]{this.getFunctionName(), expr}));
        }
        if (args == null || args.size() != 1) {
            throw new NucleusException(this.getFunctionName() + " is only supported with a single argument");
        }
        Class<Double> returnType = Double.class;
        SQLExpressionFactory exprFactory = stmt.getSQLExpressionFactory();
        if (stmt.getQueryGenerator().getCompilationComponent() == CompilationComponent.RESULT || stmt.getQueryGenerator().getCompilationComponent() == CompilationComponent.HAVING) {
            JavaTypeMapping m = exprFactory.getMappingForType(returnType, true);
            return this.getAggregateExpression(stmt, args, m);
        }
        ClassLoaderResolver clr = stmt.getQueryGenerator().getClassLoaderResolver();
        SQLExpression argExpr = (SQLExpression)args.get(0);
        SelectStatement subStmt = new SelectStatement(stmt, stmt.getRDBMSManager(), argExpr.getSQLTable().getTable(), argExpr.getSQLTable().getAlias(), null);
        subStmt.setClassLoaderResolver(clr);
        JavaTypeMapping mapping = stmt.getRDBMSManager().getMappingManager().getMappingWithColumnMapping(String.class, false, false, clr);
        SQLExpression aggExpr = this.getAggregateExpression(stmt, args, mapping);
        subStmt.select(aggExpr, null);
        JavaTypeMapping subqMapping = exprFactory.getMappingForType(returnType, false);
        NumericSubqueryExpression subqExpr = new NumericSubqueryExpression(stmt, subStmt);
        subqExpr.setJavaTypeMapping(subqMapping);
        return subqExpr;
    }

    protected SQLExpression getAggregateExpression(SQLStatement stmt, List args, JavaTypeMapping m) {
        return new AggregateNumericExpression(stmt, m, this.getFunctionName(), args);
    }

    @Override
    protected Class getClassForMapping() {
        return Double.TYPE;
    }
}

