/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.mapping.column;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.exceptions.NullValueException;
import org.datanucleus.store.rdbms.mapping.column.AbstractColumnMapping;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.table.Column;
import org.datanucleus.util.Localiser;

public class RealColumnMapping
extends AbstractColumnMapping {
    public RealColumnMapping(JavaTypeMapping mapping, RDBMSStoreManager storeMgr, Column col) {
        super(storeMgr, mapping);
        this.column = col;
        this.initialize();
    }

    private void initialize() {
        if (this.column != null) {
            this.column.checkPrimitive();
        }
        this.initTypeInfo();
    }

    @Override
    public boolean isDecimalBased() {
        return true;
    }

    @Override
    public int getJDBCType() {
        return 7;
    }

    @Override
    public void setFloat(PreparedStatement ps, int param, float value) {
        try {
            ps.setFloat(param, value);
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(Localiser.msg((String)"055001", (Object[])new Object[]{"float", "" + value, this.column, e.getMessage()}), (Throwable)e);
        }
    }

    @Override
    public float getFloat(ResultSet rs, int param) {
        float value;
        try {
            value = rs.getFloat(param);
            if ((this.column == null || this.column.getColumnMetaData() == null || !this.column.getColumnMetaData().isAllowsNull()) && rs.wasNull()) {
                throw new NullValueException(Localiser.msg((String)"055003", (Object[])new Object[]{this.column}));
            }
        }
        catch (SQLException e) {
            try {
                value = Float.parseFloat(rs.getString(param));
                if ((this.column == null || this.column.getColumnMetaData() == null || !this.column.getColumnMetaData().isAllowsNull()) && rs.wasNull()) {
                    throw new NullValueException(Localiser.msg((String)"055003", (Object[])new Object[]{this.column}));
                }
            }
            catch (SQLException e1) {
                try {
                    throw new NucleusDataStoreException("Can't get float result: param = " + param + " - " + rs.getString(param), (Throwable)e);
                }
                catch (SQLException e2) {
                    throw new NucleusDataStoreException(Localiser.msg((String)"055002", (Object[])new Object[]{"float", "" + param, this.column, e.getMessage()}), (Throwable)e);
                }
            }
        }
        return value;
    }

    @Override
    public void setObject(PreparedStatement ps, int param, Object value) {
        try {
            if (value == null) {
                if (this.useDefaultWhenNull()) {
                    ps.setFloat(param, Float.valueOf(this.column.getDefaultValue().toString()).floatValue());
                } else {
                    ps.setNull(param, this.getJDBCType());
                }
            } else {
                ps.setFloat(param, ((Float)value).floatValue());
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(Localiser.msg((String)"055001", (Object[])new Object[]{"Object", "" + value, this.column, e.getMessage()}), (Throwable)e);
        }
    }

    @Override
    public Object getObject(ResultSet rs, int param) {
        Float value;
        try {
            float f = rs.getFloat(param);
            value = rs.wasNull() ? null : Float.valueOf(f);
        }
        catch (SQLException e) {
            try {
                value = new Float(Float.parseFloat(rs.getString(param)));
                if ((this.column == null || this.column.getColumnMetaData() == null || !this.column.getColumnMetaData().isAllowsNull()) && rs.wasNull()) {
                    throw new NullValueException(Localiser.msg((String)"055003", (Object[])new Object[]{this.column}));
                }
            }
            catch (SQLException e1) {
                try {
                    throw new NucleusDataStoreException("Can't get float result: param = " + param + " - " + rs.getString(param), (Throwable)e);
                }
                catch (SQLException e2) {
                    throw new NucleusDataStoreException(Localiser.msg((String)"055002", (Object[])new Object[]{"Object", "" + param, this.column, e.getMessage()}), (Throwable)e);
                }
            }
        }
        return value;
    }
}

