/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.hbase;

import java.io.Closeable;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hive.hbase.ColumnMappings;
import org.apache.hadoop.hive.hbase.HBaseSerDe;
import org.apache.hadoop.hive.metastore.HiveMetaHook;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;
import org.apache.hadoop.util.StringUtils;

public class HBaseMetaHook
implements HiveMetaHook,
Closeable {
    private Configuration hbaseConf;
    private Admin admin;

    public HBaseMetaHook(Configuration hbaseConf) {
        this.hbaseConf = hbaseConf;
    }

    private Admin getHBaseAdmin() throws MetaException {
        try {
            if (this.admin == null) {
                Connection conn = ConnectionFactory.createConnection((Configuration)this.hbaseConf);
                this.admin = conn.getAdmin();
            }
            return this.admin;
        }
        catch (IOException ioe) {
            throw new MetaException(StringUtils.stringifyException((Throwable)ioe));
        }
    }

    private String getHBaseTableName(Table tbl) {
        String tableName = (String)tbl.getParameters().get("hbase.table.name");
        if (tableName == null && (tableName = (String)tbl.getSd().getSerdeInfo().getParameters().get("hbase.table.name")) != null) {
            tableName = tableName.toLowerCase();
        }
        if (tableName == null && (tableName = (tbl.getDbName() + "." + tbl.getTableName()).toLowerCase()).startsWith("default.")) {
            tableName = tableName.substring("default.".length());
        }
        return tableName;
    }

    public void preDropTable(Table table) throws MetaException {
    }

    public void rollbackDropTable(Table table) throws MetaException {
    }

    public void commitDropTable(Table tbl, boolean deleteData) throws MetaException {
        try {
            String tableName = this.getHBaseTableName(tbl);
            boolean isExternal = MetaStoreUtils.isExternalTable((Table)tbl);
            if (deleteData && !isExternal) {
                if (this.getHBaseAdmin().isTableEnabled(TableName.valueOf((String)tableName))) {
                    this.getHBaseAdmin().disableTable(TableName.valueOf((String)tableName));
                }
                this.getHBaseAdmin().deleteTable(TableName.valueOf((String)tableName));
            }
        }
        catch (IOException ie) {
            throw new MetaException(StringUtils.stringifyException((Throwable)ie));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void preCreateTable(Table tbl) throws MetaException {
        boolean isExternal = MetaStoreUtils.isExternalTable((Table)tbl);
        if (tbl.getSd().getLocation() != null) {
            throw new MetaException("LOCATION may not be specified for HBase.");
        }
        org.apache.hadoop.hbase.client.Table htable = null;
        try {
            HTableDescriptor tableDesc;
            String tableName = this.getHBaseTableName(tbl);
            Map serdeParam = tbl.getSd().getSerdeInfo().getParameters();
            String hbaseColumnsMapping = (String)serdeParam.get("hbase.columns.mapping");
            ColumnMappings columnMappings = HBaseSerDe.parseColumnsMapping(hbaseColumnsMapping);
            if (!this.getHBaseAdmin().tableExists(TableName.valueOf((String)tableName))) {
                if (isExternal) throw new MetaException("HBase table " + tableName + " doesn't exist while the table is declared as an external table.");
                tableDesc = new HTableDescriptor(TableName.valueOf((String)tableName));
                HashSet<String> uniqueColumnFamilies = new HashSet<String>();
                for (ColumnMappings.ColumnMapping colMap : columnMappings) {
                    if (colMap.hbaseRowKey || colMap.hbaseTimestamp) continue;
                    uniqueColumnFamilies.add(colMap.familyName);
                }
                for (String columnFamily : uniqueColumnFamilies) {
                    tableDesc.addFamily(new HColumnDescriptor(Bytes.toBytes((String)columnFamily)));
                }
                this.getHBaseAdmin().createTable(tableDesc);
            } else {
                if (!isExternal) {
                    throw new MetaException("Table " + tableName + " already exists within HBase; use CREATE EXTERNAL TABLE instead to register it in Hive.");
                }
                tableDesc = this.getHBaseAdmin().getTableDescriptor(TableName.valueOf((String)tableName));
                for (ColumnMappings.ColumnMapping colMap : columnMappings) {
                    if (colMap.hbaseRowKey || colMap.hbaseTimestamp || tableDesc.hasFamily(colMap.familyNameBytes)) continue;
                    throw new MetaException("Column Family " + colMap.familyName + " is not defined in hbase table " + tableName);
                }
            }
            htable = this.getHBaseAdmin().getConnection().getTable(tableDesc.getTableName());
            if (htable == null) return;
        }
        catch (Exception se) {
            try {
                throw new MetaException(StringUtils.stringifyException((Throwable)se));
            }
            catch (Throwable throwable) {
                if (htable == null) throw throwable;
                IOUtils.closeQuietly(htable);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Closeable)htable);
        return;
    }

    public void rollbackCreateTable(Table table) throws MetaException {
        boolean isExternal = MetaStoreUtils.isExternalTable((Table)table);
        String tableName = this.getHBaseTableName(table);
        try {
            if (!isExternal && this.getHBaseAdmin().tableExists(TableName.valueOf((String)tableName))) {
                if (this.getHBaseAdmin().isTableEnabled(TableName.valueOf((String)tableName))) {
                    this.getHBaseAdmin().disableTable(TableName.valueOf((String)tableName));
                }
                this.getHBaseAdmin().deleteTable(TableName.valueOf((String)tableName));
            }
        }
        catch (IOException ie) {
            throw new MetaException(StringUtils.stringifyException((Throwable)ie));
        }
    }

    public void commitCreateTable(Table table) throws MetaException {
    }

    @Override
    public void close() throws IOException {
        if (this.admin != null) {
            Connection connection = this.admin.getConnection();
            this.admin.close();
            this.admin = null;
            if (connection != null) {
                connection.close();
            }
        }
    }
}

