/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.accumulo.mr;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.mapred.AccumuloInputFormat;
import org.apache.accumulo.core.client.mapred.AccumuloRowInputFormat;
import org.apache.accumulo.core.client.mapred.RangeInputSplit;
import org.apache.accumulo.core.client.mapreduce.lib.impl.ConfiguratorBase;
import org.apache.accumulo.core.client.mock.MockInstance;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.client.security.tokens.KerberosToken;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.util.Pair;
import org.apache.accumulo.core.util.PeekingIterator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.accumulo.AccumuloConnectionParameters;
import org.apache.hadoop.hive.accumulo.AccumuloHiveRow;
import org.apache.hadoop.hive.accumulo.HiveAccumuloHelper;
import org.apache.hadoop.hive.accumulo.columns.ColumnMapper;
import org.apache.hadoop.hive.accumulo.columns.ColumnMapping;
import org.apache.hadoop.hive.accumulo.columns.HiveAccumuloColumnMapping;
import org.apache.hadoop.hive.accumulo.columns.HiveAccumuloMapColumnMapping;
import org.apache.hadoop.hive.accumulo.mr.HiveAccumuloRecordReader;
import org.apache.hadoop.hive.accumulo.mr.HiveAccumuloSplit;
import org.apache.hadoop.hive.accumulo.predicate.AccumuloPredicateHandler;
import org.apache.hadoop.hive.accumulo.serde.AccumuloSerDeParameters;
import org.apache.hadoop.hive.accumulo.serde.TooManyAccumuloColumnsException;
import org.apache.hadoop.hive.serde2.ColumnProjectionUtils;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.StringUtils;
import org.apache.log4j.Level;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveAccumuloTableInputFormat
implements InputFormat<Text, AccumuloHiveRow> {
    private static final Logger log = LoggerFactory.getLogger(HiveAccumuloTableInputFormat.class);
    protected AccumuloRowInputFormat accumuloInputFormat = new AccumuloRowInputFormat();
    protected AccumuloPredicateHandler predicateHandler = AccumuloPredicateHandler.getInstance();
    protected HiveAccumuloHelper helper = new HiveAccumuloHelper();

    public InputSplit[] getSplits(JobConf jobConf, int numSplits) throws IOException {
        ColumnMapper columnMapper;
        AccumuloConnectionParameters accumuloParams = new AccumuloConnectionParameters((Configuration)jobConf);
        Instance instance = accumuloParams.getInstance();
        try {
            columnMapper = this.getColumnMapper((Configuration)jobConf);
        }
        catch (TooManyAccumuloColumnsException e) {
            throw new IOException((Throwable)((Object)e));
        }
        JobContext context = ShimLoader.getHadoopShims().newJobContext(Job.getInstance((Configuration)jobConf));
        Path[] tablePaths = FileInputFormat.getInputPaths((JobContext)context);
        try {
            Connector connector = null;
            if (accumuloParams.useSasl()) {
                log.info("Current user: " + UserGroupInformation.getCurrentUser());
                AuthenticationToken token = ConfiguratorBase.getAuthenticationToken(AccumuloInputFormat.class, (Configuration)jobConf);
                if (null != token && !jobConf.getCredentials().getAllTokens().isEmpty()) {
                    log.info("Found authentication token in Configuration: " + token);
                    log.info("Job credential tokens: " + jobConf.getCredentials().getAllTokens());
                    AuthenticationToken unwrappedToken = ConfiguratorBase.unwrapAuthenticationToken((JobConf)jobConf, (AuthenticationToken)token);
                    log.info("Converted authentication token from Configuration into: " + unwrappedToken);
                    if (unwrappedToken != token) {
                        log.info("Creating Accumulo Connector with unwrapped delegation token");
                        connector = instance.getConnector(accumuloParams.getAccumuloUserName(), unwrappedToken);
                    } else {
                        log.info("Job credentials did not contain delegation token, fetching new token");
                    }
                }
                if (connector == null) {
                    log.info("Obtaining Accumulo Connector using KerberosToken");
                    connector = instance.getConnector(accumuloParams.getAccumuloUserName(), (AuthenticationToken)new KerberosToken(accumuloParams.getAccumuloUserName()));
                }
            } else {
                connector = accumuloParams.getConnector(instance);
            }
            List<ColumnMapping> columnMappings = columnMapper.getColumnMappings();
            List<IteratorSetting> iterators = this.predicateHandler.getIterators((Configuration)jobConf, columnMapper);
            List<Range> ranges = this.predicateHandler.getRanges((Configuration)jobConf, columnMapper);
            if (null != ranges && ranges.isEmpty()) {
                return new InputSplit[0];
            }
            this.configure(jobConf, instance, connector, accumuloParams, columnMapper, iterators, ranges);
            int numColumns = columnMappings.size();
            List readColIds = ColumnProjectionUtils.getReadColumnIDs((Configuration)jobConf);
            if (numColumns < readColIds.size()) {
                throw new IOException("Number of column mappings (" + numColumns + ") numbers less than the hive table columns. (" + readColIds.size() + ")");
            }
            InputSplit[] splits = this.accumuloInputFormat.getSplits(jobConf, numSplits);
            InputSplit[] hiveSplits = new HiveAccumuloSplit[splits.length];
            for (int i = 0; i < splits.length; ++i) {
                RangeInputSplit ris = (RangeInputSplit)splits[i];
                ris.setLogLevel(Level.DEBUG);
                hiveSplits[i] = new HiveAccumuloSplit(ris, tablePaths[0]);
            }
            return hiveSplits;
        }
        catch (AccumuloException e) {
            log.error("Could not configure AccumuloInputFormat", (Throwable)e);
            throw new IOException(StringUtils.stringifyException((Throwable)e));
        }
        catch (AccumuloSecurityException e) {
            log.error("Could not configure AccumuloInputFormat", (Throwable)e);
            throw new IOException(StringUtils.stringifyException((Throwable)e));
        }
        catch (SerDeException e) {
            log.error("Could not configure AccumuloInputFormat", (Throwable)e);
            throw new IOException(StringUtils.stringifyException((Throwable)e));
        }
    }

    public RecordReader<Text, AccumuloHiveRow> getRecordReader(InputSplit inputSplit, JobConf jobConf, Reporter reporter) throws IOException {
        ColumnMapper columnMapper;
        try {
            columnMapper = this.getColumnMapper((Configuration)jobConf);
        }
        catch (TooManyAccumuloColumnsException e) {
            throw new IOException((Throwable)((Object)e));
        }
        try {
            AccumuloConnectionParameters accumuloParams = new AccumuloConnectionParameters((Configuration)jobConf);
            List<IteratorSetting> iterators = this.predicateHandler.getIterators((Configuration)jobConf, columnMapper);
            HiveAccumuloSplit hiveSplit = (HiveAccumuloSplit)inputSplit;
            RangeInputSplit rangeSplit = hiveSplit.getSplit();
            log.info("Split: " + rangeSplit);
            if (null == rangeSplit.getIterators() || rangeSplit.getIterators().isEmpty() && !iterators.isEmpty()) {
                log.debug("Re-setting iterators on InputSplit due to Accumulo bug.");
                rangeSplit.setIterators(iterators);
            }
            if (null == rangeSplit.getTableName()) {
                rangeSplit.setTableName(accumuloParams.getAccumuloTableName());
            }
            if (accumuloParams.useSasl()) {
                this.helper.setInputFormatZooKeeperInstance(jobConf, accumuloParams.getAccumuloInstanceName(), accumuloParams.getZooKeepers(), accumuloParams.useSasl());
            }
            RecordReader recordReader = this.accumuloInputFormat.getRecordReader((InputSplit)rangeSplit, jobConf, reporter);
            return new HiveAccumuloRecordReader((RecordReader<Text, PeekingIterator<Map.Entry<Key, Value>>>)recordReader, iterators.size());
        }
        catch (SerDeException e) {
            throw new IOException(StringUtils.stringifyException((Throwable)e));
        }
    }

    protected ColumnMapper getColumnMapper(Configuration conf) throws IOException, TooManyAccumuloColumnsException {
        String defaultStorageType = conf.get("accumulo.default.storage");
        String[] columnNamesArr = conf.getStrings("columns");
        if (null == columnNamesArr) {
            throw new IOException("Hive column names must be provided to InputFormat in the Configuration");
        }
        List<String> columnNames = Arrays.asList(columnNamesArr);
        String serializedTypes = conf.get("columns.types");
        if (null == serializedTypes) {
            throw new IOException("Hive column types must be provided to InputFormat in the Configuration");
        }
        ArrayList columnTypes = TypeInfoUtils.getTypeInfosFromTypeString((String)serializedTypes);
        return new ColumnMapper(conf.get("accumulo.columns.mapping"), defaultStorageType, columnNames, columnTypes);
    }

    protected void configure(JobConf conf, Instance instance, Connector connector, AccumuloConnectionParameters accumuloParams, ColumnMapper columnMapper, List<IteratorSetting> iterators, Collection<Range> ranges) throws AccumuloSecurityException, AccumuloException, SerDeException, IOException {
        HashSet<Pair<Text, Text>> pairs;
        if (instance instanceof MockInstance) {
            this.getHelper().setInputFormatMockInstance(conf, instance.getInstanceName());
        } else {
            this.getHelper().setInputFormatZooKeeperInstance(conf, instance.getInstanceName(), instance.getZooKeepers(), accumuloParams.useSasl());
        }
        if (accumuloParams.useSasl()) {
            this.getHelper().updateInputFormatConfWithAccumuloToken(conf, UserGroupInformation.getCurrentUser(), accumuloParams);
        } else {
            this.getHelper().setInputFormatConnectorInfo(conf, accumuloParams.getAccumuloUserName(), (AuthenticationToken)new PasswordToken((CharSequence)accumuloParams.getAccumuloPassword()));
        }
        this.setInputTableName(conf, accumuloParams.getAccumuloTableName());
        Authorizations auths = AccumuloSerDeParameters.getAuthorizationsFromConf((Configuration)conf);
        if (null == auths) {
            auths = connector.securityOperations().getUserAuthorizations(accumuloParams.getAccumuloUserName());
        }
        this.setScanAuthorizations(conf, auths);
        this.addIterators(conf, iterators);
        if (null != ranges) {
            log.info("Setting ranges: " + ranges);
            this.setRanges(conf, ranges);
        }
        if (null != (pairs = this.getPairCollection(columnMapper.getColumnMappings())) && !pairs.isEmpty()) {
            this.fetchColumns(conf, pairs);
        }
    }

    protected void setInputTableName(JobConf conf, String tableName) {
        AccumuloInputFormat.setInputTableName((JobConf)conf, (String)tableName);
    }

    protected void setScanAuthorizations(JobConf conf, Authorizations auths) {
        AccumuloInputFormat.setScanAuthorizations((JobConf)conf, (Authorizations)auths);
    }

    protected void addIterators(JobConf conf, List<IteratorSetting> iterators) {
        for (IteratorSetting is : iterators) {
            AccumuloInputFormat.addIterator((JobConf)conf, (IteratorSetting)is);
        }
    }

    protected void setRanges(JobConf conf, Collection<Range> ranges) {
        AccumuloInputFormat.setRanges((JobConf)conf, ranges);
    }

    protected void fetchColumns(JobConf conf, Set<Pair<Text, Text>> cfCqPairs) {
        AccumuloInputFormat.fetchColumns((JobConf)conf, cfCqPairs);
    }

    protected HashSet<Pair<Text, Text>> getPairCollection(List<ColumnMapping> columnMappings) {
        HashSet<Pair<Text, Text>> pairs = new HashSet<Pair<Text, Text>>();
        for (ColumnMapping columnMapping : columnMappings) {
            if (columnMapping instanceof HiveAccumuloColumnMapping) {
                HiveAccumuloColumnMapping accumuloColumnMapping = (HiveAccumuloColumnMapping)columnMapping;
                Text cf = new Text(accumuloColumnMapping.getColumnFamily());
                Text cq = null;
                if (null != accumuloColumnMapping.getColumnQualifier()) {
                    cq = new Text(accumuloColumnMapping.getColumnQualifier());
                }
                pairs.add((Pair<Text, Text>)new Pair((Object)cf, (Object)cq));
                continue;
            }
            if (!(columnMapping instanceof HiveAccumuloMapColumnMapping)) continue;
            HiveAccumuloMapColumnMapping mapMapping = (HiveAccumuloMapColumnMapping)columnMapping;
            pairs.add((Pair<Text, Text>)new Pair((Object)new Text(mapMapping.getColumnFamily()), null));
        }
        log.info("Computed columns to fetch (" + pairs + ") from " + columnMappings);
        return pairs;
    }

    HiveAccumuloHelper getHelper() {
        return this.helper;
    }
}

