/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.bouncycastle.jsse.provider.PropertyUtils;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
abstract class FipsUtils {
    private static final boolean provAllowRSAKeyExchange = PropertyUtils.getBooleanSystemProperty("org.bouncycastle.jsse.fips.allowRSAKeyExchange", false);
    private static final Set<String> FIPS_CIPHERSUITES = FipsUtils.createFipsCipherSuites(false);
    private static final Set<String> FIPS_CIPHERSUITES_GCM12 = FipsUtils.createFipsCipherSuites(true);
    private static final Set<String> FIPS_PROTOCOLS = FipsUtils.createProtocols();

    FipsUtils() {
    }

    private static Set<String> createFipsCipherSuites(boolean includeGCM12) {
        HashSet<String> cs = new HashSet<String>();
        cs.add("TLS_AES_128_CCM_8_SHA256");
        cs.add("TLS_AES_128_CCM_SHA256");
        cs.add("TLS_AES_128_GCM_SHA256");
        cs.add("TLS_AES_256_GCM_SHA384");
        cs.add("TLS_DHE_DSS_WITH_AES_128_CBC_SHA");
        cs.add("TLS_DHE_DSS_WITH_AES_128_CBC_SHA256");
        cs.add("TLS_DHE_DSS_WITH_AES_256_CBC_SHA");
        cs.add("TLS_DHE_DSS_WITH_AES_256_CBC_SHA256");
        cs.add("TLS_DHE_RSA_WITH_AES_128_CBC_SHA");
        cs.add("TLS_DHE_RSA_WITH_AES_128_CBC_SHA256");
        cs.add("TLS_DHE_RSA_WITH_AES_128_CCM");
        cs.add("TLS_DHE_RSA_WITH_AES_128_CCM_8");
        cs.add("TLS_DHE_RSA_WITH_AES_256_CBC_SHA");
        cs.add("TLS_DHE_RSA_WITH_AES_256_CBC_SHA256");
        cs.add("TLS_DHE_RSA_WITH_AES_256_CCM");
        cs.add("TLS_DHE_RSA_WITH_AES_256_CCM_8");
        cs.add("TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA");
        cs.add("TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256");
        cs.add("TLS_ECDHE_ECDSA_WITH_AES_128_CCM");
        cs.add("TLS_ECDHE_ECDSA_WITH_AES_128_CCM_8");
        cs.add("TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA");
        cs.add("TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384");
        cs.add("TLS_ECDHE_ECDSA_WITH_AES_256_CCM");
        cs.add("TLS_ECDHE_ECDSA_WITH_AES_256_CCM_8");
        cs.add("TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA");
        cs.add("TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256");
        cs.add("TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA");
        cs.add("TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384");
        if (includeGCM12) {
            cs.add("TLS_DHE_DSS_WITH_AES_128_GCM_SHA256");
            cs.add("TLS_DHE_DSS_WITH_AES_256_GCM_SHA384");
            cs.add("TLS_DHE_RSA_WITH_AES_128_GCM_SHA256");
            cs.add("TLS_DHE_RSA_WITH_AES_256_GCM_SHA384");
            cs.add("TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256");
            cs.add("TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384");
            cs.add("TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256");
            cs.add("TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384");
        }
        if (provAllowRSAKeyExchange) {
            cs.add("TLS_RSA_WITH_AES_128_CBC_SHA");
            cs.add("TLS_RSA_WITH_AES_128_CBC_SHA256");
            cs.add("TLS_RSA_WITH_AES_128_CCM");
            cs.add("TLS_RSA_WITH_AES_128_CCM_8");
            cs.add("TLS_RSA_WITH_AES_256_CBC_SHA");
            cs.add("TLS_RSA_WITH_AES_256_CBC_SHA256");
            cs.add("TLS_RSA_WITH_AES_256_CCM");
            cs.add("TLS_RSA_WITH_AES_256_CCM_8");
            if (includeGCM12) {
                cs.add("TLS_RSA_WITH_AES_128_GCM_SHA256");
                cs.add("TLS_RSA_WITH_AES_256_GCM_SHA384");
            }
        }
        return Collections.unmodifiableSet(cs);
    }

    private static Set<String> createProtocols() {
        HashSet<String> ps = new HashSet<String>();
        ps.add("TLSv1");
        ps.add("TLSv1.1");
        ps.add("TLSv1.2");
        ps.add("TLSv1.3");
        return Collections.unmodifiableSet(ps);
    }

    private static Set<String> getFipsCipherSuites(boolean includeGCM12) {
        return includeGCM12 ? FIPS_CIPHERSUITES_GCM12 : FIPS_CIPHERSUITES;
    }

    static boolean isFipsCipherSuite(String cipherSuite, boolean includeGCM12) {
        return cipherSuite != null && FipsUtils.getFipsCipherSuites(includeGCM12).contains(cipherSuite);
    }

    static boolean isFipsNamedGroup(int namedGroup) {
        switch (namedGroup) {
            case 23: 
            case 24: 
            case 25: 
            case 256: 
            case 257: 
            case 258: 
            case 259: 
            case 260: 
            case 4587: 
            case 4589: {
                return true;
            }
        }
        return false;
    }

    static boolean isFipsProtocol(String protocol) {
        return protocol != null && FIPS_PROTOCOLS.contains(protocol);
    }

    static boolean isFipsSignatureScheme(int signatureScheme) {
        switch (signatureScheme) {
            case 513: 
            case 514: 
            case 515: 
            case 769: 
            case 770: 
            case 771: 
            case 1025: 
            case 1026: 
            case 1027: 
            case 1281: 
            case 1283: 
            case 1537: 
            case 1539: 
            case 2052: 
            case 2053: 
            case 2054: 
            case 2057: 
            case 2058: 
            case 2059: {
                return true;
            }
        }
        return false;
    }

    static void removeNonFipsCipherSuites(Collection<String> cipherSuites, boolean includeGCM12) {
        cipherSuites.retainAll(FipsUtils.getFipsCipherSuites(includeGCM12));
    }

    static void removeNonFipsProtocols(Collection<String> protocols) {
        protocols.retainAll(FIPS_PROTOCOLS);
    }
}

