/*
 * Decompiled with CFR 0.152.
 */
package org.ojai.util;

import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.ojai.Document;
import org.ojai.DocumentBuilder;
import org.ojai.DocumentReader;
import org.ojai.FieldPath;
import org.ojai.Value;
import org.ojai.annotation.API;
import org.ojai.json.impl.JsonUtils;
import org.ojai.types.ODate;
import org.ojai.types.OInterval;
import org.ojai.types.OTime;
import org.ojai.types.OTimestamp;
import org.ojai.util.impl.ReadOnlyDocument;

@API.Public
public class Documents {
    public static boolean equals(@API.Nullable Document d1, @API.Nullable Document d2) {
        if (d1 == d2) {
            return true;
        }
        if (d1 == null || d2 == null || d1.size() != d2.size()) {
            return false;
        }
        TreeMap keyValues = Maps.newTreeMap();
        for (Map.Entry e : d2) {
            keyValues.put(e.getKey(), e.getValue());
        }
        for (Map.Entry e : d1) {
            String k = (String)e.getKey();
            Value v = (Value)keyValues.get(k);
            if (v != null && ((Value)e.getValue()).equals(v)) continue;
            return false;
        }
        return true;
    }

    public static Document readOnly(Document src) {
        return new ReadOnlyDocument(src);
    }

    public static void writeReaderToBuilder(@API.NonNullable DocumentReader reader, @API.NonNullable DocumentBuilder builder) {
        JsonUtils.addToMap(reader, builder);
    }

    public static ByteBuffer getBinary(@API.NonNullable Document document, @API.NonNullable FieldPath fieldPath, @API.Nullable ByteBuffer defaultValue) {
        ByteBuffer docValue = document.getBinary(fieldPath);
        return docValue != null ? docValue : defaultValue;
    }

    public static ByteBuffer getBinary(@API.NonNullable Document document, @API.NonNullable String fieldPath, @API.Nullable ByteBuffer defaultValue) {
        return Documents.getBinary(document, FieldPath.parseFrom(fieldPath), defaultValue);
    }

    public static boolean getBoolean(@API.NonNullable Document document, @API.NonNullable FieldPath fieldPath, @API.Nullable boolean defaultValue) {
        Boolean docValue = document.getBooleanObj(fieldPath);
        return docValue != null ? docValue : defaultValue;
    }

    public static boolean getBoolean(@API.NonNullable Document document, @API.NonNullable String fieldPath, @API.Nullable boolean defaultValue) {
        return Documents.getBoolean(document, FieldPath.parseFrom(fieldPath), defaultValue);
    }

    public static byte getByte(@API.NonNullable Document document, @API.NonNullable FieldPath fieldPath, @API.Nullable byte defaultValue) {
        Byte docValue = document.getByteObj(fieldPath);
        return docValue != null ? docValue : defaultValue;
    }

    public static byte getByte(@API.NonNullable Document document, @API.NonNullable String fieldPath, byte defaultValue) {
        return Documents.getByte(document, FieldPath.parseFrom(fieldPath), defaultValue);
    }

    public static ODate getDate(@API.NonNullable Document document, @API.NonNullable FieldPath fieldPath, @API.Nullable ODate defaultValue) {
        ODate docValue = document.getDate(fieldPath);
        return docValue != null ? docValue : defaultValue;
    }

    public static ODate getDate(@API.NonNullable Document document, @API.NonNullable String fieldPath, @API.Nullable ODate defaultValue) {
        return Documents.getDate(document, FieldPath.parseFrom(fieldPath), defaultValue);
    }

    public static BigDecimal getDecimal(@API.NonNullable Document document, @API.NonNullable FieldPath fieldPath, @API.Nullable BigDecimal defaultValue) {
        BigDecimal docValue = document.getDecimal(fieldPath);
        return docValue != null ? docValue : defaultValue;
    }

    public static BigDecimal getDecimal(@API.NonNullable Document document, @API.NonNullable String fieldPath, @API.Nullable BigDecimal defaultValue) {
        return Documents.getDecimal(document, FieldPath.parseFrom(fieldPath), defaultValue);
    }

    public static double getDouble(@API.NonNullable Document document, @API.NonNullable FieldPath fieldPath, double defaultValue) {
        Double docValue = document.getDoubleObj(fieldPath);
        return docValue != null ? docValue : defaultValue;
    }

    public static double getDouble(@API.NonNullable Document document, @API.NonNullable String fieldPath, @API.Nullable double defaultValue) {
        return Documents.getDouble(document, FieldPath.parseFrom(fieldPath), defaultValue);
    }

    public static float getFloat(@API.NonNullable Document document, @API.NonNullable FieldPath fieldPath, float defaultValue) {
        Float docValue = document.getFloatObj(fieldPath);
        return docValue != null ? docValue.floatValue() : defaultValue;
    }

    public static float getFloat(@API.NonNullable Document document, @API.NonNullable String fieldPath, @API.Nullable float defaultValue) {
        return Documents.getFloat(document, FieldPath.parseFrom(fieldPath), defaultValue);
    }

    public static int getInt(@API.NonNullable Document document, @API.NonNullable FieldPath fieldPath, int defaultValue) {
        Integer docValue = document.getIntObj(fieldPath);
        return docValue != null ? docValue : defaultValue;
    }

    public static int getInt(@API.NonNullable Document document, @API.NonNullable String fieldPath, @API.Nullable int defaultValue) {
        return Documents.getInt(document, FieldPath.parseFrom(fieldPath), defaultValue);
    }

    public static OInterval getInterval(@API.NonNullable Document document, @API.NonNullable FieldPath fieldPath, @API.Nullable OInterval defaultValue) {
        OInterval docValue = document.getInterval(fieldPath);
        return docValue != null ? docValue : defaultValue;
    }

    public static OInterval getInterval(@API.NonNullable Document document, @API.NonNullable String fieldPath, @API.Nullable OInterval defaultValue) {
        return Documents.getInterval(document, FieldPath.parseFrom(fieldPath), defaultValue);
    }

    public static List<Object> getList(@API.NonNullable Document document, @API.NonNullable FieldPath fieldPath, @API.Nullable List<Object> defaultValue) {
        List<Object> docValue = document.getList(fieldPath);
        return docValue != null ? docValue : defaultValue;
    }

    public static List<Object> getList(@API.NonNullable Document document, @API.NonNullable String fieldPath, @API.Nullable List<Object> defaultValue) {
        return Documents.getList(document, FieldPath.parseFrom(fieldPath), defaultValue);
    }

    public static long getLong(@API.NonNullable Document document, @API.NonNullable FieldPath fieldPath, long defaultValue) {
        Long docValue = document.getLongObj(fieldPath);
        return docValue != null ? docValue : defaultValue;
    }

    public static long getLong(@API.NonNullable Document document, @API.NonNullable String fieldPath, long defaultValue) {
        return Documents.getLong(document, FieldPath.parseFrom(fieldPath), defaultValue);
    }

    public static Map<String, Object> getMap(@API.NonNullable Document document, @API.NonNullable FieldPath fieldPath, @API.Nullable Map<String, Object> defaultValue) {
        Map<String, Object> docValue = document.getMap(fieldPath);
        return docValue != null ? docValue : defaultValue;
    }

    public static Map<String, Object> getMap(@API.NonNullable Document document, @API.NonNullable String fieldPath, @API.Nullable Map<String, Object> defaultValue) {
        return Documents.getMap(document, FieldPath.parseFrom(fieldPath), defaultValue);
    }

    public static short getShort(@API.NonNullable Document document, @API.NonNullable FieldPath fieldPath, short defaultValue) {
        Short docValue = document.getShortObj(fieldPath);
        return docValue != null ? docValue : defaultValue;
    }

    public static short getShort(@API.NonNullable Document document, @API.NonNullable String fieldPath, short defaultValue) {
        return Documents.getShort(document, FieldPath.parseFrom(fieldPath), defaultValue);
    }

    public static String getString(@API.NonNullable Document document, @API.NonNullable FieldPath fieldPath, @API.Nullable String defaultValue) {
        String docValue = document.getString(fieldPath);
        return docValue != null ? docValue : defaultValue;
    }

    public static String getString(@API.NonNullable Document document, @API.NonNullable String fieldPath, @API.Nullable String defaultValue) {
        return Documents.getString(document, FieldPath.parseFrom(fieldPath), defaultValue);
    }

    public static OTime getTime(@API.NonNullable Document document, @API.NonNullable FieldPath fieldPath, @API.Nullable OTime defaultValue) {
        OTime docValue = document.getTime(fieldPath);
        return docValue != null ? docValue : defaultValue;
    }

    public static OTime getTime(@API.NonNullable Document document, @API.NonNullable String fieldPath, @API.Nullable OTime defaultValue) {
        return Documents.getTime(document, FieldPath.parseFrom(fieldPath), defaultValue);
    }

    public static OTimestamp getTimestamp(@API.NonNullable Document document, @API.NonNullable FieldPath fieldPath, @API.Nullable OTimestamp defaultValue) {
        OTimestamp docValue = document.getTimestamp(fieldPath);
        return docValue != null ? docValue : defaultValue;
    }

    public static OTimestamp getTimestamp(@API.NonNullable Document document, @API.NonNullable String fieldPath, @API.Nullable OTimestamp defaultValue) {
        return Documents.getTimestamp(document, FieldPath.parseFrom(fieldPath), defaultValue);
    }

    public static Value getValue(@API.NonNullable Document document, @API.NonNullable FieldPath fieldPath, @API.Nullable Value defaultValue) {
        Value docValue = document.getValue(fieldPath);
        return docValue != null ? docValue : defaultValue;
    }

    public static Value getValue(@API.NonNullable Document document, @API.NonNullable String fieldPath, @API.Nullable Value defaultValue) {
        return Documents.getValue(document, FieldPath.parseFrom(fieldPath), defaultValue);
    }
}

