/*
 * Decompiled with CFR 0.152.
 */
package org.ojai.store;

import com.google.common.base.Preconditions;
import java.util.ServiceLoader;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.regex.Pattern;
import org.ojai.Document;
import org.ojai.annotation.API;
import org.ojai.exceptions.OjaiException;
import org.ojai.json.Json;
import org.ojai.store.Connection;
import org.ojai.store.Driver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API.Public
@API.Factory
public final class DriverManager {
    public static final Pattern OJAI_PROTOCOL_PATTERN = Pattern.compile("ojai:[\\w\\-]+:.*");
    private static final Logger logger = LoggerFactory.getLogger(DriverManager.class);
    private static final CopyOnWriteArrayList<Driver> ojaiDrivers = new CopyOnWriteArrayList();

    public static Driver getDriver(@API.NonNullable String url) throws OjaiException {
        DriverManager.checkUrl(url);
        for (Driver driver : ojaiDrivers) {
            if (!driver.accepts(url)) continue;
            return driver;
        }
        throw new OjaiException(String.format("No registered driver found for url: '%s'", url));
    }

    public static Connection getConnection(@API.NonNullable String url) throws OjaiException {
        return DriverManager.getConnection(url, Json.newDocument());
    }

    public static Connection getConnection(@API.NonNullable String url, @API.NonNullable Document options) throws OjaiException {
        DriverManager.checkUrl(url);
        for (Driver driver : ojaiDrivers) {
            if (!driver.accepts(url)) continue;
            logger.debug("URL '{}' was accepted by driver '{}'.", (Object)url, (Object)driver.getName());
            return driver.connect(url, options);
        }
        throw new OjaiException(String.format("No registered driver found for url: '%s'", url));
    }

    @API.Internal
    public static synchronized void registerDriver(@API.NonNullable Driver driver) {
        Preconditions.checkNotNull((Object)driver);
        ojaiDrivers.addIfAbsent(driver);
    }

    private static void loadOjaiDrivers() {
        ServiceLoader<Driver> loadedDrivers = ServiceLoader.load(Driver.class);
        for (Driver driver : loadedDrivers) {
            logger.debug("Loaded driver '{}'.", (Object)driver.getClass().getName());
        }
    }

    private static void checkUrl(String url) {
        Preconditions.checkNotNull((Object)url);
        Preconditions.checkArgument((boolean)OJAI_PROTOCOL_PATTERN.matcher(url).matches(), (String)"Invalid OJAI connection URL `%s`. A valid OJAI url must be of the form \"ojai:<provider_name>:[optional_connection_parameters]\"", (Object)url);
    }

    static {
        DriverManager.loadOjaiDrivers();
    }
}

