/*
 * Decompiled with CFR 0.152.
 */
package org.ojai.beans.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.util.VersionUtil;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;
import org.ojai.annotation.API;
import org.ojai.types.ODate;
import org.ojai.types.OInterval;
import org.ojai.types.OTime;
import org.ojai.types.OTimestamp;

@API.Internal
public class JacksonHelper {
    public static final Version VERSION;
    public static final ObjectMapper MAPPER;

    static {
        MAPPER = new ObjectMapper();
        String version = JacksonHelper.class.getPackage().getImplementationVersion();
        String version_str = version == null ? "<unknown>" : version;
        VERSION = VersionUtil.parseVersion((String)version_str, (String)"org.ojai", (String)"core");
        SimpleModule module = new SimpleModule("OjaiSerializers", VERSION);
        ByteSerializer byteSerializer = new ByteSerializer();
        module.addSerializer(Byte.TYPE, (JsonSerializer)byteSerializer);
        module.addSerializer(Byte.class, (JsonSerializer)byteSerializer);
        module.addSerializer(OInterval.class, (JsonSerializer)new IntervalSerializer());
        module.addDeserializer(OInterval.class, (JsonDeserializer)new IntervalDeserializer());
        module.addSerializer(ODate.class, (JsonSerializer)new DateSerializer());
        module.addDeserializer(ODate.class, (JsonDeserializer)new DateDeserializer());
        module.addSerializer(OTime.class, (JsonSerializer)new TimeSerializer());
        module.addDeserializer(OTime.class, (JsonDeserializer)new TimeDeserializer());
        module.addSerializer(OTimestamp.class, (JsonSerializer)new TimestampSerializer());
        module.addDeserializer(OTimestamp.class, (JsonDeserializer)new TimestampDeserializer());
        MAPPER.registerModule((Module)module);
    }

    public static class TimestampDeserializer
    extends JsonDeserializer<OTimestamp> {
        public OTimestamp deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            return (OTimestamp)p.getEmbeddedObject();
        }
    }

    public static class TimestampSerializer
    extends JsonSerializer<OTimestamp> {
        public void serialize(OTimestamp value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeObject((Object)value);
        }
    }

    public static class TimeDeserializer
    extends JsonDeserializer<OTime> {
        public OTime deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            return (OTime)p.getEmbeddedObject();
        }
    }

    public static class TimeSerializer
    extends JsonSerializer<OTime> {
        public void serialize(OTime value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeObject((Object)value);
        }
    }

    public static class DateDeserializer
    extends JsonDeserializer<ODate> {
        public ODate deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            return (ODate)p.getEmbeddedObject();
        }
    }

    public static class DateSerializer
    extends JsonSerializer<ODate> {
        public void serialize(ODate value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeObject((Object)value);
        }
    }

    public static class IntervalDeserializer
    extends JsonDeserializer<OInterval> {
        public OInterval deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            return (OInterval)p.getEmbeddedObject();
        }
    }

    public static class IntervalSerializer
    extends JsonSerializer<OInterval> {
        public void serialize(OInterval value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeObject((Object)value);
        }
    }

    public static class ByteSerializer
    extends JsonSerializer<Byte> {
        public void serialize(Byte value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeObject((Object)value);
        }
    }
}

