/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.iterators;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.KeyValue;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;

public class IteratorAdapter
implements Iterator<Map.Entry<Key, Value>> {
    SortedKeyValueIterator<Key, Value> inner;

    public IteratorAdapter(SortedKeyValueIterator<Key, Value> inner) {
        this.inner = inner;
    }

    @Override
    public boolean hasNext() {
        return this.inner.hasTop();
    }

    @Override
    public Map.Entry<Key, Value> next() {
        try {
            KeyValue result = new KeyValue(new Key(this.inner.getTopKey()), new Value(this.inner.getTopValue()).get());
            this.inner.next();
            return result;
        }
        catch (IOException ex) {
            throw new NoSuchElementException();
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

