/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client.lexicoder;

import java.util.ArrayList;
import java.util.List;
import org.apache.accumulo.core.client.lexicoder.Lexicoder;
import org.apache.accumulo.core.client.lexicoder.impl.AbstractLexicoder;
import org.apache.accumulo.core.client.lexicoder.impl.ByteUtils;

public class ListLexicoder<LT>
extends AbstractLexicoder<List<LT>> {
    private Lexicoder<LT> lexicoder;

    public ListLexicoder(Lexicoder<LT> lexicoder) {
        this.lexicoder = lexicoder;
    }

    @Override
    public byte[] encode(List<LT> v) {
        byte[][] encElements = new byte[v.size()][];
        int index = 0;
        for (LT element : v) {
            encElements[index++] = ByteUtils.escape(this.lexicoder.encode(element));
        }
        return ByteUtils.concat(encElements);
    }

    @Override
    public List<LT> decode(byte[] b) {
        return (List)super.decode(b);
    }

    @Override
    protected List<LT> decodeUnchecked(byte[] b, int offset, int len) {
        byte[][] escapedElements = ByteUtils.split(b, offset, len);
        ArrayList ret = new ArrayList(escapedElements.length);
        for (byte[] escapedElement : escapedElements) {
            ret.add(this.lexicoder.decode(ByteUtils.unescape(escapedElement)));
        }
        return ret;
    }
}

