/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.streaming.mutate.client;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hive.hcatalog.common.HCatUtil;
import org.apache.hive.hcatalog.streaming.mutate.HiveConfFactory;
import org.apache.hive.hcatalog.streaming.mutate.UgiMetaStoreClientFactory;
import org.apache.hive.hcatalog.streaming.mutate.client.AcidTable;
import org.apache.hive.hcatalog.streaming.mutate.client.ClientException;
import org.apache.hive.hcatalog.streaming.mutate.client.MutatorClient;
import org.apache.hive.hcatalog.streaming.mutate.client.TableType;
import org.apache.hive.hcatalog.streaming.mutate.client.lock.LockFailureListener;

@Deprecated
public class MutatorClientBuilder {
    private final Map<String, AcidTable> tables = new HashMap<String, AcidTable>();
    private HiveConf configuration;
    private UserGroupInformation authenticatedUser;
    private String metaStoreUri;
    public LockFailureListener lockFailureListener;

    public MutatorClientBuilder configuration(HiveConf conf) {
        this.configuration = conf;
        return this;
    }

    public MutatorClientBuilder authenticatedUser(UserGroupInformation authenticatedUser) {
        this.authenticatedUser = authenticatedUser;
        return this;
    }

    public MutatorClientBuilder metaStoreUri(String metaStoreUri) {
        this.metaStoreUri = metaStoreUri;
        return this;
    }

    public MutatorClientBuilder lockFailureListener(LockFailureListener lockFailureListener) {
        this.lockFailureListener = lockFailureListener;
        return this;
    }

    public MutatorClientBuilder addSourceTable(String databaseName, String tableName) {
        this.addTable(databaseName, tableName, false, TableType.SOURCE);
        return this;
    }

    public MutatorClientBuilder addSinkTable(String databaseName, String tableName) {
        return this.addSinkTable(databaseName, tableName, false);
    }

    public MutatorClientBuilder addSinkTable(String databaseName, String tableName, boolean createPartitions) {
        this.addTable(databaseName, tableName, createPartitions, TableType.SINK);
        return this;
    }

    private void addTable(String databaseName, String tableName, boolean createPartitions, TableType tableType) {
        if (databaseName == null) {
            throw new IllegalArgumentException("Database cannot be null");
        }
        if (tableName == null) {
            throw new IllegalArgumentException("Table cannot be null");
        }
        String key = (databaseName + "." + tableName).toUpperCase();
        AcidTable previous = this.tables.get(key);
        if (previous != null) {
            if (tableType == TableType.SINK && previous.getTableType() != TableType.SINK) {
                this.tables.remove(key);
            } else {
                throw new IllegalArgumentException("Table has already been added: " + databaseName + "." + tableName);
            }
        }
        Table table = new Table();
        table.setDbName(databaseName);
        table.setTableName(tableName);
        this.tables.put(key, new AcidTable(databaseName, tableName, createPartitions, tableType));
    }

    public MutatorClient build() throws ClientException, MetaException {
        IMetaStoreClient metaStoreClient;
        String user = this.authenticatedUser == null ? System.getProperty("user.name") : this.authenticatedUser.getShortUserName();
        boolean secureMode = this.authenticatedUser == null ? false : this.authenticatedUser.hasKerberosCredentials();
        this.configuration = HiveConfFactory.newInstance((Configuration)this.configuration, this.getClass(), this.metaStoreUri);
        try {
            metaStoreClient = new UgiMetaStoreClientFactory(this.metaStoreUri, this.configuration, this.authenticatedUser, user, secureMode).newInstance(HCatUtil.getHiveMetastoreClient((HiveConf)this.configuration));
        }
        catch (IOException e) {
            throw new ClientException("Could not create meta store client.", e);
        }
        return new MutatorClient(metaStoreClient, this.configuration, this.lockFailureListener, user, this.tables.values());
    }
}

