/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.fieldmanager;

import java.util.Map;
import org.datanucleus.ExecutionContext;
import org.datanucleus.api.ApiAdapter;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.RelationType;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.store.fieldmanager.AbstractFieldManager;
import org.datanucleus.store.types.ContainerHandler;
import org.datanucleus.store.types.ElementContainerAdapter;
import org.datanucleus.store.types.ElementContainerHandler;
import org.datanucleus.store.types.MapContainerAdapter;
import org.datanucleus.store.types.TypeManager;

public class DeleteFieldManager
extends AbstractFieldManager {
    private final ObjectProvider op;
    private boolean manageRelationships = false;

    public DeleteFieldManager(ObjectProvider op) {
        this(op, false);
    }

    public DeleteFieldManager(ObjectProvider op, boolean manageRelationships) {
        this.op = op;
        this.manageRelationships = manageRelationships;
    }

    protected void processPersistable(Object pc) {
        ObjectProvider pcOP = this.op.getExecutionContext().findObjectProvider(pc);
        if (pcOP != null && (pcOP.isDeleting() || pcOP.becomingDeleted())) {
            return;
        }
        this.op.getExecutionContext().deleteObjectInternal(pc);
    }

    @Override
    public void storeObjectField(int fieldNumber, Object value) {
        ExecutionContext ec;
        AbstractMemberMetaData mmd;
        RelationType relationType;
        if (value != null && (relationType = (mmd = this.op.getClassMetaData().getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber)).getRelationType((ec = this.op.getExecutionContext()).getClassLoaderResolver())) != RelationType.NONE) {
            if (mmd.hasContainer()) {
                this.processContainer(fieldNumber, value, mmd, ec, relationType);
            } else {
                this.processSingleValue(value, mmd, ec, relationType);
            }
        }
    }

    private void processSingleValue(Object value, AbstractMemberMetaData mmd, ExecutionContext ec, RelationType relationType) {
        ObjectProvider valueOP;
        if (mmd.isDependent()) {
            this.processPersistable(value);
        } else if (this.manageRelationships && RelationType.isBidirectional(relationType) && !mmd.isEmbedded() && (valueOP = ec.findObjectProvider(value)) != null && !valueOP.getLifecycleState().isDeleted() && !valueOP.isDeleting()) {
            AbstractMemberMetaData relMmd = mmd.getRelatedMemberMetaData(ec.getClassLoaderResolver())[0];
            if (relationType == RelationType.ONE_TO_ONE_BI) {
                valueOP.replaceFieldMakeDirty(relMmd.getAbsoluteFieldNumber(), null);
                valueOP.flush();
            } else if (relationType == RelationType.MANY_TO_ONE_BI) {
                Object containerHandler;
                valueOP.loadField(relMmd.getAbsoluteFieldNumber());
                Object relValue = valueOP.provideField(relMmd.getAbsoluteFieldNumber());
                if (relValue != null && (containerHandler = ec.getTypeManager().getContainerHandler(relMmd.getType())) instanceof ElementContainerHandler) {
                    ElementContainerAdapter adapter = (ElementContainerAdapter)containerHandler.getAdapter((Object)relValue);
                    adapter.remove(this.op.getObject());
                }
            }
        }
    }

    private void processContainer(int fieldNumber, Object container, AbstractMemberMetaData mmd, ExecutionContext ec, RelationType relationType) {
        TypeManager typeManager = this.op.getExecutionContext().getTypeManager();
        Object containerHandler = typeManager.getContainerHandler(mmd.getType());
        if (mmd.hasMap()) {
            this.processMapContainer(fieldNumber, container, mmd, (ContainerHandler<Object, MapContainerAdapter<Object>>)containerHandler);
        } else {
            this.processElementContainer(fieldNumber, container, mmd, (ContainerHandler<Object, ElementContainerAdapter<Object>>)containerHandler, ec, relationType);
        }
    }

    private void processMapContainer(int fieldNumber, Object container, AbstractMemberMetaData mmd, ContainerHandler<Object, MapContainerAdapter<Object>> containerHandler) {
        block5: {
            boolean dependentValue;
            block6: {
                boolean dependentKey;
                block4: {
                    dependentKey = mmd.getMap().isDependentKey();
                    dependentValue = mmd.getMap().isDependentValue();
                    if (!dependentKey || !dependentValue) break block4;
                    ApiAdapter api = this.op.getExecutionContext().getApiAdapter();
                    for (Map.Entry<Object, Object> entry : containerHandler.getAdapter(container).entries()) {
                        Object value;
                        Object key = entry.getKey();
                        if (api.isPersistable(key)) {
                            this.processPersistable(key);
                        }
                        if (!api.isPersistable(value = entry.getValue())) continue;
                        this.processPersistable(key);
                    }
                    break block5;
                }
                if (!dependentKey) break block6;
                ApiAdapter api = this.op.getExecutionContext().getApiAdapter();
                for (Object key : containerHandler.getAdapter(container).keys()) {
                    if (!api.isPersistable(key)) continue;
                    this.processPersistable(key);
                }
                break block5;
            }
            if (!dependentValue) break block5;
            ApiAdapter api = this.op.getExecutionContext().getApiAdapter();
            for (Object value : containerHandler.getAdapter(container).values()) {
                if (!api.isPersistable(value)) continue;
                this.processPersistable(value);
            }
        }
    }

    private void processElementContainer(int fieldNumber, Object container, AbstractMemberMetaData mmd, ContainerHandler<Object, ElementContainerAdapter<Object>> containerHandler, ExecutionContext ec, RelationType relationType) {
        block3: {
            block2: {
                if (!mmd.isCascadeRemoveOrphans() && (mmd.getCollection() == null || !mmd.getCollection().isDependentElement()) && (mmd.getArray() == null || !mmd.getArray().isDependentElement())) break block2;
                ApiAdapter api = this.op.getExecutionContext().getApiAdapter();
                for (Object t : containerHandler.getAdapter(container)) {
                    if (!api.isPersistable(t)) continue;
                    this.processPersistable(t);
                }
                break block3;
            }
            if (!this.manageRelationships || relationType != RelationType.ONE_TO_MANY_BI || mmd.isEmbedded() || mmd.getCollection().isEmbeddedElement()) break block3;
            ApiAdapter api = this.op.getExecutionContext().getApiAdapter();
            for (Object t : containerHandler.getAdapter(container)) {
                ObjectProvider elementOP;
                if (!api.isPersistable(t) || (elementOP = ec.findObjectProvider(t)) == null || elementOP.getLifecycleState().isDeleted() || elementOP.isDeleting()) continue;
                AbstractMemberMetaData relMmd = mmd.getRelatedMemberMetaData(ec.getClassLoaderResolver())[0];
                elementOP.replaceFieldMakeDirty(relMmd.getAbsoluteFieldNumber(), null);
                elementOP.flush();
            }
        }
    }

    @Override
    public void storeBooleanField(int fieldNumber, boolean value) {
    }

    @Override
    public void storeByteField(int fieldNumber, byte value) {
    }

    @Override
    public void storeCharField(int fieldNumber, char value) {
    }

    @Override
    public void storeDoubleField(int fieldNumber, double value) {
    }

    @Override
    public void storeFloatField(int fieldNumber, float value) {
    }

    @Override
    public void storeIntField(int fieldNumber, int value) {
    }

    @Override
    public void storeLongField(int fieldNumber, long value) {
    }

    @Override
    public void storeShortField(int fieldNumber, short value) {
    }

    @Override
    public void storeStringField(int fieldNumber, String value) {
    }
}

