/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2.lazy.objectinspector;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.hive.serde2.avro.AvroLazyObjectInspector;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.LazyListObjectInspector;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.LazyMapObjectInspector;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.LazySimpleStructObjectInspector;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.LazyUnionObjectInspector;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive.LazyObjectInspectorParameters;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive.LazyObjectInspectorParametersImpl;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.io.Text;

public final class LazyObjectInspectorFactory {
    static ConcurrentHashMap<ArrayList<Object>, LazySimpleStructObjectInspector> cachedLazySimpleStructObjectInspector = new ConcurrentHashMap();
    static ConcurrentHashMap<ArrayList<Object>, LazyListObjectInspector> cachedLazySimpleListObjectInspector = new ConcurrentHashMap();
    static ConcurrentHashMap<ArrayList<Object>, LazyMapObjectInspector> cachedLazySimpleMapObjectInspector = new ConcurrentHashMap();
    static ConcurrentHashMap<List<Object>, LazyUnionObjectInspector> cachedLazyUnionObjectInspector = new ConcurrentHashMap();

    @Deprecated
    public static LazySimpleStructObjectInspector getLazySimpleStructObjectInspector(List<String> structFieldNames, List<ObjectInspector> structFieldObjectInspectors, byte separator, Text nullSequence, boolean lastColumnTakesRest, boolean escaped, byte escapeChar) {
        return LazyObjectInspectorFactory.getLazySimpleStructObjectInspector(structFieldNames, structFieldObjectInspectors, null, separator, nullSequence, lastColumnTakesRest, escaped, escapeChar, ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
    }

    @Deprecated
    public static LazySimpleStructObjectInspector getLazySimpleStructObjectInspector(List<String> structFieldNames, List<ObjectInspector> structFieldObjectInspectors, byte separator, Text nullSequence, boolean lastColumnTakesRest, boolean escaped, byte escapeChar, ObjectInspectorFactory.ObjectInspectorOptions option) {
        return LazyObjectInspectorFactory.getLazySimpleStructObjectInspector(structFieldNames, structFieldObjectInspectors, null, separator, nullSequence, lastColumnTakesRest, escaped, escapeChar, option);
    }

    @Deprecated
    public static LazySimpleStructObjectInspector getLazySimpleStructObjectInspector(List<String> structFieldNames, List<ObjectInspector> structFieldObjectInspectors, List<String> structFieldComments, byte separator, Text nullSequence, boolean lastColumnTakesRest, boolean escaped, byte escapeChar) {
        return LazyObjectInspectorFactory.getLazySimpleStructObjectInspector(structFieldNames, structFieldObjectInspectors, structFieldComments, separator, nullSequence, lastColumnTakesRest, escaped, escapeChar, ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
    }

    @Deprecated
    public static LazySimpleStructObjectInspector getLazySimpleStructObjectInspector(List<String> structFieldNames, List<ObjectInspector> structFieldObjectInspectors, List<String> structFieldComments, byte separator, Text nullSequence, boolean lastColumnTakesRest, boolean escaped, byte escapeChar, ObjectInspectorFactory.ObjectInspectorOptions option) {
        return LazyObjectInspectorFactory.getLazySimpleStructObjectInspector(structFieldNames, structFieldObjectInspectors, structFieldComments, separator, new LazyObjectInspectorParametersImpl(escaped, escapeChar, false, null, null, nullSequence, lastColumnTakesRest), option);
    }

    public static LazySimpleStructObjectInspector getLazySimpleStructObjectInspector(List<String> structFieldNames, List<ObjectInspector> structFieldObjectInspectors, List<String> structFieldComments, byte separator, LazyObjectInspectorParameters lazyParams, ObjectInspectorFactory.ObjectInspectorOptions option) {
        LazySimpleStructObjectInspector result;
        ArrayList<Object> signature = new ArrayList<Object>();
        signature.add(structFieldNames);
        signature.add(structFieldObjectInspectors);
        signature.add(separator);
        signature.add(lazyParams.getNullSequence().toString());
        signature.add(lazyParams.isLastColumnTakesRest());
        LazyObjectInspectorFactory.addCommonLazyParamsToSignature(lazyParams, signature);
        signature.add((Object)option);
        if (structFieldComments != null) {
            signature.add(structFieldComments);
        }
        if ((result = cachedLazySimpleStructObjectInspector.get(signature)) == null) {
            switch (option) {
                case JAVA: {
                    result = new LazySimpleStructObjectInspector(structFieldNames, structFieldObjectInspectors, structFieldComments, separator, lazyParams);
                    break;
                }
                case AVRO: {
                    result = new AvroLazyObjectInspector(structFieldNames, structFieldObjectInspectors, structFieldComments, separator, lazyParams);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Illegal ObjectInspector type [" + option + "]");
                }
            }
            LazySimpleStructObjectInspector prev = cachedLazySimpleStructObjectInspector.putIfAbsent(signature, result);
            if (prev != null) {
                result = prev;
            }
        }
        return result;
    }

    @Deprecated
    public static LazyListObjectInspector getLazySimpleListObjectInspector(ObjectInspector listElementObjectInspector, byte separator, Text nullSequence, boolean escaped, byte escapeChar) {
        return LazyObjectInspectorFactory.getLazySimpleListObjectInspector(listElementObjectInspector, separator, new LazyObjectInspectorParametersImpl(escaped, escapeChar, false, null, null, nullSequence));
    }

    public static LazyListObjectInspector getLazySimpleListObjectInspector(ObjectInspector listElementObjectInspector, byte separator, LazyObjectInspectorParameters lazyParams) {
        LazyListObjectInspector prev;
        ArrayList<Object> signature = new ArrayList<Object>();
        signature.add(listElementObjectInspector);
        signature.add(separator);
        signature.add(lazyParams.getNullSequence().toString());
        LazyObjectInspectorFactory.addCommonLazyParamsToSignature(lazyParams, signature);
        LazyListObjectInspector result = cachedLazySimpleListObjectInspector.get(signature);
        if (result == null && (prev = cachedLazySimpleListObjectInspector.putIfAbsent(signature, result = new LazyListObjectInspector(listElementObjectInspector, separator, lazyParams))) != null) {
            result = prev;
        }
        return result;
    }

    @Deprecated
    public static LazyMapObjectInspector getLazySimpleMapObjectInspector(ObjectInspector mapKeyObjectInspector, ObjectInspector mapValueObjectInspector, byte itemSeparator, byte keyValueSeparator, Text nullSequence, boolean escaped, byte escapeChar) {
        return LazyObjectInspectorFactory.getLazySimpleMapObjectInspector(mapKeyObjectInspector, mapValueObjectInspector, itemSeparator, keyValueSeparator, new LazyObjectInspectorParametersImpl(escaped, escapeChar, false, null, null, nullSequence));
    }

    public static LazyMapObjectInspector getLazySimpleMapObjectInspector(ObjectInspector mapKeyObjectInspector, ObjectInspector mapValueObjectInspector, byte itemSeparator, byte keyValueSeparator, LazyObjectInspectorParameters lazyParams) {
        LazyMapObjectInspector prev;
        ArrayList<Object> signature = new ArrayList<Object>();
        signature.add(mapKeyObjectInspector);
        signature.add(mapValueObjectInspector);
        signature.add(itemSeparator);
        signature.add(keyValueSeparator);
        signature.add(lazyParams.getNullSequence().toString());
        LazyObjectInspectorFactory.addCommonLazyParamsToSignature(lazyParams, signature);
        LazyMapObjectInspector result = cachedLazySimpleMapObjectInspector.get(signature);
        if (result == null && (prev = cachedLazySimpleMapObjectInspector.putIfAbsent(signature, result = new LazyMapObjectInspector(mapKeyObjectInspector, mapValueObjectInspector, itemSeparator, keyValueSeparator, lazyParams))) != null) {
            result = prev;
        }
        return result;
    }

    @Deprecated
    public static LazyUnionObjectInspector getLazyUnionObjectInspector(List<ObjectInspector> ois, byte separator, Text nullSequence, boolean escaped, byte escapeChar) {
        return LazyObjectInspectorFactory.getLazyUnionObjectInspector(ois, separator, new LazyObjectInspectorParametersImpl(escaped, escapeChar, false, null, null, nullSequence));
    }

    public static LazyUnionObjectInspector getLazyUnionObjectInspector(List<ObjectInspector> ois, byte separator, LazyObjectInspectorParameters lazyParams) {
        LazyUnionObjectInspector prev;
        ArrayList<Object> signature = new ArrayList<Object>();
        signature.add(ois);
        signature.add(separator);
        signature.add(lazyParams.getNullSequence().toString());
        LazyObjectInspectorFactory.addCommonLazyParamsToSignature(lazyParams, signature);
        LazyUnionObjectInspector result = cachedLazyUnionObjectInspector.get(signature);
        if (result == null && (prev = cachedLazyUnionObjectInspector.putIfAbsent(signature, result = new LazyUnionObjectInspector(ois, separator, lazyParams))) != null) {
            result = prev;
        }
        return result;
    }

    private LazyObjectInspectorFactory() {
    }

    private static void addCommonLazyParamsToSignature(LazyObjectInspectorParameters lazyParams, List<Object> signature) {
        signature.add(lazyParams.isEscaped());
        signature.add(lazyParams.getEscapeChar());
        signature.add(lazyParams.isExtendedBooleanLiteral());
        signature.add(lazyParams.getTimestampFormats());
    }
}

