/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.maprdb.json.shims;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import org.apache.hadoop.hive.maprdb.json.shims.MapRDbJsonException;
import org.ojai.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapRDBProxy {
    private static final Logger LOG = LoggerFactory.getLogger(MapRDBProxy.class);
    private static volatile Class<?> mapRDBClass;
    private static volatile Method mapRDMethod;

    private MapRDBProxy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void init() {
        if (mapRDBClass != null) return;
        Class<MapRDBProxy> clazz = MapRDBProxy.class;
        synchronized (MapRDBProxy.class) {
            if (mapRDBClass != null) return;
            try {
                mapRDBClass = Class.forName("com.mapr.db.MapRDB");
                mapRDMethod = mapRDBClass.getDeclaredMethod("newDocument", Map.class);
                if (!LOG.isDebugEnabled()) return;
                LOG.debug("init() => loaded MapR-DB class: {}, method: {}", (Object)mapRDBClass.getName(), (Object)mapRDMethod);
            }
            catch (ClassNotFoundException | NoSuchMethodException e) {
                throw new MapRDbJsonException("Can't load class: com.mapr.db.MapRDB Check classpath.");
            }
            return;
        }
    }

    public static Document newDocument(Map<String, Object> jsonMap) {
        try {
            MapRDBProxy.init();
            return (Document)mapRDMethod.invoke(null, jsonMap);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new MapRDbJsonException(e);
        }
    }
}

