
-- Populate NEXT_WRITE_ID for each Transactional table and set next write ID same as next txn ID
INSERT INTO NEXT_WRITE_ID (NWI_DATABASE, NWI_TABLE, NWI_NEXT)
    SELECT * FROM
        (SELECT DB.NAME, TBL_INFO.TBL_NAME FROM DBS DB,
            (SELECT TBL.DB_ID, TBL.TBL_NAME FROM TBLS TBL,
                (SELECT TBL_ID FROM TABLE_PARAMS WHERE PARAM_KEY='transactional' AND CAST(PARAM_VALUE AS VARCHAR(128))='true') TBL_PARAM
            WHERE TBL.TBL_ID=TBL_PARAM.TBL_ID) TBL_INFO
        where DB.DB_ID=TBL_INFO.DB_ID) DB_TBL_NAME,
        (SELECT NTXN_NEXT FROM NEXT_TXN_ID) NEXT_TXN_ID;

-- Populate TXN_TO_WRITE_ID for each aborted/open txns and set write ID equal to txn ID
INSERT INTO TXN_TO_WRITE_ID (T2W_DATABASE, T2W_TABLE, T2W_TXNID, T2W_WRITEID)
    SELECT * FROM
        (SELECT DB.NAME, TBL_INFO.TBL_NAME FROM DBS DB,
            (SELECT TBL.DB_ID, TBL.TBL_NAME FROM TBLS TBL,
                (SELECT TBL_ID FROM TABLE_PARAMS WHERE PARAM_KEY='transactional' AND CAST(PARAM_VALUE AS VARCHAR(128))='true') TBL_PARAM
            WHERE TBL.TBL_ID=TBL_PARAM.TBL_ID) TBL_INFO
        where DB.DB_ID=TBL_INFO.DB_ID) DB_TBL_NAME,
        (SELECT TXN_ID, TXN_ID as WRITE_ID FROM TXNS) TXN_INFO;

-- Update TXN_COMPONENTS and COMPLETED_TXN_COMPONENTS for write ID which is same as txn ID
UPDATE TXN_COMPONENTS SET TC_WRITEID = TC_TXNID;
UPDATE COMPLETED_TXN_COMPONENTS SET CTC_WRITEID = CTC_TXNID;
