/*
 * Decompiled with CFR 0.152.
 */
package org.apache.orc.tools.convert;

import com.opencsv.CSVReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.sql.Timestamp;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DecimalColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.StructColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.TimestampColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.orc.RecordReader;
import org.apache.orc.TypeDescription;
import org.threeten.bp.LocalDateTime;
import org.threeten.bp.ZoneId;
import org.threeten.bp.ZonedDateTime;
import org.threeten.bp.format.DateTimeFormatter;
import org.threeten.bp.temporal.TemporalAccessor;
import org.threeten.bp.temporal.TemporalQuery;

public class CsvReader
implements RecordReader {
    private long rowNumber = 0L;
    private final Converter converter;
    private final int columns;
    private final CSVReader reader;
    private final String nullString;
    private final FSDataInputStream underlying;
    private final long totalSize;
    private final DateTimeFormatter dateTimeFormatter;

    public CsvReader(Reader reader, FSDataInputStream input, long size, TypeDescription schema, char separatorChar, char quoteChar, char escapeChar, int headerLines, String nullString, String timestampFormat) {
        this.underlying = input;
        this.reader = new CSVReader(reader, separatorChar, quoteChar, escapeChar, headerLines);
        this.nullString = nullString;
        this.totalSize = size;
        IntWritable nextColumn = new IntWritable(0);
        this.converter = this.buildConverter(nextColumn, schema);
        this.columns = nextColumn.get();
        this.dateTimeFormatter = DateTimeFormatter.ofPattern((String)timestampFormat);
    }

    public boolean nextBatch(VectorizedRowBatch batch) throws IOException {
        String[] nextLine;
        batch.reset();
        int BATCH_SIZE = batch.getMaxSize();
        while ((nextLine = this.reader.readNext()) != null) {
            ++this.rowNumber;
            if (!(nextLine.length == this.columns || nextLine.length == this.columns + 1 && "".equals(nextLine[this.columns]))) {
                throw new IllegalArgumentException("Too many columns on line " + this.rowNumber + ". Expected " + this.columns + ", but got " + nextLine.length + ".");
            }
            this.converter.convert(nextLine, batch, batch.size++);
            if (batch.size != BATCH_SIZE) continue;
        }
        return batch.size != 0;
    }

    public long getRowNumber() throws IOException {
        return this.rowNumber;
    }

    public float getProgress() throws IOException {
        long pos = this.underlying.getPos();
        return this.totalSize != 0L && pos < this.totalSize ? (float)pos / (float)this.totalSize : 1.0f;
    }

    public void close() throws IOException {
        this.reader.close();
    }

    public void seekToRow(long rowCount) throws IOException {
        throw new UnsupportedOperationException("Seeking not supported");
    }

    Converter buildConverter(IntWritable startOffset, TypeDescription schema) {
        switch (schema.getCategory()) {
            case BOOLEAN: {
                return new BooleanConverter(startOffset);
            }
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: {
                return new LongConverter(startOffset);
            }
            case FLOAT: 
            case DOUBLE: {
                return new DoubleConverter(startOffset);
            }
            case DECIMAL: {
                return new DecimalConverter(startOffset);
            }
            case BINARY: 
            case STRING: 
            case CHAR: 
            case VARCHAR: {
                return new BytesConverter(startOffset);
            }
            case TIMESTAMP: {
                return new TimestampConverter(startOffset);
            }
            case STRUCT: {
                return new StructConverter(startOffset, schema);
            }
        }
        throw new IllegalArgumentException("Unhandled type " + schema);
    }

    class StructConverter
    implements Converter {
        final Converter[] children;

        StructConverter(IntWritable offset, TypeDescription schema) {
            this.children = new Converter[schema.getChildren().size()];
            int c = 0;
            for (TypeDescription child : schema.getChildren()) {
                this.children[c++] = CsvReader.this.buildConverter(offset, child);
            }
        }

        @Override
        public void convert(String[] values, VectorizedRowBatch batch, int row) {
            for (int c = 0; c < this.children.length; ++c) {
                this.children[c].convert(values, batch.cols[c], row);
            }
        }

        @Override
        public void convert(String[] values, ColumnVector column, int row) {
            StructColumnVector cv = (StructColumnVector)column;
            for (int c = 0; c < this.children.length; ++c) {
                this.children[c].convert(values, cv.fields[c], row);
            }
        }
    }

    class TimestampConverter
    extends ConverterImpl {
        TimestampConverter(IntWritable offset) {
            super(offset);
        }

        @Override
        public void convert(String[] values, ColumnVector column, int row) {
            if (values[this.offset] == null || CsvReader.this.nullString.equals(values[this.offset])) {
                column.noNulls = false;
                column.isNull[row] = true;
            } else {
                TimestampColumnVector vector = (TimestampColumnVector)column;
                TemporalAccessor temporalAccessor = CsvReader.this.dateTimeFormatter.parseBest((CharSequence)values[this.offset], new TemporalQuery[]{ZonedDateTime.FROM, LocalDateTime.FROM});
                if (temporalAccessor instanceof ZonedDateTime) {
                    ZonedDateTime zonedDateTime = (ZonedDateTime)temporalAccessor;
                    Timestamp timestamp = new Timestamp(zonedDateTime.toEpochSecond() * 1000L);
                    timestamp.setNanos(zonedDateTime.getNano());
                    vector.set(row, timestamp);
                } else if (temporalAccessor instanceof LocalDateTime) {
                    ZonedDateTime tz = ((LocalDateTime)temporalAccessor).atZone(ZoneId.systemDefault());
                    Timestamp timestamp = new Timestamp(tz.toEpochSecond() * 1000L);
                    timestamp.setNanos(tz.getNano());
                    vector.set(row, timestamp);
                } else {
                    column.noNulls = false;
                    column.isNull[row] = true;
                }
            }
        }
    }

    class BytesConverter
    extends ConverterImpl {
        BytesConverter(IntWritable offset) {
            super(offset);
        }

        @Override
        public void convert(String[] values, ColumnVector column, int row) {
            if (values[this.offset] == null || CsvReader.this.nullString.equals(values[this.offset])) {
                column.noNulls = false;
                column.isNull[row] = true;
            } else {
                byte[] value = values[this.offset].getBytes(StandardCharsets.UTF_8);
                ((BytesColumnVector)column).setRef(row, value, 0, value.length);
            }
        }
    }

    class DecimalConverter
    extends ConverterImpl {
        DecimalConverter(IntWritable offset) {
            super(offset);
        }

        @Override
        public void convert(String[] values, ColumnVector column, int row) {
            if (values[this.offset] == null || CsvReader.this.nullString.equals(values[this.offset])) {
                column.noNulls = false;
                column.isNull[row] = true;
            } else {
                ((DecimalColumnVector)column).vector[row].set(new HiveDecimalWritable(values[this.offset]));
            }
        }
    }

    class DoubleConverter
    extends ConverterImpl {
        DoubleConverter(IntWritable offset) {
            super(offset);
        }

        @Override
        public void convert(String[] values, ColumnVector column, int row) {
            if (values[this.offset] == null || CsvReader.this.nullString.equals(values[this.offset])) {
                column.noNulls = false;
                column.isNull[row] = true;
            } else {
                ((DoubleColumnVector)column).vector[row] = Double.parseDouble(values[this.offset]);
            }
        }
    }

    class LongConverter
    extends ConverterImpl {
        LongConverter(IntWritable offset) {
            super(offset);
        }

        @Override
        public void convert(String[] values, ColumnVector column, int row) {
            if (values[this.offset] == null || CsvReader.this.nullString.equals(values[this.offset])) {
                column.noNulls = false;
                column.isNull[row] = true;
            } else {
                ((LongColumnVector)column).vector[row] = Long.parseLong(values[this.offset]);
            }
        }
    }

    class BooleanConverter
    extends ConverterImpl {
        BooleanConverter(IntWritable offset) {
            super(offset);
        }

        @Override
        public void convert(String[] values, ColumnVector column, int row) {
            if (values[this.offset] == null || CsvReader.this.nullString.equals(values[this.offset])) {
                column.noNulls = false;
                column.isNull[row] = true;
            } else {
                ((LongColumnVector)column).vector[row] = values[this.offset].equalsIgnoreCase("true") || values[this.offset].equalsIgnoreCase("t") || values[this.offset].equals("1") ? 1L : 0L;
            }
        }
    }

    abstract class ConverterImpl
    implements Converter {
        final int offset;

        ConverterImpl(IntWritable offset) {
            this.offset = offset.get();
            offset.set(this.offset + 1);
        }

        @Override
        public void convert(String[] values, VectorizedRowBatch batch, int row) {
            this.convert(values, batch.cols[0], row);
        }
    }

    static interface Converter {
        public void convert(String[] var1, VectorizedRowBatch var2, int var3);

        public void convert(String[] var1, ColumnVector var2, int var3);
    }
}

