/*
 * Decompiled with CFR 0.152.
 */
package io.druid.server.http;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.metamx.common.MapUtils;
import com.metamx.common.Pair;
import com.metamx.common.guava.Comparators;
import com.metamx.common.guava.FunctionalIterable;
import com.metamx.common.logger.Logger;
import com.sun.jersey.spi.container.ResourceFilters;
import io.druid.client.CoordinatorServerView;
import io.druid.client.DruidDataSource;
import io.druid.client.DruidServer;
import io.druid.client.ImmutableSegmentLoadInfo;
import io.druid.client.SegmentLoadInfo;
import io.druid.client.indexing.IndexingServiceClient;
import io.druid.metadata.MetadataSegmentManager;
import io.druid.query.DataSource;
import io.druid.query.TableDataSource;
import io.druid.server.http.InventoryViewUtils;
import io.druid.server.http.security.DatasourceResourceFilter;
import io.druid.server.security.AuthConfig;
import io.druid.server.security.AuthorizationInfo;
import io.druid.timeline.DataSegment;
import io.druid.timeline.TimelineObjectHolder;
import io.druid.timeline.VersionedIntervalTimeline;
import io.druid.timeline.partition.PartitionChunk;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInterval;

@Path(value="/druid/coordinator/v1/datasources")
public class DatasourcesResource {
    private static final Logger log = new Logger(DatasourcesResource.class);
    private final CoordinatorServerView serverInventoryView;
    private final MetadataSegmentManager databaseSegmentManager;
    private final IndexingServiceClient indexingServiceClient;
    private final AuthConfig authConfig;

    @Inject
    public DatasourcesResource(CoordinatorServerView serverInventoryView, MetadataSegmentManager databaseSegmentManager, @Nullable IndexingServiceClient indexingServiceClient, AuthConfig authConfig) {
        this.serverInventoryView = serverInventoryView;
        this.databaseSegmentManager = databaseSegmentManager;
        this.indexingServiceClient = indexingServiceClient;
        this.authConfig = authConfig;
    }

    @GET
    @Produces(value={"application/json"})
    public Response getQueryableDataSources(@QueryParam(value="full") String full, @QueryParam(value="simple") String simple, @Context HttpServletRequest req) {
        Set<DruidDataSource> datasources;
        Response.ResponseBuilder builder = Response.ok();
        Set<DruidDataSource> set = datasources = this.authConfig.isEnabled() ? InventoryViewUtils.getSecuredDataSources(this.serverInventoryView, (AuthorizationInfo)req.getAttribute("Druid-Auth-Token")) : InventoryViewUtils.getDataSources(this.serverInventoryView);
        if (full != null) {
            return builder.entity(datasources).build();
        }
        if (simple != null) {
            return builder.entity((Object)Lists.newArrayList((Iterable)Iterables.transform(datasources, (Function)new Function<DruidDataSource, Map<String, Object>>(){

                public Map<String, Object> apply(DruidDataSource dataSource) {
                    return DatasourcesResource.this.makeSimpleDatasource(dataSource);
                }
            }))).build();
        }
        return builder.entity((Object)Lists.newArrayList((Iterable)Iterables.transform(datasources, (Function)new Function<DruidDataSource, String>(){

            public String apply(DruidDataSource dataSource) {
                return dataSource.getName();
            }
        }))).build();
    }

    @GET
    @Path(value="/{dataSourceName}")
    @Produces(value={"application/json"})
    @ResourceFilters(value={DatasourceResourceFilter.class})
    public Response getTheDataSource(@PathParam(value="dataSourceName") String dataSourceName, @QueryParam(value="full") String full) {
        DruidDataSource dataSource = this.getDataSource(dataSourceName);
        if (dataSource == null) {
            return Response.noContent().build();
        }
        if (full != null) {
            return Response.ok((Object)dataSource).build();
        }
        return Response.ok(this.getSimpleDatasource(dataSourceName)).build();
    }

    @POST
    @Path(value="/{dataSourceName}")
    @Consumes(value={"application/json"})
    @ResourceFilters(value={DatasourceResourceFilter.class})
    public Response enableDataSource(@PathParam(value="dataSourceName") String dataSourceName) {
        if (!this.databaseSegmentManager.enableDatasource(dataSourceName)) {
            return Response.noContent().build();
        }
        return Response.ok().build();
    }

    @DELETE
    @Deprecated
    @Path(value="/{dataSourceName}")
    @ResourceFilters(value={DatasourceResourceFilter.class})
    @Produces(value={"application/json"})
    public Response deleteDataSource(@PathParam(value="dataSourceName") String dataSourceName, @QueryParam(value="kill") String kill, @QueryParam(value="interval") String interval) {
        if (this.indexingServiceClient == null) {
            return Response.ok((Object)ImmutableMap.of((Object)"error", (Object)"no indexing service found")).build();
        }
        if (kill != null && Boolean.valueOf(kill).booleanValue()) {
            try {
                this.indexingServiceClient.killSegments(dataSourceName, new Interval((Object)interval));
            }
            catch (IllegalArgumentException e) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ImmutableMap.of((Object)"error", (Object)"Exception occurred. Probably the interval is invalid", (Object)"message", (Object)e.toString())).build();
            }
            catch (Exception e) {
                return Response.serverError().entity((Object)ImmutableMap.of((Object)"error", (Object)"Exception occurred. Are you sure you have an indexing service?", (Object)"message", (Object)e.toString())).build();
            }
        } else if (!this.databaseSegmentManager.removeDatasource(dataSourceName)) {
            return Response.noContent().build();
        }
        return Response.ok().build();
    }

    @DELETE
    @Path(value="/{dataSourceName}/intervals/{interval}")
    @Produces(value={"application/json"})
    public Response deleteDataSourceSpecificInterval(@PathParam(value="dataSourceName") String dataSourceName, @PathParam(value="interval") String interval) {
        if (this.indexingServiceClient == null) {
            return Response.ok((Object)ImmutableMap.of((Object)"error", (Object)"no indexing service found")).build();
        }
        Interval theInterval = new Interval((Object)interval.replace("_", "/"));
        try {
            this.indexingServiceClient.killSegments(dataSourceName, new Interval((Object)theInterval));
        }
        catch (Exception e) {
            return Response.serverError().entity((Object)ImmutableMap.of((Object)"error", (Object)"Exception occurred. Are you sure you have an indexing service?", (Object)"message", (Object)e.toString())).build();
        }
        return Response.ok().build();
    }

    @GET
    @Path(value="/{dataSourceName}/intervals")
    @Produces(value={"application/json"})
    @ResourceFilters(value={DatasourceResourceFilter.class})
    public Response getSegmentDataSourceIntervals(@PathParam(value="dataSourceName") String dataSourceName, @QueryParam(value="simple") String simple, @QueryParam(value="full") String full) {
        DruidDataSource dataSource = this.getDataSource(dataSourceName);
        if (dataSource == null) {
            return Response.noContent().build();
        }
        Comparator comparator = Comparators.inverse((Comparator)Comparators.intervalsByStartThenEnd());
        if (full != null) {
            TreeMap retVal = Maps.newTreeMap((Comparator)comparator);
            for (DataSegment dataSegment : dataSource.getSegments()) {
                Map segments = (Map)retVal.get(dataSegment.getInterval());
                if (segments == null) {
                    segments = Maps.newHashMap();
                    retVal.put(dataSegment.getInterval(), segments);
                }
                Pair<DataSegment, Set<String>> val = this.getSegment(dataSegment.getIdentifier());
                segments.put(dataSegment.getIdentifier(), ImmutableMap.of((Object)"metadata", (Object)val.lhs, (Object)"servers", (Object)val.rhs));
            }
            return Response.ok((Object)retVal).build();
        }
        if (simple != null) {
            TreeMap retVal = Maps.newTreeMap((Comparator)comparator);
            for (DataSegment dataSegment : dataSource.getSegments()) {
                Map properties = (Map)retVal.get(dataSegment.getInterval());
                if (properties == null) {
                    properties = Maps.newHashMap();
                    properties.put("size", dataSegment.getSize());
                    properties.put("count", 1);
                    retVal.put(dataSegment.getInterval(), properties);
                    continue;
                }
                properties.put("size", MapUtils.getLong((Map)properties, (String)"size", (Long)0L) + dataSegment.getSize());
                properties.put("count", MapUtils.getInt((Map)properties, (String)"count", (Integer)0) + 1);
            }
            return Response.ok((Object)retVal).build();
        }
        TreeSet intervals = Sets.newTreeSet((Comparator)comparator);
        for (DataSegment dataSegment : dataSource.getSegments()) {
            intervals.add(dataSegment.getInterval());
        }
        return Response.ok((Object)intervals).build();
    }

    @GET
    @Path(value="/{dataSourceName}/intervals/{interval}")
    @Produces(value={"application/json"})
    @ResourceFilters(value={DatasourceResourceFilter.class})
    public Response getSegmentDataSourceSpecificInterval(@PathParam(value="dataSourceName") String dataSourceName, @PathParam(value="interval") String interval, @QueryParam(value="simple") String simple, @QueryParam(value="full") String full) {
        DruidDataSource dataSource = this.getDataSource(dataSourceName);
        Interval theInterval = new Interval((Object)interval.replace("_", "/"));
        if (dataSource == null) {
            return Response.noContent().build();
        }
        Comparator comparator = Comparators.inverse((Comparator)Comparators.intervalsByStartThenEnd());
        if (full != null) {
            TreeMap retVal = Maps.newTreeMap((Comparator)comparator);
            for (DataSegment dataSegment : dataSource.getSegments()) {
                if (!theInterval.contains((ReadableInterval)dataSegment.getInterval())) continue;
                Map segments = (Map)retVal.get(dataSegment.getInterval());
                if (segments == null) {
                    segments = Maps.newHashMap();
                    retVal.put(dataSegment.getInterval(), segments);
                }
                Pair<DataSegment, Set<String>> val = this.getSegment(dataSegment.getIdentifier());
                segments.put(dataSegment.getIdentifier(), ImmutableMap.of((Object)"metadata", (Object)val.lhs, (Object)"servers", (Object)val.rhs));
            }
            return Response.ok((Object)retVal).build();
        }
        if (simple != null) {
            HashMap retVal = Maps.newHashMap();
            for (DataSegment dataSegment : dataSource.getSegments()) {
                if (!theInterval.contains((ReadableInterval)dataSegment.getInterval())) continue;
                Map properties = (Map)retVal.get(dataSegment.getInterval());
                if (properties == null) {
                    properties = Maps.newHashMap();
                    properties.put("size", dataSegment.getSize());
                    properties.put("count", 1);
                    retVal.put(dataSegment.getInterval(), properties);
                    continue;
                }
                properties.put("size", MapUtils.getLong((Map)properties, (String)"size", (Long)0L) + dataSegment.getSize());
                properties.put("count", MapUtils.getInt((Map)properties, (String)"count", (Integer)0) + 1);
            }
            return Response.ok((Object)retVal).build();
        }
        TreeSet retVal = Sets.newTreeSet((Comparator)Comparators.inverse((Comparator)String.CASE_INSENSITIVE_ORDER));
        for (DataSegment dataSegment : dataSource.getSegments()) {
            if (!theInterval.contains((ReadableInterval)dataSegment.getInterval())) continue;
            retVal.add(dataSegment.getIdentifier());
        }
        return Response.ok((Object)retVal).build();
    }

    @GET
    @Path(value="/{dataSourceName}/segments")
    @Produces(value={"application/json"})
    @ResourceFilters(value={DatasourceResourceFilter.class})
    public Response getSegmentDataSourceSegments(@PathParam(value="dataSourceName") String dataSourceName, @QueryParam(value="full") String full) {
        DruidDataSource dataSource = this.getDataSource(dataSourceName);
        if (dataSource == null) {
            return Response.noContent().build();
        }
        Response.ResponseBuilder builder = Response.ok();
        if (full != null) {
            return builder.entity(dataSource.getSegments()).build();
        }
        return builder.entity((Object)Iterables.transform(dataSource.getSegments(), (Function)new Function<DataSegment, Object>(){

            public Object apply(DataSegment segment) {
                return segment.getIdentifier();
            }
        })).build();
    }

    @GET
    @Path(value="/{dataSourceName}/segments/{segmentId}")
    @Produces(value={"application/json"})
    @ResourceFilters(value={DatasourceResourceFilter.class})
    public Response getSegmentDataSourceSegment(@PathParam(value="dataSourceName") String dataSourceName, @PathParam(value="segmentId") String segmentId) {
        DruidDataSource dataSource = this.getDataSource(dataSourceName);
        if (dataSource == null) {
            return Response.noContent().build();
        }
        Pair<DataSegment, Set<String>> retVal = this.getSegment(segmentId);
        if (retVal != null) {
            return Response.ok((Object)ImmutableMap.of((Object)"metadata", (Object)retVal.lhs, (Object)"servers", (Object)retVal.rhs)).build();
        }
        return Response.noContent().build();
    }

    @DELETE
    @Path(value="/{dataSourceName}/segments/{segmentId}")
    @ResourceFilters(value={DatasourceResourceFilter.class})
    public Response deleteDatasourceSegment(@PathParam(value="dataSourceName") String dataSourceName, @PathParam(value="segmentId") String segmentId) {
        if (!this.databaseSegmentManager.removeSegment(dataSourceName, segmentId)) {
            return Response.noContent().build();
        }
        return Response.ok().build();
    }

    @POST
    @Path(value="/{dataSourceName}/segments/{segmentId}")
    @Consumes(value={"application/json"})
    @ResourceFilters(value={DatasourceResourceFilter.class})
    public Response enableDatasourceSegment(@PathParam(value="dataSourceName") String dataSourceName, @PathParam(value="segmentId") String segmentId) {
        if (!this.databaseSegmentManager.enableSegment(segmentId)) {
            return Response.noContent().build();
        }
        return Response.ok().build();
    }

    @GET
    @Path(value="/{dataSourceName}/tiers")
    @Produces(value={"application/json"})
    @ResourceFilters(value={DatasourceResourceFilter.class})
    public Response getSegmentDataSourceTiers(@PathParam(value="dataSourceName") String dataSourceName) {
        HashSet retVal = Sets.newHashSet();
        for (DruidServer druidServer : this.serverInventoryView.getInventory()) {
            if (druidServer.getDataSource(dataSourceName) == null) continue;
            retVal.add(druidServer.getTier());
        }
        return Response.ok((Object)retVal).build();
    }

    private DruidDataSource getDataSource(final String dataSourceName) {
        Iterable dataSources = Iterables.concat((Iterable[])new Iterable[]{Iterables.transform(this.serverInventoryView.getInventory(), (Function)new Function<DruidServer, DruidDataSource>(){

            public DruidDataSource apply(DruidServer input) {
                return input.getDataSource(dataSourceName);
            }
        })});
        ArrayList validDataSources = Lists.newArrayList();
        for (DruidDataSource dataSource : dataSources) {
            if (dataSource == null) continue;
            validDataSources.add(dataSource);
        }
        if (validDataSources.isEmpty()) {
            return null;
        }
        HashMap segmentMap = Maps.newHashMap();
        for (DruidDataSource dataSource : validDataSources) {
            if (dataSource == null) continue;
            Set<DataSegment> segments = dataSource.getSegments();
            for (DataSegment segment : segments) {
                segmentMap.put(segment.getIdentifier(), segment);
            }
        }
        return new DruidDataSource(dataSourceName, (Map<String, String>)ImmutableMap.of()).addSegments(segmentMap);
    }

    private Pair<DataSegment, Set<String>> getSegment(String segmentId) {
        DataSegment theSegment = null;
        HashSet servers = Sets.newHashSet();
        for (DruidServer druidServer : this.serverInventoryView.getInventory()) {
            DataSegment currSegment = druidServer.getSegments().get(segmentId);
            if (currSegment == null) continue;
            theSegment = currSegment;
            servers.add(druidServer.getHost());
        }
        if (theSegment == null) {
            return null;
        }
        return new Pair(theSegment, (Object)servers);
    }

    private Map<String, Object> makeSimpleDatasource(DruidDataSource input) {
        return new ImmutableMap.Builder().put((Object)"name", (Object)input.getName()).put((Object)"properties", this.getSimpleDatasource(input.getName())).build();
    }

    private Map<String, Map<String, Object>> getSimpleDatasource(String dataSourceName) {
        HashMap tiers = Maps.newHashMap();
        HashMap segments = Maps.newHashMap();
        ImmutableMap retVal = ImmutableMap.of((Object)"tiers", (Object)tiers, (Object)"segments", (Object)segments);
        HashSet totalDistinctSegments = Sets.newHashSet();
        HashMap tierDistinctSegments = Maps.newHashMap();
        long totalSegmentSize = 0L;
        long minTime = Long.MAX_VALUE;
        long maxTime = Long.MIN_VALUE;
        for (DruidServer druidServer : this.serverInventoryView.getInventory()) {
            DruidDataSource druidDataSource = druidServer.getDataSource(dataSourceName);
            String tier = druidServer.getTier();
            if (druidDataSource == null) continue;
            if (!tierDistinctSegments.containsKey(tier)) {
                tierDistinctSegments.put(tier, Sets.newHashSet());
            }
            long dataSourceSegmentSize = 0L;
            for (DataSegment dataSegment : druidDataSource.getSegments()) {
                if (!((HashSet)tierDistinctSegments.get(tier)).contains(dataSegment.getIdentifier())) {
                    dataSourceSegmentSize += dataSegment.getSize();
                    ((HashSet)tierDistinctSegments.get(tier)).add(dataSegment.getIdentifier());
                }
                if (totalDistinctSegments.contains(dataSegment.getIdentifier())) continue;
                totalSegmentSize += dataSegment.getSize();
                totalDistinctSegments.add(dataSegment.getIdentifier());
                if (dataSegment.getInterval().getStartMillis() < minTime) {
                    minTime = dataSegment.getInterval().getStartMillis();
                }
                if (dataSegment.getInterval().getEndMillis() <= maxTime) continue;
                maxTime = dataSegment.getInterval().getEndMillis();
            }
            Map tierStats = (Map)tiers.get(tier);
            if (tierStats == null) {
                tierStats = Maps.newHashMap();
                tiers.put(druidServer.getTier(), tierStats);
            }
            tierStats.put("segmentCount", ((HashSet)tierDistinctSegments.get(tier)).size());
            long segmentSize = MapUtils.getLong((Map)tierStats, (String)"size", (Long)0L);
            tierStats.put("size", segmentSize + dataSourceSegmentSize);
        }
        segments.put("count", totalDistinctSegments.size());
        segments.put("size", totalSegmentSize);
        segments.put("minTime", new DateTime(minTime));
        segments.put("maxTime", new DateTime(maxTime));
        return retVal;
    }

    @GET
    @Path(value="/{dataSourceName}/intervals/{interval}/serverview")
    @Produces(value={"application/json"})
    @ResourceFilters(value={DatasourceResourceFilter.class})
    public Response getSegmentDataSourceSpecificInterval(@PathParam(value="dataSourceName") String dataSourceName, @PathParam(value="interval") String interval, @QueryParam(value="partial") boolean partial) {
        VersionedIntervalTimeline<String, SegmentLoadInfo> timeline = this.serverInventoryView.getTimeline((DataSource)new TableDataSource(dataSourceName));
        Interval theInterval = new Interval((Object)interval.replace("_", "/"));
        if (timeline == null) {
            log.debug("No timeline found for datasource[%s]", new Object[]{dataSourceName});
            return Response.ok((Object)Lists.newArrayList()).build();
        }
        Iterable lookup = timeline.lookupWithIncompletePartitions(theInterval);
        FunctionalIterable retval = FunctionalIterable.create((Iterable)lookup).transformCat((Function)new Function<TimelineObjectHolder<String, SegmentLoadInfo>, Iterable<ImmutableSegmentLoadInfo>>(){

            public Iterable<ImmutableSegmentLoadInfo> apply(TimelineObjectHolder<String, SegmentLoadInfo> input) {
                return Iterables.transform((Iterable)input.getObject(), (Function)new Function<PartitionChunk<SegmentLoadInfo>, ImmutableSegmentLoadInfo>(){

                    public ImmutableSegmentLoadInfo apply(PartitionChunk<SegmentLoadInfo> chunk) {
                        return ((SegmentLoadInfo)chunk.getObject()).toImmutableSegmentLoadInfo();
                    }
                });
            }
        });
        return Response.ok((Object)retval).build();
    }
}

