/*
 * Decompiled with CFR 0.152.
 */
package io.druid.server.coordinator;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableSet;
import com.metamx.common.IAE;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class CoordinatorDynamicConfig {
    public static final String CONFIG_KEY = "coordinator.config";
    private final long millisToWaitBeforeDeleting;
    private final long mergeBytesLimit;
    private final int mergeSegmentsLimit;
    private final int maxSegmentsToMove;
    private final int replicantLifetime;
    private final int replicationThrottleLimit;
    private final int balancerComputeThreads;
    private final boolean emitBalancingStats;
    private final boolean killAllDataSources;
    private final Set<String> killDataSourceWhitelist;

    @JsonCreator
    public CoordinatorDynamicConfig(@JsonProperty(value="millisToWaitBeforeDeleting") long millisToWaitBeforeDeleting, @JsonProperty(value="mergeBytesLimit") long mergeBytesLimit, @JsonProperty(value="mergeSegmentsLimit") int mergeSegmentsLimit, @JsonProperty(value="maxSegmentsToMove") int maxSegmentsToMove, @JsonProperty(value="replicantLifetime") int replicantLifetime, @JsonProperty(value="replicationThrottleLimit") int replicationThrottleLimit, @JsonProperty(value="balancerComputeThreads") int balancerComputeThreads, @JsonProperty(value="emitBalancingStats") boolean emitBalancingStats, @JsonProperty(value="killDataSourceWhitelist") Object killDataSourceWhitelist, @JsonProperty(value="killAllDataSources") boolean killAllDataSources) {
        this.maxSegmentsToMove = maxSegmentsToMove;
        this.millisToWaitBeforeDeleting = millisToWaitBeforeDeleting;
        this.mergeSegmentsLimit = mergeSegmentsLimit;
        this.mergeBytesLimit = mergeBytesLimit;
        this.replicantLifetime = replicantLifetime;
        this.replicationThrottleLimit = replicationThrottleLimit;
        this.emitBalancingStats = emitBalancingStats;
        this.balancerComputeThreads = Math.max(balancerComputeThreads, 1);
        this.killAllDataSources = killAllDataSources;
        if (killDataSourceWhitelist instanceof String) {
            String[] tmp = ((String)killDataSourceWhitelist).split(",");
            this.killDataSourceWhitelist = new HashSet<String>();
            for (int i = 0; i < tmp.length; ++i) {
                String trimmed = tmp[i].trim();
                if (trimmed.isEmpty()) continue;
                this.killDataSourceWhitelist.add(trimmed);
            }
        } else {
            this.killDataSourceWhitelist = killDataSourceWhitelist instanceof Collection ? ImmutableSet.copyOf((Collection)((Collection)killDataSourceWhitelist)) : ImmutableSet.of();
        }
        if (this.killAllDataSources && !this.killDataSourceWhitelist.isEmpty()) {
            throw new IAE("can't have killAllDataSources and non-empty killDataSourceWhitelist", new Object[0]);
        }
    }

    @JsonProperty
    public long getMillisToWaitBeforeDeleting() {
        return this.millisToWaitBeforeDeleting;
    }

    @JsonProperty
    public long getMergeBytesLimit() {
        return this.mergeBytesLimit;
    }

    @JsonProperty
    public boolean emitBalancingStats() {
        return this.emitBalancingStats;
    }

    @JsonProperty
    public int getMergeSegmentsLimit() {
        return this.mergeSegmentsLimit;
    }

    @JsonProperty
    public int getMaxSegmentsToMove() {
        return this.maxSegmentsToMove;
    }

    @JsonProperty
    public int getReplicantLifetime() {
        return this.replicantLifetime;
    }

    @JsonProperty
    public int getReplicationThrottleLimit() {
        return this.replicationThrottleLimit;
    }

    @JsonProperty
    public int getBalancerComputeThreads() {
        return this.balancerComputeThreads;
    }

    @JsonProperty
    public Set<String> getKillDataSourceWhitelist() {
        return this.killDataSourceWhitelist;
    }

    @JsonProperty
    public boolean isKillAllDataSources() {
        return this.killAllDataSources;
    }

    public String toString() {
        return "CoordinatorDynamicConfig{millisToWaitBeforeDeleting=" + this.millisToWaitBeforeDeleting + ", mergeBytesLimit=" + this.mergeBytesLimit + ", mergeSegmentsLimit=" + this.mergeSegmentsLimit + ", maxSegmentsToMove=" + this.maxSegmentsToMove + ", replicantLifetime=" + this.replicantLifetime + ", replicationThrottleLimit=" + this.replicationThrottleLimit + ", balancerComputeThreads=" + this.balancerComputeThreads + ", emitBalancingStats=" + this.emitBalancingStats + ", killDataSourceWhitelist=" + this.killDataSourceWhitelist + ", killAllDataSources=" + this.killAllDataSources + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CoordinatorDynamicConfig that = (CoordinatorDynamicConfig)o;
        if (this.millisToWaitBeforeDeleting != that.millisToWaitBeforeDeleting) {
            return false;
        }
        if (this.mergeBytesLimit != that.mergeBytesLimit) {
            return false;
        }
        if (this.mergeSegmentsLimit != that.mergeSegmentsLimit) {
            return false;
        }
        if (this.maxSegmentsToMove != that.maxSegmentsToMove) {
            return false;
        }
        if (this.replicantLifetime != that.replicantLifetime) {
            return false;
        }
        if (this.replicationThrottleLimit != that.replicationThrottleLimit) {
            return false;
        }
        if (this.balancerComputeThreads != that.balancerComputeThreads) {
            return false;
        }
        if (this.emitBalancingStats != that.emitBalancingStats) {
            return false;
        }
        if (this.killAllDataSources != that.killAllDataSources) {
            return false;
        }
        return !(this.killDataSourceWhitelist == null ? that.killDataSourceWhitelist != null : !this.killDataSourceWhitelist.equals(that.killDataSourceWhitelist));
    }

    public int hashCode() {
        int result = (int)(this.millisToWaitBeforeDeleting ^ this.millisToWaitBeforeDeleting >>> 32);
        result = 31 * result + (int)(this.mergeBytesLimit ^ this.mergeBytesLimit >>> 32);
        result = 31 * result + this.mergeSegmentsLimit;
        result = 31 * result + this.maxSegmentsToMove;
        result = 31 * result + this.replicantLifetime;
        result = 31 * result + this.replicationThrottleLimit;
        result = 31 * result + this.balancerComputeThreads;
        result = 31 * result + (this.emitBalancingStats ? 1 : 0);
        result = 31 * result + (this.killAllDataSources ? 1 : 0);
        result = 31 * result + (this.killDataSourceWhitelist != null ? this.killDataSourceWhitelist.hashCode() : 0);
        return result;
    }

    public static class Builder {
        private long millisToWaitBeforeDeleting;
        private long mergeBytesLimit;
        private int mergeSegmentsLimit;
        private int maxSegmentsToMove;
        private int replicantLifetime;
        private int replicationThrottleLimit;
        private boolean emitBalancingStats;
        private int balancerComputeThreads;
        private Set<String> killDataSourceWhitelist;
        private boolean killAllDataSources;

        public Builder() {
            this(900000L, 524288000L, 100, 5, 15, 10, 1, false, null, false);
        }

        private Builder(long millisToWaitBeforeDeleting, long mergeBytesLimit, int mergeSegmentsLimit, int maxSegmentsToMove, int replicantLifetime, int replicationThrottleLimit, int balancerComputeThreads, boolean emitBalancingStats, Set<String> killDataSourceWhitelist, boolean killAllDataSources) {
            this.millisToWaitBeforeDeleting = millisToWaitBeforeDeleting;
            this.mergeBytesLimit = mergeBytesLimit;
            this.mergeSegmentsLimit = mergeSegmentsLimit;
            this.maxSegmentsToMove = maxSegmentsToMove;
            this.replicantLifetime = replicantLifetime;
            this.replicationThrottleLimit = replicationThrottleLimit;
            this.emitBalancingStats = emitBalancingStats;
            this.balancerComputeThreads = balancerComputeThreads;
            this.killDataSourceWhitelist = killDataSourceWhitelist;
            this.killAllDataSources = killAllDataSources;
        }

        public Builder withMillisToWaitBeforeDeleting(long millisToWaitBeforeDeleting) {
            this.millisToWaitBeforeDeleting = millisToWaitBeforeDeleting;
            return this;
        }

        public Builder withMergeBytesLimit(long mergeBytesLimit) {
            this.mergeBytesLimit = mergeBytesLimit;
            return this;
        }

        public Builder withMergeSegmentsLimit(int mergeSegmentsLimit) {
            this.mergeSegmentsLimit = mergeSegmentsLimit;
            return this;
        }

        public Builder withMaxSegmentsToMove(int maxSegmentsToMove) {
            this.maxSegmentsToMove = maxSegmentsToMove;
            return this;
        }

        public Builder withReplicantLifetime(int replicantLifetime) {
            this.replicantLifetime = replicantLifetime;
            return this;
        }

        public Builder withReplicationThrottleLimit(int replicationThrottleLimit) {
            this.replicationThrottleLimit = replicationThrottleLimit;
            return this;
        }

        public Builder withBalancerComputeThreads(int balancerComputeThreads) {
            this.balancerComputeThreads = balancerComputeThreads;
            return this;
        }

        public Builder withKillDataSourceWhitelist(Set<String> killDataSourceWhitelist) {
            this.killDataSourceWhitelist = killDataSourceWhitelist;
            return this;
        }

        public CoordinatorDynamicConfig build() {
            return new CoordinatorDynamicConfig(this.millisToWaitBeforeDeleting, this.mergeBytesLimit, this.mergeSegmentsLimit, this.maxSegmentsToMove, this.replicantLifetime, this.replicationThrottleLimit, this.balancerComputeThreads, this.emitBalancingStats, this.killDataSourceWhitelist, this.killAllDataSources);
        }
    }
}

