/*
 * Decompiled with CFR 0.152.
 */
package io.druid.metadata;

import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.metamx.common.ISE;
import com.metamx.common.RetryUtils;
import com.metamx.common.logger.Logger;
import io.druid.metadata.MetadataStorageConnector;
import io.druid.metadata.MetadataStorageConnectorConfig;
import io.druid.metadata.MetadataStorageTablesConfig;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLRecoverableException;
import java.sql.SQLTransientException;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.commons.dbcp2.BasicDataSource;
import org.skife.jdbi.v2.Batch;
import org.skife.jdbi.v2.DBI;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.Query;
import org.skife.jdbi.v2.TransactionCallback;
import org.skife.jdbi.v2.TransactionStatus;
import org.skife.jdbi.v2.Update;
import org.skife.jdbi.v2.exceptions.DBIException;
import org.skife.jdbi.v2.exceptions.UnableToExecuteStatementException;
import org.skife.jdbi.v2.exceptions.UnableToObtainConnectionException;
import org.skife.jdbi.v2.tweak.HandleCallback;
import org.skife.jdbi.v2.tweak.ResultSetMapper;
import org.skife.jdbi.v2.util.ByteArrayMapper;
import org.skife.jdbi.v2.util.IntegerMapper;

public abstract class SQLMetadataConnector
implements MetadataStorageConnector {
    private static final Logger log = new Logger(SQLMetadataConnector.class);
    private static final String PAYLOAD_TYPE = "BLOB";
    public static final int DEFAULT_MAX_TRIES = 10;
    private final Supplier<MetadataStorageConnectorConfig> config;
    private final Supplier<MetadataStorageTablesConfig> tablesConfigSupplier;
    private final Predicate<Throwable> shouldRetry;

    public SQLMetadataConnector(Supplier<MetadataStorageConnectorConfig> config, Supplier<MetadataStorageTablesConfig> tablesConfigSupplier) {
        this.config = config;
        this.tablesConfigSupplier = tablesConfigSupplier;
        this.shouldRetry = new Predicate<Throwable>(){

            public boolean apply(Throwable e) {
                return SQLMetadataConnector.this.isTransientException(e);
            }
        };
    }

    protected String getPayloadType() {
        return PAYLOAD_TYPE;
    }

    protected abstract String getSerialType();

    protected abstract int getStreamingFetchSize();

    public String getValidationQuery() {
        return "SELECT 1";
    }

    public abstract boolean tableExists(Handle var1, String var2);

    public <T> T retryWithHandle(final HandleCallback<T> callback, Predicate<Throwable> myShouldRetry) {
        Callable call = new Callable<T>(){

            @Override
            public T call() throws Exception {
                return SQLMetadataConnector.this.getDBI().withHandle(callback);
            }
        };
        try {
            return (T)RetryUtils.retry((Callable)call, myShouldRetry, (int)10);
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public <T> T retryWithHandle(HandleCallback<T> callback) {
        return this.retryWithHandle(callback, this.shouldRetry);
    }

    public <T> T retryTransaction(final TransactionCallback<T> callback, int quietTries, int maxTries) {
        Callable call = new Callable<T>(){

            @Override
            public T call() throws Exception {
                return SQLMetadataConnector.this.getDBI().inTransaction(callback);
            }
        };
        try {
            return (T)RetryUtils.retry((Callable)call, this.shouldRetry, (int)quietTries, (int)maxTries);
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public final boolean isTransientException(Throwable e) {
        return e != null && (e instanceof SQLTransientException || e instanceof SQLRecoverableException || e instanceof UnableToObtainConnectionException || e instanceof UnableToExecuteStatementException || this.connectorIsTransientException(e) || e instanceof SQLException && this.isTransientException(e.getCause()) || e instanceof DBIException && this.isTransientException(e.getCause()));
    }

    protected boolean connectorIsTransientException(Throwable e) {
        return false;
    }

    public void createTable(final String tableName, final Iterable<String> sql) {
        try {
            this.retryWithHandle(new HandleCallback<Void>(){

                public Void withHandle(Handle handle) throws Exception {
                    if (!SQLMetadataConnector.this.tableExists(handle, tableName)) {
                        log.info("Creating table[%s]", new Object[]{tableName});
                        Batch batch = handle.createBatch();
                        for (String s : sql) {
                            batch.add(s);
                        }
                        batch.execute();
                    } else {
                        log.info("Table[%s] already exists", new Object[]{tableName});
                    }
                    return null;
                }
            });
        }
        catch (Exception e) {
            log.warn((Throwable)e, "Exception creating table", new Object[0]);
        }
    }

    public void createPendingSegmentsTable(String tableName) {
        this.createTable(tableName, (Iterable<String>)ImmutableList.of((Object)String.format("CREATE TABLE %1$s (\n  id VARCHAR(255) NOT NULL,\n  dataSource VARCHAR(255) NOT NULL,\n  created_date VARCHAR(255) NOT NULL,\n  start VARCHAR(255) NOT NULL,\n  \"end\" VARCHAR(255) NOT NULL,\n  sequence_name VARCHAR(255) NOT NULL,\n  sequence_prev_id VARCHAR(255) NOT NULL,\n  sequence_name_prev_id_sha1 VARCHAR(255) NOT NULL,\n  payload %2$s NOT NULL,\n  PRIMARY KEY (id),\n  UNIQUE (sequence_name_prev_id_sha1)\n)", tableName, this.getPayloadType())));
    }

    public void createDataSourceTable(String tableName) {
        this.createTable(tableName, (Iterable<String>)ImmutableList.of((Object)String.format("CREATE TABLE %1$s (\n  dataSource VARCHAR(255) NOT NULL,\n  created_date VARCHAR(255) NOT NULL,\n  commit_metadata_payload %2$s NOT NULL,\n  commit_metadata_sha1 VARCHAR(255) NOT NULL,\n  PRIMARY KEY (dataSource)\n)", tableName, this.getPayloadType())));
    }

    public void createSegmentTable(String tableName) {
        this.createTable(tableName, (Iterable<String>)ImmutableList.of((Object)String.format("CREATE TABLE %1$s (\n  id VARCHAR(255) NOT NULL,\n  dataSource VARCHAR(255) NOT NULL,\n  created_date VARCHAR(255) NOT NULL,\n  start VARCHAR(255) NOT NULL,\n  \"end\" VARCHAR(255) NOT NULL,\n  partitioned BOOLEAN NOT NULL,\n  version VARCHAR(255) NOT NULL,\n  used BOOLEAN NOT NULL,\n  payload %2$s NOT NULL,\n  PRIMARY KEY (id)\n)", tableName, this.getPayloadType()), (Object)String.format("CREATE INDEX idx_%1$s_datasource ON %1$s(dataSource)", tableName), (Object)String.format("CREATE INDEX idx_%1$s_used ON %1$s(used)", tableName)));
    }

    public void createRulesTable(String tableName) {
        this.createTable(tableName, (Iterable<String>)ImmutableList.of((Object)String.format("CREATE TABLE %1$s (\n  id VARCHAR(255) NOT NULL,\n  dataSource VARCHAR(255) NOT NULL,\n  version VARCHAR(255) NOT NULL,\n  payload %2$s NOT NULL,\n  PRIMARY KEY (id)\n)", tableName, this.getPayloadType()), (Object)String.format("CREATE INDEX idx_%1$s_datasource ON %1$s(dataSource)", tableName)));
    }

    public void createConfigTable(String tableName) {
        this.createTable(tableName, (Iterable<String>)ImmutableList.of((Object)String.format("CREATE TABLE %1$s (\n  name VARCHAR(255) NOT NULL,\n  payload %2$s NOT NULL,\n  PRIMARY KEY(name)\n)", tableName, this.getPayloadType())));
    }

    public void createEntryTable(String tableName) {
        this.createTable(tableName, (Iterable<String>)ImmutableList.of((Object)String.format("CREATE TABLE %1$s (\n  id VARCHAR(255) NOT NULL,\n  created_date VARCHAR(255) NOT NULL,\n  datasource VARCHAR(255) NOT NULL,\n  payload %2$s NOT NULL,\n  status_payload %2$s NOT NULL,\n  active BOOLEAN NOT NULL DEFAULT FALSE,\n  PRIMARY KEY (id)\n)", tableName, this.getPayloadType()), (Object)String.format("CREATE INDEX idx_%1$s_active_created_date ON %1$s(active, created_date)", tableName)));
    }

    public void createLogTable(String tableName, String entryTypeName) {
        this.createTable(tableName, (Iterable<String>)ImmutableList.of((Object)String.format("CREATE TABLE %1$s (\n  id %2$s NOT NULL,\n  %4$s_id VARCHAR(255) DEFAULT NULL,\n  log_payload %3$s,\n  PRIMARY KEY (id)\n)", tableName, this.getSerialType(), this.getPayloadType(), entryTypeName), (Object)String.format("CREATE INDEX idx_%1$s_%2$s_id ON %1$s(%2$s_id)", tableName, entryTypeName)));
    }

    public void createLockTable(String tableName, String entryTypeName) {
        this.createTable(tableName, (Iterable<String>)ImmutableList.of((Object)String.format("CREATE TABLE %1$s (\n  id %2$s NOT NULL,\n  %4$s_id VARCHAR(255) DEFAULT NULL,\n  lock_payload %3$s,\n  PRIMARY KEY (id)\n)", tableName, this.getSerialType(), this.getPayloadType(), entryTypeName), (Object)String.format("CREATE INDEX idx_%1$s_%2$s_id ON %1$s(%2$s_id)", tableName, entryTypeName)));
    }

    public void createSupervisorsTable(String tableName) {
        this.createTable(tableName, (Iterable<String>)ImmutableList.of((Object)String.format("CREATE TABLE %1$s (\n  id %2$s NOT NULL,\n  spec_id VARCHAR(255) NOT NULL,\n  created_date VARCHAR(255) NOT NULL,\n  payload %3$s NOT NULL,\n  PRIMARY KEY (id)\n)", tableName, this.getSerialType(), this.getPayloadType()), (Object)String.format("CREATE INDEX idx_%1$s_spec_id ON %1$s(spec_id)", tableName)));
    }

    public Void insertOrUpdate(final String tableName, final String keyColumn, final String valueColumn, final String key, final byte[] value) throws Exception {
        return (Void)this.getDBI().inTransaction((TransactionCallback)new TransactionCallback<Void>(){

            public Void inTransaction(Handle handle, TransactionStatus transactionStatus) throws Exception {
                int count = (Integer)((Query)handle.createQuery(String.format("SELECT COUNT(*) FROM %1$s WHERE %2$s = :key", tableName, keyColumn)).bind("key", key)).map((ResultSetMapper)IntegerMapper.FIRST).first();
                if (count == 0) {
                    ((Update)((Update)handle.createStatement(String.format("INSERT INTO %1$s (%2$s, %3$s) VALUES (:key, :value)", tableName, keyColumn, valueColumn)).bind("key", key)).bind("value", value)).execute();
                } else {
                    ((Update)((Update)handle.createStatement(String.format("UPDATE %1$s SET %3$s=:value WHERE %2$s=:key", tableName, keyColumn, valueColumn)).bind("key", key)).bind("value", value)).execute();
                }
                return null;
            }
        });
    }

    public abstract DBI getDBI();

    public void createDataSourceTable() {
        if (((MetadataStorageConnectorConfig)this.config.get()).isCreateTables()) {
            this.createDataSourceTable(((MetadataStorageTablesConfig)this.tablesConfigSupplier.get()).getDataSourceTable());
        }
    }

    public void createPendingSegmentsTable() {
        if (((MetadataStorageConnectorConfig)this.config.get()).isCreateTables()) {
            this.createPendingSegmentsTable(((MetadataStorageTablesConfig)this.tablesConfigSupplier.get()).getPendingSegmentsTable());
        }
    }

    public void createSegmentTable() {
        if (((MetadataStorageConnectorConfig)this.config.get()).isCreateTables()) {
            this.createSegmentTable(((MetadataStorageTablesConfig)this.tablesConfigSupplier.get()).getSegmentsTable());
        }
    }

    public void createRulesTable() {
        if (((MetadataStorageConnectorConfig)this.config.get()).isCreateTables()) {
            this.createRulesTable(((MetadataStorageTablesConfig)this.tablesConfigSupplier.get()).getRulesTable());
        }
    }

    public void createConfigTable() {
        if (((MetadataStorageConnectorConfig)this.config.get()).isCreateTables()) {
            this.createConfigTable(((MetadataStorageTablesConfig)this.tablesConfigSupplier.get()).getConfigTable());
        }
    }

    public void createTaskTables() {
        if (((MetadataStorageConnectorConfig)this.config.get()).isCreateTables()) {
            MetadataStorageTablesConfig tablesConfig = (MetadataStorageTablesConfig)this.tablesConfigSupplier.get();
            String entryType = tablesConfig.getTaskEntryType();
            this.createEntryTable(tablesConfig.getEntryTable(entryType));
            this.createLogTable(tablesConfig.getLogTable(entryType), entryType);
            this.createLockTable(tablesConfig.getLockTable(entryType), entryType);
        }
    }

    public void createSupervisorsTable() {
        if (((MetadataStorageConnectorConfig)this.config.get()).isCreateTables()) {
            this.createSupervisorsTable(((MetadataStorageTablesConfig)this.tablesConfigSupplier.get()).getSupervisorTable());
        }
    }

    public byte[] lookup(final String tableName, final String keyColumn, final String valueColumn, final String key) {
        return (byte[])this.getDBI().withHandle((HandleCallback)new HandleCallback<byte[]>(){

            public byte[] withHandle(Handle handle) throws Exception {
                return SQLMetadataConnector.this.lookupWithHandle(handle, tableName, keyColumn, valueColumn, key);
            }
        });
    }

    public byte[] lookupWithHandle(Handle handle, String tableName, String keyColumn, String valueColumn, String key) {
        String selectStatement = String.format("SELECT %s FROM %s WHERE %s = :key", valueColumn, tableName, keyColumn);
        List matched = ((Query)handle.createQuery(selectStatement).bind("key", key)).map((ResultSetMapper)ByteArrayMapper.FIRST).list();
        if (matched.isEmpty()) {
            return null;
        }
        if (matched.size() > 1) {
            throw new ISE("Error! More than one matching entry[%d] found for [%s]?!", new Object[]{matched.size(), key});
        }
        return (byte[])matched.get(0);
    }

    public MetadataStorageConnectorConfig getConfig() {
        return (MetadataStorageConnectorConfig)this.config.get();
    }

    protected BasicDataSource getDatasource() {
        MetadataStorageConnectorConfig connectorConfig = this.getConfig();
        BasicDataSource dataSource = new BasicDataSource();
        dataSource.setUsername(connectorConfig.getUser());
        dataSource.setPassword(connectorConfig.getPassword());
        String uri = connectorConfig.getConnectURI();
        dataSource.setUrl(uri);
        dataSource.setValidationQuery(this.getValidationQuery());
        dataSource.setTestOnBorrow(true);
        return dataSource;
    }

    protected final <T> T inReadOnlyTransaction(final TransactionCallback<T> callback) {
        return (T)this.getDBI().withHandle(new HandleCallback<T>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public T withHandle(Handle handle) throws Exception {
                Connection connection = handle.getConnection();
                boolean readOnly = connection.isReadOnly();
                connection.setReadOnly(true);
                try {
                    Object object = handle.inTransaction(callback);
                    return object;
                }
                finally {
                    try {
                        connection.setReadOnly(readOnly);
                    }
                    catch (SQLException e) {
                        log.error((Throwable)e, "Unable to reset connection read-only state", new Object[0]);
                    }
                }
            }
        });
    }

    private void createAuditTable(String tableName) {
        this.createTable(tableName, (Iterable<String>)ImmutableList.of((Object)String.format("CREATE TABLE %1$s (\n  id %2$s NOT NULL,\n  audit_key VARCHAR(255) NOT NULL,\n  type VARCHAR(255) NOT NULL,\n  author VARCHAR(255) NOT NULL,\n  comment VARCHAR(2048) NOT NULL,\n  created_date VARCHAR(255) NOT NULL,\n  payload %3$s NOT NULL,\n  PRIMARY KEY(id)\n)", tableName, this.getSerialType(), this.getPayloadType()), (Object)String.format("CREATE INDEX idx_%1$s_key_time ON %1$s(audit_key, created_date)", tableName), (Object)String.format("CREATE INDEX idx_%1$s_type_time ON %1$s(type, created_date)", tableName), (Object)String.format("CREATE INDEX idx_%1$s_audit_time ON %1$s(created_date)", tableName)));
    }

    public void createAuditTable() {
        if (((MetadataStorageConnectorConfig)this.config.get()).isCreateTables()) {
            this.createAuditTable(((MetadataStorageTablesConfig)this.tablesConfigSupplier.get()).getAuditTable());
        }
    }
}

