/*
 * Decompiled with CFR 0.152.
 */
package io.druid.client.cache;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.metamx.emitter.service.ServiceEmitter;
import io.druid.client.cache.Cache;
import io.druid.client.cache.CacheStats;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;

public class HybridCache
implements Cache {
    private final Cache level1;
    private final Cache level2;
    private final AtomicLong hitCount = new AtomicLong(0L);
    private final AtomicLong missCount = new AtomicLong(0L);

    public HybridCache(Cache level1, Cache level2) {
        this.level1 = level1;
        this.level2 = level2;
    }

    @Override
    public byte[] get(Cache.NamedKey key) {
        byte[] res = this.level1.get(key);
        if (res == null) {
            res = this.level2.get(key);
            if (res != null) {
                this.level1.put(key, res);
                this.hitCount.incrementAndGet();
                return res;
            }
            this.missCount.incrementAndGet();
        }
        if (res != null) {
            this.hitCount.incrementAndGet();
        }
        return res;
    }

    @Override
    public void put(Cache.NamedKey key, byte[] value) {
        this.level1.put(key, value);
        this.level2.put(key, value);
    }

    @Override
    public Map<Cache.NamedKey, byte[]> getBulk(Iterable<Cache.NamedKey> keys) {
        HashSet remaining = Sets.newHashSet(keys);
        HashMap res = this.level1.getBulk(keys);
        this.hitCount.addAndGet(res.size());
        remaining = Sets.difference((Set)remaining, res.keySet());
        if (!remaining.isEmpty()) {
            Map<Cache.NamedKey, byte[]> res2 = this.level2.getBulk(remaining);
            for (Map.Entry<Cache.NamedKey, byte[]> entry : res2.entrySet()) {
                this.level1.put(entry.getKey(), entry.getValue());
            }
            int size = res2.size();
            this.hitCount.addAndGet(size);
            this.missCount.addAndGet(remaining.size() - size);
            if (size != 0) {
                res = Maps.newHashMap(res);
                res.putAll(res2);
            }
        }
        return res;
    }

    @Override
    public void close(String namespace) {
        this.level1.close(namespace);
        this.level2.close(namespace);
    }

    @Override
    public CacheStats getStats() {
        CacheStats stats1 = this.level1.getStats();
        CacheStats stats2 = this.level2.getStats();
        return new CacheStats(this.hitCount.get(), this.missCount.get(), stats1.getNumEntries() + stats2.getNumEntries(), stats1.getSizeInBytes() + stats2.getSizeInBytes(), stats1.getNumEvictions() + stats2.getNumEvictions(), stats1.getNumTimeouts() + stats2.getNumTimeouts(), stats1.getNumErrors() + stats2.getNumErrors());
    }

    @Override
    public boolean isLocal() {
        return this.level1.isLocal() && this.level2.isLocal();
    }

    @Override
    public void doMonitor(ServiceEmitter emitter) {
        this.level1.doMonitor(emitter);
        this.level2.doMonitor(emitter);
    }
}

