/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.util.shell.commands;

import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.util.shell.Shell;
import org.apache.accumulo.core.util.shell.commands.OptUtil;
import org.apache.accumulo.core.util.shell.commands.TableOperation;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.hadoop.io.Text;

public class FlushCommand
extends TableOperation {
    private Text startRow;
    private Text endRow;
    private boolean wait;
    private Option waitOpt;

    @Override
    public String description() {
        return "flushes a tables data that is currently in memory to disk";
    }

    @Override
    protected void doTableOp(Shell shellState, String tableName) throws AccumuloException, AccumuloSecurityException, TableNotFoundException {
        shellState.getConnector().tableOperations().flush(tableName, this.startRow, this.endRow, this.wait);
        Shell.log.info((Object)("Flush of table " + tableName + (this.wait ? " completed." : " initiated...")));
    }

    @Override
    public int execute(String fullCommand, CommandLine cl, Shell shellState) throws Exception {
        this.wait = cl.hasOption(this.waitOpt.getLongOpt());
        this.startRow = OptUtil.getStartRow(cl);
        this.endRow = OptUtil.getEndRow(cl);
        return super.execute(fullCommand, cl, shellState);
    }

    @Override
    public Options getOptions() {
        Options opts = super.getOptions();
        this.waitOpt = new Option("w", "wait", false, "wait for flush to finish");
        opts.addOption(this.waitOpt);
        opts.addOption(OptUtil.startRowOpt());
        opts.addOption(OptUtil.endRowOpt());
        return opts;
    }
}

