/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.iterators.user;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.accumulo.core.Constants;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.data.ByteSequence;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.Filter;
import org.apache.accumulo.core.iterators.IteratorEnvironment;
import org.apache.accumulo.core.iterators.OptionDescriber;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;

public class RegExFilter
extends Filter {
    public static final String ROW_REGEX = "rowRegex";
    public static final String COLF_REGEX = "colfRegex";
    public static final String COLQ_REGEX = "colqRegex";
    public static final String VALUE_REGEX = "valueRegex";
    public static final String OR_FIELDS = "orFields";
    public static final String ENCODING = "encoding";
    public static final String MATCH_SUBSTRING = "matchSubstring";
    public static final String ENCODING_DEFAULT = Constants.UTF8.name();
    private Matcher rowMatcher;
    private Matcher colfMatcher;
    private Matcher colqMatcher;
    private Matcher valueMatcher;
    private boolean orFields = false;
    private boolean matchSubstring = false;
    private String encoding = ENCODING_DEFAULT;

    @Override
    public SortedKeyValueIterator<Key, Value> deepCopy(IteratorEnvironment env) {
        RegExFilter result = (RegExFilter)super.deepCopy(env);
        result.rowMatcher = this.copyMatcher(this.rowMatcher);
        result.colfMatcher = this.copyMatcher(this.colfMatcher);
        result.colqMatcher = this.copyMatcher(this.colqMatcher);
        result.valueMatcher = this.copyMatcher(this.valueMatcher);
        result.orFields = this.orFields;
        return result;
    }

    private Matcher copyMatcher(Matcher m) {
        if (m == null) {
            return m;
        }
        return m.pattern().matcher("");
    }

    private boolean matches(Matcher matcher, ByteSequence bs) {
        if (matcher != null) {
            try {
                matcher.reset(new String(bs.getBackingArray(), bs.offset(), bs.length(), this.encoding));
                return this.matchSubstring ? matcher.find() : matcher.matches();
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return !this.orFields;
    }

    private boolean matches(Matcher matcher, byte[] data, int offset, int len) {
        if (matcher != null) {
            try {
                matcher.reset(new String(data, offset, len, this.encoding));
                return this.matchSubstring ? matcher.find() : matcher.matches();
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return !this.orFields;
    }

    @Override
    public boolean accept(Key key, Value value) {
        if (this.orFields) {
            return this.matches(this.rowMatcher, this.rowMatcher == null ? null : key.getRowData()) || this.matches(this.colfMatcher, this.colfMatcher == null ? null : key.getColumnFamilyData()) || this.matches(this.colqMatcher, this.colqMatcher == null ? null : key.getColumnQualifierData()) || this.matches(this.valueMatcher, value.get(), 0, value.get().length);
        }
        return this.matches(this.rowMatcher, this.rowMatcher == null ? null : key.getRowData()) && this.matches(this.colfMatcher, this.colfMatcher == null ? null : key.getColumnFamilyData()) && this.matches(this.colqMatcher, this.colqMatcher == null ? null : key.getColumnQualifierData()) && this.matches(this.valueMatcher, value.get(), 0, value.get().length);
    }

    @Override
    public void init(SortedKeyValueIterator<Key, Value> source, Map<String, String> options, IteratorEnvironment env) throws IOException {
        super.init(source, options, env);
        this.rowMatcher = options.containsKey(ROW_REGEX) ? Pattern.compile(options.get(ROW_REGEX)).matcher("") : null;
        this.colfMatcher = options.containsKey(COLF_REGEX) ? Pattern.compile(options.get(COLF_REGEX)).matcher("") : null;
        this.colqMatcher = options.containsKey(COLQ_REGEX) ? Pattern.compile(options.get(COLQ_REGEX)).matcher("") : null;
        this.valueMatcher = options.containsKey(VALUE_REGEX) ? Pattern.compile(options.get(VALUE_REGEX)).matcher("") : null;
        this.orFields = options.containsKey(OR_FIELDS) ? Boolean.parseBoolean(options.get(OR_FIELDS)) : false;
        this.matchSubstring = options.containsKey(MATCH_SUBSTRING) ? Boolean.parseBoolean(options.get(MATCH_SUBSTRING)) : false;
        if (options.containsKey(ENCODING)) {
            this.encoding = options.get(ENCODING);
        }
    }

    @Override
    public OptionDescriber.IteratorOptions describeOptions() {
        OptionDescriber.IteratorOptions io = super.describeOptions();
        io.setName("regex");
        io.setDescription("The RegExFilter/Iterator allows you to filter for key/value pairs based on regular expressions");
        io.addNamedOption(ROW_REGEX, "regular expression on row");
        io.addNamedOption(COLF_REGEX, "regular expression on column family");
        io.addNamedOption(COLQ_REGEX, "regular expression on column qualifier");
        io.addNamedOption(VALUE_REGEX, "regular expression on value");
        io.addNamedOption(OR_FIELDS, "use OR instead of AND when multiple regexes given");
        io.addNamedOption(MATCH_SUBSTRING, "match on substrings");
        io.addNamedOption(ENCODING, "character encoding of byte array value (default is " + ENCODING_DEFAULT + ")");
        return io;
    }

    @Override
    public boolean validateOptions(Map<String, String> options) {
        if (!super.validateOptions(options)) {
            return false;
        }
        try {
            if (options.containsKey(ROW_REGEX)) {
                Pattern.compile(options.get(ROW_REGEX)).matcher("");
            }
            if (options.containsKey(COLF_REGEX)) {
                Pattern.compile(options.get(COLF_REGEX)).matcher("");
            }
            if (options.containsKey(COLQ_REGEX)) {
                Pattern.compile(options.get(COLQ_REGEX)).matcher("");
            }
            if (options.containsKey(VALUE_REGEX)) {
                Pattern.compile(options.get(VALUE_REGEX)).matcher("");
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("bad regex", e);
        }
        if (options.containsKey(ENCODING)) {
            try {
                this.encoding = options.get(ENCODING);
                if ("".equals(this.encoding)) {
                    this.encoding = ENCODING_DEFAULT;
                }
                new String("test".getBytes(Constants.UTF8), this.encoding);
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalArgumentException("invalid encoding encoding:" + this.encoding, e);
            }
        }
        return true;
    }

    public static void setRegexs(IteratorSetting si, String rowTerm, String cfTerm, String cqTerm, String valueTerm, boolean orFields) {
        RegExFilter.setRegexs(si, rowTerm, cfTerm, cqTerm, valueTerm, orFields, false);
    }

    public static void setRegexs(IteratorSetting si, String rowTerm, String cfTerm, String cqTerm, String valueTerm, boolean orFields, boolean matchSubstring) {
        if (rowTerm != null) {
            si.addOption(ROW_REGEX, rowTerm);
        }
        if (cfTerm != null) {
            si.addOption(COLF_REGEX, cfTerm);
        }
        if (cqTerm != null) {
            si.addOption(COLQ_REGEX, cqTerm);
        }
        if (valueTerm != null) {
            si.addOption(VALUE_REGEX, valueTerm);
        }
        si.addOption(OR_FIELDS, String.valueOf(orFields));
        si.addOption(MATCH_SUBSTRING, String.valueOf(matchSubstring));
    }

    public static void setEncoding(IteratorSetting si, String encoding) {
        if (!encoding.isEmpty()) {
            si.addOption(ENCODING, encoding);
        }
    }
}

